/******************************************************************************
 ** $Id: Fenster.java 1017 2016-05-28 20:35:09Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.Eigenschaften;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

/** Hauptfenster von JaFuffy, falls als Applikation gestartet. */
@SuppressWarnings("serial")
public class Fenster extends JFrame implements PropertyChangeListener {

    /** Abstand vom Fensterrahmen zum Inhalt. */
    private static final int RAHMENABSTAND = 4;
    /** Gibt an, ob der Look & Feel schon initialisiert wurde. */
    private boolean initialisiert = false;

    /**
     * Konstruktor.
     *
     * @param titel
     *            Fenstertitel
     */
    public Fenster(String titel) {
        super(titel);
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        setIconImages(Oberflaeche.LOGOS);
        UIManager.addPropertyChangeListener(this);
    }

    /**
     * Fensterinhalt setzen, anschlieend Fenster packen und sichtbar machen.
     *
     * @param eigenschaften
     *            Globale Eigenschaften von JaFuffy.
     * @param menue
     *            Drop-Down-Men.
     * @param spielplatz
     *            Der Spielplatz fr Punktezettel und Wrfelfeld.
     */
    public void zeige(Eigenschaften eigenschaften, Menue menue, Spielplatz spielplatz) {
        setJMenuBar(menue);
        spielplatz.setBorder(new EmptyBorder(RAHMENABSTAND, RAHMENABSTAND, RAHMENABSTAND, RAHMENABSTAND));
        setContentPane(spielplatz);
        if (eigenschaften.erststart()) {
            setLocationRelativeTo(null);
            pack();
        } else {
            setBounds(Integer.parseInt(eigenschaften.getProperty("X")),
                    Integer.parseInt(eigenschaften.getProperty("Y")),
                    Integer.parseInt(eigenschaften.getProperty("Breite")),
                    Integer.parseInt(eigenschaften.getProperty("Hoehe")));
        }
        setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (initialisiert) {
            SwingUtilities.updateComponentTreeUI(this);
            if (event.getOldValue().getClass() != event.getNewValue().getClass()) {
                if (JOptionPane.showConfirmDialog(this, "Fenstergre an Look & Feel anpassen?", "JaFuffy (Frage)",
                        JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                    pack();
                }
            }
        } else {
            initialisiert = true;
        }
    }

}
