/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import jafuffy.logik.Analyse;
import jafuffy.logik.Kombinatorik;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Klassisch
extends Analyse {
    private static final long serialVersionUID = -3852043350163717864L;

    public Klassisch(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    @Override
    protected Analyse.Eintragungen eintragungen() {
        return new Eintragungen();
    }

    class Dreierpasch
    extends Analyse.Pasch {
        private static final long serialVersionUID = 1347995442616468479L;
        private static final int PASCHGROESSE = 3;

        Dreierpasch() {
            super(3);
        }

        @Override
        protected double augensumme(int a, int r, int k) {
            if (k != 2) {
                throw new IllegalArgumentException("Falsche Mehrlingsl\u00e4nge");
            }
            if (r > 0) {
                double augensumme = (double)(4 * (a + 4)) * this.augensumme(a, r - 1, 2) + 66.0 * Kombinatorik.augenzahl(r) - 2.0 * Kombinatorik.augenzahl(a, r - 1) + (double)(90 * a) + 21.0;
                int alpha = a + 1;
                while (alpha <= 6) {
                    augensumme += 4.0 * this.augensumme(alpha, r - 1, 2);
                    ++alpha;
                }
                return augensumme *= 0.013888888888888888;
            }
            return 0.0;
        }

        @Override
        protected boolean pasch() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }
    }

    protected class Eintragungen
    extends Analyse.Eintragungen {
        private static final long serialVersionUID = -7416744679857533889L;

        Eintragungen() {
            this.put(Tabzeile.DREIERPASCH, new Dreierpasch());
            this.put(Tabzeile.VIERERPASCH, new Viererpasch());
            this.put(Tabzeile.FULLHOUSE, new FullHouse());
            this.put(Tabzeile.KLEINESTRASSE, new KleineStrasse());
            this.put(Tabzeile.GROSSESTRASSE, new GrosseStrasse());
            this.put(Tabzeile.JAFUFFY, new JaFuffy());
        }
    }

    class FullHouse
    extends Analyse.Unten {
        private static final long serialVersionUID = -1069152277729232203L;
        static final int PUNKTE = 25;
        private final double[] restwahrscheinlichkeit = new double[]{0.03935185185185185, 0.23148148148148148, 0.1736111111111111, 0.46296296296296297, 0.0, 0.09259259259259259};
        private int fehlend;

        FullHouse() {
            this.mittel = this.prognose(5, 3);
        }

        private boolean istFullHouse() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.ZWEIERPASCH) != false && (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }

        private double prognose(int k, int r) {
            return 25.0 * this.restwahrscheinlichkeit(k, r);
        }

        private double restwahrscheinlichkeit(int k, int r) {
            switch (k) {
                case 0: {
                    return 1.0;
                }
                case 1: {
                    return 1.0 - Math.pow(0.6666666666666666, r);
                }
                case 2: {
                    return 1.0 - Math.pow(0.8333333333333334, r);
                }
                case 3: {
                    switch (r) {
                        case 1: {
                            return 0.09722222222222222;
                        }
                        case 2: {
                            return 0.27469135802469136;
                        }
                    }
                    return 0.0;
                }
                case 5: {
                    if (r == 0) {
                        return 0.0;
                    }
                    double p = 0.0;
                    int i = 0;
                    while (i <= 5) {
                        p += this.restwahrscheinlichkeit[i] * this.restwahrscheinlichkeit(i, r - 1);
                        ++i;
                    }
                    return p;
                }
            }
            return 0.0;
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            return this.prognose(this.fehlend, spieler.rest());
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = this.istFullHouse() ? 25 : 0;
        }

        @Override
        protected void waehle(Spieler spieler) {
            if (this.istFullHouse()) {
                this.fehlend = 0;
            } else if (((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.DREIERPASCH)).booleanValue() || ((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH)).booleanValue()) {
                int zaehler = 0;
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                int n = wuerfelArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Wuerfel w;
                    this.neuwurfkarte.put(w, (w = wuerfelArray[n2]).vorkommen(Klassisch.this.augenhaeufigkeiten) < Analyse.Paschaufzaehlung.DREIERPASCH.groesse() || zaehler == Analyse.Paschaufzaehlung.DREIERPASCH.groesse());
                    if (w.vorkommen(Klassisch.this.augenhaeufigkeiten) >= Analyse.Paschaufzaehlung.DREIERPASCH.groesse()) {
                        ++zaehler;
                    }
                    ++n2;
                }
                this.fehlend = 2;
            } else if (((Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.ZWEIERPASCH)).booleanValue()) {
                this.fehlend = 0;
                Object[] objectArray = Klassisch.this.augenhaeufigkeiten;
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int haeufigkeit = objectArray[n3];
                    if (haeufigkeit == Analyse.Paschaufzaehlung.ZWEIERPASCH.groesse()) {
                        this.fehlend = this.fehlend == 0 ? 3 : 1;
                    }
                    ++n3;
                }
                Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                objectArray = wuerfelArray;
                n = wuerfelArray.length;
                n3 = 0;
                while (n3 < n) {
                    int w;
                    this.neuwurfkarte.put(w, (w = objectArray[n3]).vorkommen(Klassisch.this.augenhaeufigkeiten) < Analyse.Paschaufzaehlung.ZWEIERPASCH.groesse());
                    ++n3;
                }
            } else {
                this.nominiereNeuwurf(true);
                this.fehlend = 5;
            }
        }
    }

    public class GrosseStrasse
    extends Analyse.Unten {
        private static final long serialVersionUID = 8292592862416663732L;
        public static final int PUNKTE = 40;
        private final int[] kandidat = new int[6];
        private int fehlend;

        GrosseStrasse() {
            this.mittel = 40.0 * this.q(5, 3);
        }

        private double p(int n, int r) {
            if (r > 1) {
                double summe = 0.0;
                int i = 0;
                while (i <= n) {
                    summe += this.u(n, i) * this.p(n - i, r - 1);
                    ++i;
                }
                return summe;
            }
            return (double)Kombinatorik.fakultaet(n) / Math.pow(6.0, n);
        }

        private double q(int n, int r) {
            if (r > 1) {
                double summe = 0.0;
                int i = 0;
                while (i <= n) {
                    summe += this.w(n, i) * this.p(n - i, r - 1) + this.v(n, i) * this.q(n - i, r - 1);
                    ++i;
                }
                return summe;
            }
            if (n > 0) {
                return (double)(2 * Kombinatorik.fakultaet(n)) / Math.pow(6.0, n);
            }
            return 0.0;
        }

        private double u(int n, int i) {
            return Kombinatorik.strassenteilsequenz(n, 6 - n, i, n) / Math.pow(6.0, n);
        }

        private double v(int n, int i) {
            return Kombinatorik.strassenteilsequenz(n, 5 - n, i, n - 1) / Math.pow(6.0, n);
        }

        private double w(int n, int i) {
            return (double)(i * Kombinatorik.fallend(n - 1, i - 1) * (2 * Kombinatorik.strassenteilschablone(n, 5 - n, i) + (i + 1) * Kombinatorik.strassenteilschablone(n, 5 - n, i + 1))) / Math.pow(6.0, n);
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = Analyse.Index.ZWEIER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && Analyse.Index.DREIER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && Analyse.Index.VIERER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && Analyse.Index.FUENFER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 && (Analyse.Index.EINSER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1 || Analyse.Index.SECHSER.vorkommen(Klassisch.this.augenhaeufigkeiten) == 1) ? 40 : 0;
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            if (Analyse.Index.EINSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 || Analyse.Index.SECHSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0) {
                return 40.0 * this.p(this.fehlend, spieler.rest());
            }
            return 40.0 * this.q(this.fehlend, spieler.rest());
        }

        @Override
        protected void waehle(Spieler spieler) {
            System.arraycopy(Klassisch.this.augenhaeufigkeiten, 0, this.kandidat, 0, 6);
            if (this.kandidat[Analyse.Index.EINSER.ordinal()] > 0 && this.kandidat[Analyse.Index.SECHSER.ordinal()] > 0) {
                if (ZUFALL.nextBoolean()) {
                    this.kandidat[Analyse.Index.EINSER.ordinal()] = 0;
                } else {
                    this.kandidat[Analyse.Index.SECHSER.ordinal()] = 0;
                }
            }
            this.fehlend = 0;
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
            int n = wuerfelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w;
                int i = (w = wuerfelArray[n2]).augen() - 1;
                this.neuwurfkarte.put(w, this.kandidat[i] == 0);
                if (((Boolean)this.neuwurfkarte.get(w)).booleanValue()) {
                    ++this.fehlend;
                } else {
                    this.kandidat[i] = 0;
                }
                ++n2;
            }
        }
    }

    class JaFuffy
    extends Analyse.Unten {
        private static final long serialVersionUID = -6921954073317063844L;
        static final int PUNKTE = 50;

        JaFuffy() {
            this.mittel = this.prognose(3, 0);
        }

        private double p(int r, int max) {
            if (r > 0) {
                double p = 0.0;
                if (max <= 1) {
                    int i = 1;
                    while (i <= 5) {
                        p += Kombinatorik.gleichenwahrscheinlichkeit(i) * this.p(r - 1, i);
                        ++i;
                    }
                } else {
                    p = max == 2 ? (80.0 * Kombinatorik.fixgleichenwahrscheinlichkeit(2, r - 1) + 15.0 * Kombinatorik.fixgleichenwahrscheinlichkeit(1, r - 1) + 1.0 + 120.0 * this.p(r - 1, 2)) / 216.0 : Kombinatorik.fixgleichenwahrscheinlichkeit(5 - max, r);
                }
                return p;
            }
            return max == 5 ? 1 : 0;
        }

        private double prognose(int r, int max) {
            return this.p(r, max) * 50.0;
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false ? 50 : 0;
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            return this.prognose(spieler.rest(), this.paschlaenge());
        }

        @Override
        protected void waehle(Spieler spieler) {
            int max = this.paschlaenge();
            ArrayList<Integer> augenauswahl = new ArrayList<Integer>();
            int ind = 0;
            while (ind < 6) {
                if (Klassisch.this.augenhaeufigkeiten[ind] == max) {
                    augenauswahl.add(new Integer(ind + 1));
                }
                ++ind;
            }
            int augen = (Integer)augenauswahl.get(ZUFALL.nextInt(augenauswahl.size()));
            Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
            int n = wuerfelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                this.neuwurfkarte.put(w, max == 1 || augen != w.augen());
                ++n2;
            }
        }
    }

    public class KleineStrasse
    extends Analyse.Unten {
        private static final long serialVersionUID = 3736058022544823661L;
        private static final double P_TOT = 0.6025279;
        public static final int PUNKTE = 30;
        private int aussen;
        private int innen;
        private int mitte;

        KleineStrasse() {
            this.mittel = 18.075837;
        }

        private void behalte(Strassenpaar paar) {
            Analyse.Index[] indexArray = paar.feld();
            int n = indexArray.length;
            int n2 = 0;
            while (n2 < n) {
                Analyse.Index element = indexArray[n2];
                if (element.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0) {
                    Wuerfel[] wuerfelArray = Klassisch.this.wuerfel;
                    int n3 = wuerfelArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Wuerfel w = wuerfelArray[n4];
                        if (w.augen() == element.augen()) {
                            this.neuwurfkarte.put(w, false);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }

        @Override
        protected void bewerte(Spieler spieler) {
            this.wert = this.liegtKleineStrasseVor() ? 30 : 0;
        }

        protected boolean liegtKleineStrasseVor() {
            return Analyse.Index.DREIER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.VIERER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && (Analyse.Index.EINSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.ZWEIER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 || Analyse.Index.ZWEIER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.FUENFER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 || Analyse.Index.FUENFER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0 && Analyse.Index.SECHSER.vorkommen(Klassisch.this.augenhaeufigkeiten) > 0);
        }

        @Override
        protected double prognose(Spieler spieler, Analyse.Zuwachs zuwachs) {
            if (this.liegtKleineStrasseVor()) {
                return 30.0;
            }
            return KleineStrasseIndex.TABELLE.get(new KleineStrasseIndex(this.aussen, this.innen, this.mitte, spieler.rest())) * 30.0;
        }

        @Override
        protected void waehle(Spieler spieler) {
            this.waehle(false);
        }

        protected void waehle(boolean fertig) {
            this.nominiereNeuwurf(!fertig);
            if (!fertig) {
                this.aussen = 0;
                this.innen = Strassenpaar.INNEN.vorkommen(Klassisch.this.augenhaeufigkeiten);
                this.mitte = Strassenpaar.MITTE.vorkommen(Klassisch.this.augenhaeufigkeiten);
                int links = Strassenpaar.LINKS.vorkommen(Klassisch.this.augenhaeufigkeiten);
                int rechts = Strassenpaar.RECHTS.vorkommen(Klassisch.this.augenhaeufigkeiten);
                if (this.innen == 2) {
                    this.behalte(Strassenpaar.INNEN);
                } else if (this.innen == 1 && links <= 1 && rechts <= 1) {
                    this.behalte(Strassenpaar.INNEN);
                } else if (links > rechts) {
                    this.aussen = links - this.innen;
                    this.behalte(Strassenpaar.LINKS);
                } else if (links < rechts) {
                    this.aussen = rechts - this.innen;
                    this.behalte(Strassenpaar.RECHTS);
                } else {
                    this.aussen = links - this.innen;
                    this.behalte(ZUFALL.nextBoolean() ? Strassenpaar.LINKS : Strassenpaar.RECHTS);
                }
                this.behalte(Strassenpaar.MITTE);
            }
        }
    }

    private static class KleineStrasseIndex
    implements Serializable {
        private static final long serialVersionUID = -6498075827504305923L;
        static final Map<KleineStrasseIndex, Double> TABELLE = new HashMap<KleineStrasseIndex, Double>();
        private final int aussen;
        private final int innen;
        private final int mitte;
        private final int rest;

        static {
            KleineStrasseIndex.tabelliere(0, 0, 1, 1, 0.212963);
            KleineStrasseIndex.tabelliere(0, 0, 1, 2, 0.489169);
            KleineStrasseIndex.tabelliere(0, 0, 2, 1, 0.3611111);
            KleineStrasseIndex.tabelliere(0, 0, 2, 2, 0.6584362);
            KleineStrasseIndex.tabelliere(0, 1, 0, 1, 0.1481481);
            KleineStrasseIndex.tabelliere(0, 1, 0, 2, 0.3912751);
            KleineStrasseIndex.tabelliere(0, 1, 1, 1, 0.25);
            KleineStrasseIndex.tabelliere(0, 1, 1, 2, 0.5150463);
            KleineStrasseIndex.tabelliere(0, 1, 2, 1, 0.5555556);
            KleineStrasseIndex.tabelliere(0, 1, 2, 2, 0.8024691);
            KleineStrasseIndex.tabelliere(0, 2, 0, 1, 0.1388889);
            KleineStrasseIndex.tabelliere(0, 2, 0, 2, 0.3526235);
            KleineStrasseIndex.tabelliere(0, 2, 1, 1, 0.3055556);
            KleineStrasseIndex.tabelliere(0, 2, 1, 2, 0.5177469);
            KleineStrasseIndex.tabelliere(1, 0, 0, 1, 0.1018519);
            KleineStrasseIndex.tabelliere(1, 0, 0, 2, 0.3410851);
            KleineStrasseIndex.tabelliere(1, 0, 1, 1, 0.1666667);
            KleineStrasseIndex.tabelliere(1, 0, 1, 2, 0.4293981);
            KleineStrasseIndex.tabelliere(1, 0, 2, 1, 0.3611111);
            KleineStrasseIndex.tabelliere(1, 0, 2, 2, 0.6296296);
            KleineStrasseIndex.tabelliere(1, 1, 0, 1, 0.1388889);
            KleineStrasseIndex.tabelliere(1, 1, 0, 2, 0.3526235);
            KleineStrasseIndex.tabelliere(1, 1, 1, 1, 0.3055556);
            KleineStrasseIndex.tabelliere(1, 1, 1, 2, 0.5177469);
        }

        private static void tabelliere(int aussen, int innen, int mitte, int rest, double p) {
            TABELLE.put(new KleineStrasseIndex(aussen, innen, mitte, rest), p);
        }

        KleineStrasseIndex(int aussen, int innen, int mitte, int rest) {
            this.aussen = aussen;
            this.innen = innen;
            this.mitte = mitte;
            this.rest = rest;
        }

        public boolean equals(Object obj) {
            KleineStrasseIndex index = (KleineStrasseIndex)obj;
            return this.aussen == index.aussen && this.innen == index.innen && this.mitte == index.mitte && this.rest == index.rest;
        }

        public int hashCode() {
            return 3 * (3 * (3 * this.aussen + this.innen) + this.mitte) + this.rest;
        }
    }

    private static enum Strassenpaar {
        LINKS(Analyse.Index.EINSER, Analyse.Index.ZWEIER),
        INNEN(Analyse.Index.ZWEIER, Analyse.Index.FUENFER),
        RECHTS(Analyse.Index.FUENFER, Analyse.Index.SECHSER),
        MITTE(Analyse.Index.DREIER, Analyse.Index.VIERER);

        private final Analyse.Index[] feld = new Analyse.Index[2];

        private Strassenpaar(Analyse.Index paar0, Analyse.Index paar1) {
            this.feld[0] = paar0;
            this.feld[1] = paar1;
        }

        final Analyse.Index[] feld() {
            return this.feld;
        }

        int vorkommen(int[] augenhaeufigkeiten) {
            int gefunden = 0;
            Analyse.Index[] indexArray = this.feld;
            int n = this.feld.length;
            int n2 = 0;
            while (n2 < n) {
                Analyse.Index element = indexArray[n2];
                if (element.vorkommen(augenhaeufigkeiten) > 0) {
                    ++gefunden;
                }
                ++n2;
            }
            return gefunden;
        }
    }

    class Viererpasch
    extends Analyse.Pasch {
        private static final long serialVersionUID = -3378721831288162486L;
        private static final int PASCHGROESSE = 4;

        Viererpasch() {
            super(4);
        }

        @Override
        protected double augensumme(int a, int r, int k) {
            switch (k) {
                case 2: {
                    return this.augensumme2(a, r);
                }
                case 3: {
                    return this.augensumme3(a, r);
                }
            }
            throw new IllegalArgumentException("Falsche Mehrlingsl\u00e4nge");
        }

        protected double augensumme2(int a, int r) {
            if (r > 0) {
                double augensumme = (double)(48 + 12 * a) * this.augensumme2(a, r - 1) + 75.0 * this.augensumme3(a, r - 1) + 18.0 * Kombinatorik.augenzahl(r) - 2.0 * Kombinatorik.augenzahl(a, r - 1) + (double)(64 * a);
                int alpha = 0;
                while (alpha < a) {
                    augensumme += this.augensumme3(alpha, r - 1);
                    ++alpha;
                }
                alpha = a + 1;
                while (alpha <= 6) {
                    augensumme += 12.0 * this.augensumme2(alpha, r - 1);
                    augensumme += this.augensumme3(alpha, r - 1);
                    ++alpha;
                }
                return augensumme /= 216.0;
            }
            return 0.0;
        }

        protected double augensumme3(int a, int r) {
            if (r > 0) {
                double augensumme = 25.0 * this.augensumme3(a, r - 1) + (double)(44 * a) + 12.0 * Kombinatorik.augenzahl(r) - Kombinatorik.augenzahl(a, r - 1);
                return augensumme /= 36.0;
            }
            return 0.0;
        }

        @Override
        protected boolean pasch() {
            return (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.VIERERPASCH) != false || (Boolean)Klassisch.this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false;
        }
    }
}

