/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.Ressource;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Pfad;
import jafuffy.bedienung.Signal;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class Willkommen
extends JDialog {
    private static final String ID1 = "1";
    private static final String ID2 = "2";
    private static final String INSTALLATION = "Installation.html";
    private static final URL HINWEISE = Ressource.LIESMICH.url("Installation.html");
    private static final Font TITELSCHRIFTART = new Font("Dialog", 1, 18);
    private static final int WECHSELPERIODE = 5000;
    private static final ImageIcon WILLKOMMEN1 = Grafik.icon("Willkommen1.gif");
    private static final ImageIcon WILLKOMMEN2 = Grafik.icon("Willkommen2.gif");
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BREITE = 600;
    private static final int HOEHE = 275;
    private static final int SPALTEN = 45;
    private static final int ZEILEN = 3;
    private boolean abgebrochen;

    private static JPanel aktualisierungspruefungsfrage(final Eigenschaften eigenschaften) {
        JCheckBox nachschauen = new JCheckBox();
        nachschauen.setSelected(eigenschaften.aktiv("Nachschauen"));
        nachschauen.setBorderPainted(true);
        nachschauen.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(0, 8, 0, 8)));
        nachschauen.setBackground(Color.ORANGE);
        nachschauen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                eigenschaften.wechsle("Nachschauen");
            }
        });
        JPanel nachschauenrahmen = new JPanel(new BorderLayout());
        nachschauenrahmen.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        nachschauenrahmen.add((Component)nachschauen, "Center");
        JTextArea suchverhalten = new JTextArea("Automatisch bei jedem Programmstart nach neuerer Version auf JaFuffys Homepage suchen. Das Verhalten kann nachtr\u00e4glich im Men\u00fcpunkt \"Einstellungen - Nachschauen\" festgelegt werden. Der Men\u00fcpunkt \"Hilfe - Aktualisieren...\" st\u00f6\u00dft die Suche explizit an.", 3, 45);
        suchverhalten.setLineWrap(true);
        suchverhalten.setWrapStyleWord(true);
        suchverhalten.setEditable(false);
        suchverhalten.setOpaque(false);
        JPanel aktualiserungsfeld = new JPanel(new BorderLayout(4, 0));
        aktualiserungsfeld.setBorder(BorderFactory.createTitledBorder(null, "Auf Homepage automatisch nach neuerer Version suchen?", 1, 1));
        aktualiserungsfeld.add((Component)nachschauenrahmen, "East");
        aktualiserungsfeld.add((Component)suchverhalten, "Center");
        return aktualiserungsfeld;
    }

    private static JPanel hinweise(JPanel wechselgrafik) {
        JEditorPane hilfe;
        try {
            hilfe = new JEditorPane(HINWEISE);
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.WARNUNG.play();
            JOptionPane.showMessageDialog(null, "(De)Installationshinweise \"Installation.html\" k\u00f6nnen nicht geladen werden!", "JaFuffy (Warnung)", 2);
            hilfe = new JEditorPane("text", "(De)Installationshinweise \"Installation.html\" k\u00f6nnen nicht geladen werden!");
        }
        hilfe.setEditable(false);
        hilfe.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(he.getURL().toURI());
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                    }
                }
            }
        });
        JScrollPane hilfescroll = new JScrollPane(hilfe);
        JPanel hilfefeld = new JPanel(new BorderLayout(4, 0));
        hilfefeld.setPreferredSize(new Dimension(600, 275));
        hilfefeld.setBorder(BorderFactory.createTitledBorder(null, "Hinweise zur (De)Installation", 1, 1));
        hilfefeld.add((Component)wechselgrafik, "West");
        hilfefeld.add((Component)hilfescroll, "Center");
        return hilfefeld;
    }

    private static JPanel inhalte(JLabel titel, JPanel textbereiche, JPanel aktionsleiste) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        titel.setAlignmentX(0.5f);
        panel.add(titel);
        panel.add(Box.createVerticalStrut(8));
        panel.add(textbereiche);
        panel.add(Box.createVerticalStrut(8));
        panel.add(aktionsleiste);
        return panel;
    }

    private static JTextArea kurzbeschreibung() {
        JTextArea beschreibung = new JTextArea("JaFuffy ist ein W\u00fcrfelspiel mit drei Spielregelvarianten, \u00e4hnlich zu Kniffel, Yahtzee oder Fuffy. Spiele k\u00f6nnen zu Turnieren zusammengefasst, gespeichert und geladen werden. Die besten Punktzahlen werden in Listen eingetragen. Bis zu vier Mitspieler sind m\u00f6glich, wobei JaFuffy deren Rollen \u00fcbernehmen kann.", 3, 45);
        beschreibung.setLineWrap(true);
        beschreibung.setWrapStyleWord(true);
        beschreibung.setEditable(false);
        beschreibung.setOpaque(false);
        beschreibung.setBorder(BorderFactory.createTitledBorder(null, "Kurzbeschreibung", 1, 1));
        return beschreibung;
    }

    private static JPanel textbereiche(Eigenschaften eigenschaften, JPanel wechselgrafik) {
        JPanel texte = new JPanel(new BorderLayout(0, 4));
        texte.add((Component)Willkommen.kurzbeschreibung(), "North");
        texte.add((Component)Willkommen.hinweise(wechselgrafik), "Center");
        texte.add((Component)Willkommen.aktualisierungspruefungsfrage(eigenschaften), "South");
        return texte;
    }

    private static JLabel titel() {
        JLabel titel = new JLabel("Willkommen zu JaFuffy!", 0);
        titel.setFont(TITELSCHRIFTART);
        return titel;
    }

    private static JPanel wechselgrafik() {
        JPanel grafik = new JPanel(new CardLayout());
        grafik.add((Component)new JLabel(WILLKOMMEN1), ID1);
        grafik.add((Component)new JLabel(WILLKOMMEN2), ID2);
        return grafik;
    }

    private static Timer wechsler(final JPanel wechselgrafik) {
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ((CardLayout)wechselgrafik.getLayout()).next(wechselgrafik);
            }
        });
        return timer;
    }

    public Willkommen(Eigenschaften eigenschaften) {
        JPanel wechselgrafik = Willkommen.wechselgrafik();
        final Timer wechsler = Willkommen.wechsler(wechselgrafik);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                if (event.getID() == 202) {
                    wechsler.stop();
                }
            }
        });
        wechsler.start();
        this.setDefaultCloseOperation(0);
        this.setTitle("JaFuffy (Er\u00f6ffnungsmeldung)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.setModal(true);
        this.setContentPane(Willkommen.inhalte(Willkommen.titel(), Willkommen.textbereiche(eigenschaften, wechselgrafik), this.aktionsleiste(eigenschaften)));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public boolean abgebrochen() {
        return this.abgebrochen;
    }

    private JPanel aktionsleiste(final Eigenschaften eigenschaften) {
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        JButton abbruch = new JButton("Abbruch");
        abbruch.setToolTipText("Programm beenden");
        abbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Willkommen.this.abgebrochen = true;
                Willkommen.this.setVisible(false);
            }
        });
        JButton weiter = new JButton("Weiter");
        weiter.setToolTipText("Einstellungspfad w\u00e4hlen und Programm beginnen");
        weiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Pfad(eigenschaften, Willkommen.this);
                Willkommen.this.setVisible(false);
            }
        });
        leiste.add(weiter);
        leiste.add(abbruch);
        this.getRootPane().setDefaultButton(weiter);
        return leiste;
    }
}

