/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Auswahl;
import jafuffy.logik.Analyse;
import jafuffy.logik.Auswertung;
import jafuffy.logik.Punkte;
import jafuffy.logik.Tabzeile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class Tabelle
extends JTable
implements ChangeListener {
    private static final int SPALTENBREITE_VORZUG = 80;
    private static final int SPALTENBREITE_MAX = Integer.MAX_VALUE;
    private static final int TABELLENKOPF_INSET = 5;
    private static final int ZELLENSEITENABSTAND = 10;
    private static final Color HELL = new Color(208, 224, 224);
    private static final Color MITTEL = new Color(176, 192, 192);
    private static final Color MARKE0 = new Color(252, 254, 254);
    private static final Color MARKE1 = new Color(232, 248, 240);
    private static final Color MARKE2 = new Color(192, 208, 208);
    private static final Color ZELLENFARBE = new Color(160, 176, 176);
    private static final Color ZELLENLINIENFARBE = ZELLENFARBE.darker();
    private static final Color TEXTFARBE = Color.PINK;
    private static final Color PUNKTFARBE = new Color(80, 96, 128);
    private static final NumberFormat NF = NumberFormat.getPercentInstance(Locale.GERMAN);
    private static final ToolTipManager TTM = ToolTipManager.sharedInstance();
    private static final int TTM_INIT_DELAY = TTM.getInitialDelay();
    private static final int INIT_DELAY = 250;
    private static final int TTM_DISMISS_DELAY = TTM.getDismissDelay();
    private static final int DISMISS_DELAY = 1500;
    private final PunktzahlRenderer punktzahlRenderer = new PunktzahlRenderer();
    private final ZwischensummeRenderer zwischensummeRenderer = new ZwischensummeRenderer();
    private final EndsummeRenderer endsummeRenderer = new EndsummeRenderer();
    private final JMenuItem popupUebernehmen;
    private final JMenuItem popupSetzen;
    private final JPopupMenu popupMenue;
    private final PopupListener popupListener;
    private int breite;

    Tabelle(Punkte punkte, Auswahl auswahl) {
        super(punkte);
        this.konfiguriereTabellenkopf();
        this.konfiguriereHinweiszeiten();
        this.popupUebernehmen = this.erzeugeUebernehmenMenueEintrag();
        this.popupSetzen = this.erzeugeSetzenMenueEintrag();
        this.popupMenue = this.erzeugeMenue();
        this.popupListener = new PopupListener(this.popupMenue);
        this.addMouseListener(this.popupListener);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setBorder(BorderFactory.createLineBorder(ZELLENLINIENFARBE));
        this.setFillsViewportHeight(false);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.setInputMap(1, null);
        this.setDefaultEditor(Object.class, auswahl);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        switch (Tabzeile.eintrag(row)) {
            case GESAMT: 
            case OSUMME: 
            case USUMME: {
                return this.zwischensummeRenderer;
            }
            case ESUMME: {
                return this.endsummeRenderer;
            }
        }
        return this.punktzahlRenderer;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        Punkte punkte = (Punkte)this.getModel();
        if (punkte.auswertung().sindTippsAngefordert()) {
            punkte.aktiv();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setGridColor(ZELLENLINIENFARBE);
        this.setShowGrid(true);
        if (this.popupMenue != null) {
            SwingUtilities.updateComponentTreeUI(this.popupMenue);
        }
        this.ermittleBreite(this.minSpaltenBreite());
    }

    private int basisbreite(String text, Container zeichner) {
        Insets insets = zeichner.getInsets();
        return zeichner.getFontMetrics(zeichner.getFont()).stringWidth(text) + insets.left + insets.right + 2 * this.getIntercellSpacing().width + 5;
    }

    private Font basisfont(DefaultTableCellRenderer zeichner) {
        zeichner.setOpaque(true);
        zeichner.setHorizontalAlignment(4);
        zeichner.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        zeichner.setToolTipText(null);
        zeichner.setForeground(PUNKTFARBE);
        Font font = zeichner.getFont().deriveFont(1);
        zeichner.setFont(font);
        return font;
    }

    private JPopupMenu erzeugeMenue() {
        JPopupMenu menue = new JPopupMenu();
        menue.add(this.popupUebernehmen);
        menue.addSeparator();
        menue.add(this.popupSetzen);
        return menue;
    }

    private JMenuItem erzeugeSetzenMenueEintrag() {
        JMenuItem menueeintrag = new JMenuItem();
        menueeintrag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Tabelle.this.popupListener.getRow();
                Tabelle tabelle = Tabelle.this;
                Auswahl auswahl = (Auswahl)tabelle.getDefaultEditor(Auswahl.class);
                auswahl.aktiviere(Tabzeile.eintrag(row));
                auswahl.doClick();
            }
        });
        return menueeintrag;
    }

    private JMenuItem erzeugeUebernehmenMenueEintrag() {
        JMenuItem menueeintrag = new JMenuItem("Vorschlag \u00fcbernehmen");
        menueeintrag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Punkte)Tabelle.this.getModel()).auswertung().erstelleVorschlag(Tabzeile.eintrag(Tabelle.this.popupListener.getRow()));
            }
        });
        menueeintrag.setToolTipText("<html><p>W\u00fcrfelauswahl dem Vorschlag entsprechend vornehmen.</p><p>Umrahmte Eintr\u00e4ge haben gleichen Auswahlvorschlag.</p></html>");
        return menueeintrag;
    }

    private void konfiguriereHinweiszeiten() {
        this.addMouseListener(new MouseAdapter(){
            private boolean enabled;

            @Override
            public void mouseEntered(MouseEvent event) {
                this.enabled = ToolTipManager.sharedInstance().isEnabled();
                TTM.setInitialDelay(250);
                TTM.setDismissDelay(1500);
                ToolTipManager.sharedInstance().setEnabled(true);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                TTM.setInitialDelay(TTM_INIT_DELAY);
                TTM.setDismissDelay(TTM_DISMISS_DELAY);
                ToolTipManager.sharedInstance().setEnabled(this.enabled);
            }
        });
    }

    private void konfiguriereTabellenkopf() {
        JTableHeader tabellenkopf = this.getTableHeader();
        tabellenkopf.setDefaultRenderer(new SpaltenkopfRenderer());
        tabellenkopf.setReorderingAllowed(false);
        tabellenkopf.setResizingAllowed(false);
    }

    private int minSpaltenBreite() {
        DefaultTableCellRenderer zeichner = new DefaultTableCellRenderer();
        this.basisfont(zeichner);
        return this.basisbreite("100%", zeichner);
    }

    int breite() {
        return this.breite;
    }

    void ermittleBreite(int min) {
        int vorzugsbreite = 0;
        Enumeration<TableColumn> spalten = this.getColumnModel().getColumns();
        while (spalten.hasMoreElements()) {
            TableColumn spalte = spalten.nextElement();
            spalte.setMinWidth(min);
            spalte.setMaxWidth(Integer.MAX_VALUE);
            String spaltentitel = spalte.getHeaderValue().toString();
            int ind = spalte.getModelIndex();
            Container zeichner = (Container)this.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this, spaltentitel, false, false, 0, ind);
            int basisbreite = this.basisbreite(spaltentitel, zeichner);
            if (basisbreite <= vorzugsbreite) continue;
            vorzugsbreite = basisbreite;
        }
        if (vorzugsbreite < min) {
            vorzugsbreite = min;
        }
        if (vorzugsbreite > 80) {
            vorzugsbreite = 80;
        }
        this.breite = this.getModel().getColumnCount() * vorzugsbreite;
    }

    static /* synthetic */ Color access$4() {
        return MARKE0;
    }

    static /* synthetic */ Color access$5() {
        return MARKE1;
    }

    private class EndsummeRenderer
    extends ZwischensummeRenderer {
        EndsummeRenderer() {
            this.farbe = MITTEL;
            this.markiert = ZELLENFARBE;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setForeground(this.getForeground().darker());
            return this;
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private final JPopupMenu popup;
        private int row;
        private int col;

        PopupListener(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Point point = new Point(x, y);
            Punkte punkte = (Punkte)((Tabelle)e.getComponent()).getModel();
            Auswertung auswertung = punkte.auswertung();
            Analyse analyse = auswertung.analyse();
            boolean tipps = auswertung.sindTippsAngefordert();
            this.row = Tabelle.this.rowAtPoint(point);
            this.col = Tabelle.this.columnAtPoint(point);
            if (e.isPopupTrigger() && punkte.aktiv(this.col) && punkte.isCellEditable(this.row, this.col)) {
                Tabelle.this.popupUebernehmen.setEnabled(tipps && punkte.offen(this.col));
                int wert = analyse.wert(Tabzeile.eintrag(this.row));
                Tabelle.this.popupSetzen.setText(String.valueOf(wert) + (wert != 1 ? " Punkte setzen" : " Punkt setzen"));
                this.popup.show(e.getComponent(), x, y);
            }
        }

        int getRow() {
            return this.row;
        }
    }

    private class PunktzahlRenderer
    extends DefaultTableCellRenderer {
        protected Color farbe = Tabelle.access$4();
        protected Color markiert = Tabelle.access$5();
        private static final float HUE = 0.125f;
        private static final float SAT = 1.0f;
        private static final float BRIGHT = 0.95f;
        private static final int PUNKTEZELLENSEITENABSTAND = 8;

        private PunktzahlRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Font font = Tabelle.this.basisfont(this);
            Punkte punkte = (Punkte)Tabelle.this.getModel();
            Auswertung auswertung = punkte.auswertung();
            Analyse analyse = auswertung.analyse();
            Tabzeile zeile = Tabzeile.eintrag(row);
            String text = null;
            if (punkte.aktiv(col)) {
                this.setBackground(this.markiert);
                if (punkte.angefangen(col)) {
                    this.setToolTipText(auswertung.spicker(zeile));
                }
                text = auswertung.text(zeile);
            } else {
                this.setBackground(this.farbe);
            }
            boolean tipps = auswertung.sindTippsAngefordert();
            if (text != null) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.setHorizontalAlignment(0);
                this.setForeground(TEXTFARBE);
            } else if (!punkte.setzbar(row, col)) {
                if ((Integer)value != 0 || zeile.alle()) {
                    text = value.toString();
                }
            } else if (punkte.aktiv(col) && table.isCellEditable(row, col)) {
                if (tipps) {
                    if (analyse.istVorschlagEntsprechendWuerfelauswahl(zeile)) {
                        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(analyse.bester() == zeile ? ZELLENLINIENFARBE.darker() : ZELLENLINIENFARBE.brighter(), 2), BorderFactory.createEmptyBorder(0, 8, 0, 8)));
                    }
                    float wichtung = (float)analyse.wichtung(zeile);
                    text = NF.format(wichtung);
                    this.setForeground(Color.getHSBColor(analyse.bester() == zeile ? 0.075f : 0.125f, (0.2f + wichtung * 0.8f) * 1.0f, 0.95f));
                } else if (Eigenschaften.GLOBAL.aktiv("Zwischenstand")) {
                    this.setFont(font.deriveFont(0));
                    this.setForeground(Color.YELLOW.darker());
                    text = Integer.toString(analyse.wert(zeile));
                }
            }
            this.setText(text);
            return this;
        }

        /* synthetic */ PunktzahlRenderer(PunktzahlRenderer punktzahlRenderer, PunktzahlRenderer punktzahlRenderer2) {
            this();
        }
    }

    private class SpaltenkopfRenderer
    extends DefaultTableCellRenderer {
        private static final int SPALTENDECKELABSTAND = 1;

        SpaltenkopfRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setText(value.toString());
            return this;
        }
    }

    private class ZwischensummeRenderer
    extends PunktzahlRenderer {
        ZwischensummeRenderer() {
            super(null, null);
            this.farbe = HELL;
            this.markiert = MARKE2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            this.setForeground(this.getForeground().darker());
            return this;
        }
    }
}

