/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import jafuffy.logik.Analyse;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Klassisch;

public class Erweitert
extends Klassisch {
    private static final int JOKER = 100;
    private static final long serialVersionUID = -3064026868041038008L;

    public Erweitert(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    public boolean istJokerVorliegend(Spieler spieler) {
        return (Boolean)this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false && spieler.punkte(Tabzeile.JAFUFFY) > 0 && !spieler.setzbar(Tabzeile.oben(this.wuerfel[0].augen()));
    }

    public boolean istSetzzwangGegeben(Spieler spieler) {
        return (Boolean)this.paschkarte.get((Object)Analyse.Paschaufzaehlung.FUENFERPASCH) != false && spieler.punkte(Tabzeile.JAFUFFY) > 0 && spieler.setzbar(Tabzeile.oben(this.wuerfel[0].augen()));
    }

    @Override
    protected Analyse.Eintragungen eintragungen() {
        return new Eintragungen();
    }

    class Eintragungen
    extends Analyse.Eintragungen {
        private static final long serialVersionUID = -3746750646308026451L;

        Eintragungen() {
            this.put(Tabzeile.DREIERPASCH, new Klassisch.Dreierpasch(Erweitert.this));
            this.put(Tabzeile.VIERERPASCH, new Klassisch.Viererpasch(Erweitert.this));
            this.put(Tabzeile.FULLHOUSE, new Klassisch.FullHouse(Erweitert.this));
            this.put(Tabzeile.KLEINESTRASSE, new KleineStrasse());
            this.put(Tabzeile.GROSSESTRASSE, new GrosseStrasse());
            this.put(Tabzeile.JAFUFFY, new JaFuffy());
        }
    }

    class GrosseStrasse
    extends Klassisch.GrosseStrasse {
        private static final long serialVersionUID = -4794832240142053236L;

        GrosseStrasse() {
            super(Erweitert.this);
        }

        @Override
        protected void bewerte(Spieler spieler) {
            if (Erweitert.this.istJokerVorliegend(spieler)) {
                this.wert = 40;
            } else {
                super.bewerte(spieler);
            }
        }
    }

    class JaFuffy
    extends Klassisch.JaFuffy {
        private static final long serialVersionUID = -1936696859004502372L;

        JaFuffy() {
            super(Erweitert.this);
        }

        @Override
        protected void bewerte(Spieler spieler) {
            super.bewerte(spieler);
            if (this.wert > 0 && spieler.punkte(Tabzeile.JAFUFFY) > 0) {
                this.wert = spieler.punkte(Tabzeile.JAFUFFY) + 100;
            }
        }
    }

    class KleineStrasse
    extends Klassisch.KleineStrasse {
        private static final long serialVersionUID = -244259498879083805L;

        KleineStrasse() {
            super(Erweitert.this);
        }

        @Override
        protected void bewerte(Spieler spieler) {
            if (Erweitert.this.istJokerVorliegend(spieler)) {
                this.wert = 30;
            } else {
                super.bewerte(spieler);
            }
        }
    }
}

