/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.logik.Aenderungen;
import jafuffy.logik.Analyse;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;

public abstract class Auswertung
extends Aenderungen<CEAblauf> {
    private static final long serialVersionUID = -7315969783651586016L;
    protected final Analyse analyse;
    protected final Wuerfel[] wuerfel;
    protected boolean sindTippsAngefordert;
    protected Spieler aktiver;

    protected Auswertung(Wuerfel[] wuerfel, Analyse analyse) {
        this.wuerfel = wuerfel;
        this.analyse = analyse;
    }

    public abstract int abweichung();

    public Spieler aktiver() {
        return this.aktiver;
    }

    public Analyse analyse() {
        return this.analyse;
    }

    public void erstelleVorschlag(Tabzeile eintrag) {
        Wuerfel[] wuerfelArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = wuerfelArray[n2];
            w.setzeVorschlag(this.analyse.erneut(eintrag, w));
            ++n2;
        }
        this.fireStateChanged(CEAblauf.VORGESCHLAGEN);
    }

    public abstract int mittelwert();

    public boolean sindTippsAngefordert() {
        return this.sindTippsAngefordert;
    }

    public String spicker(Tabzeile eintrag) {
        String text;
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.aktiver.gewuerfelt() && this.aktiver.setzbar(eintrag) && eintrag.alle()) {
            int punkte = this.analyse.wert(eintrag);
            text = String.valueOf(new Integer(punkte).toString()) + (punkte != 1 ? " Punkte" : " Punkt");
            if (this.sindTippsAngefordert()) {
                text = "<html><p>" + text + "</p>" + "<p><small><i>Siehe auch Kontextmen\u00fc!</i></small></p>" + "<p><small><i>Beachte Men\u00fc \"Extras\".</i></small></p>" + "</html>";
            }
        } else {
            text = null;
        }
        return text;
    }

    public abstract String text(Tabzeile var1);

    public abstract String toString();

    void aktiviereTipps(boolean tipps) {
        if (tipps && !this.sindTippsAngefordert) {
            this.analyse.prognostiziere(this.aktiver);
            this.sindTippsAngefordert = true;
        }
        this.sindTippsAngefordert = tipps;
    }

    void erstelleVorschlag() {
        this.aktiviereTipps(true);
        this.erstelleVorschlag(this.analyse.bester());
    }

    void reagiereAufWurf(Spieler spieler) {
        this.aktiver = spieler;
        this.sindTippsAngefordert = false;
        this.analyse.errechne(spieler);
    }
}

