/******************************************************************************
 ** $Id: BestenlisteModell.java 1017 2016-05-28 20:35:09Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

import java.util.ArrayList;

import javax.swing.table.AbstractTableModel;

/**
 * Modell fr Tabelle in der Bestenliste.
 */
@SuppressWarnings("serial")
public class BestenlisteModell extends AbstractTableModel {

    private static final int RANG = 0, NAME = 1, PUNKTE = 2, DATUM = 3, KOMMENTAR = 4;
    private static final String[] SPALTENTITEL = { "Rang", "Name", "Punkte", "Datum", "Kommentar" };
    private static final Class<?>[] SPALTENTYP =
            { Integer.class, String.class, Integer.class, String.class, String.class };
    private final ArrayList<Statistik.Rang> rangliste;

    private ArrayList<Zeile> zeilen;

    /** Daten fr die Eintragung in eine Zeile der Bestenliste. */
    private class Zeile {
        private final int rang;
        private final String name;
        private final int punkte;
        private final String datum;
        private final String kommentar;

        Zeile(int rang, String name, int punkte, String datum, String kommentar) {
            this.rang = rang;
            this.name = name;
            this.punkte = punkte;
            this.datum = datum;
            this.kommentar = kommentar;
        }
    }

    /**
     * Konstruktor.
     *
     * @param rangliste
     *            Rangliste
     */
    BestenlisteModell(ArrayList<Statistik.Rang> rangliste) {
        this.rangliste = rangliste;
        aktualisieren();
    }

    /**
     * Neuer Eintrag in Rangliste.
     */
    public void aktualisieren() {
        zeilen = new ArrayList<Zeile>();
        for (Statistik.Rang rang : rangliste) {
            for (Statistik.Rang.Eintrag eintrag : rang.eintraege()) {
                zeilen.add(new Zeile(rang.rangnummer(), eintrag.name(), rang.punkte(), eintrag.datum(),
                        eintrag.kommentar()));
            }
        }
        fireTableDataChanged();
    }

    /**
     * Spaltenberschriften.
     *
     * @param col
     */
    @Override
    public String getColumnName(int col) {
        return SPALTENTITEL[col];
    }

    /**
     * Wieviele Spalten?
     */
    @Override
    public int getColumnCount() {
        return SPALTENTITEL.length;
    }

    /**
     * Wieviele Eintrge (Zeilen)?
     */
    @Override
    public int getRowCount() {
        return zeilen == null ? 0 : zeilen.size();
    }

    /**
     * @param row
     * @param col
     * @return Zellen vernderbar?
     */
    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    /**
     * @param row
     * @param col
     * @return Tabelleneintrag
     */
    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
        case RANG:
            return new Integer(zeilen.get(row).rang);
        case NAME:
            return zeilen.get(row).name;
        case PUNKTE:
            return new Integer(zeilen.get(row).punkte);
        case DATUM:
            return zeilen.get(row).datum;
        case KOMMENTAR:
            return zeilen.get(row).kommentar;
        default:
            return null;
        }
    }

    /**
     * @param col
     * @return Art der Eintrge
     */
    @Override
    public Class<?> getColumnClass(int col) {
        return SPALTENTYP[col];
    }

}
