/******************************************************************************
 ** $Id: Wuerfelbild.java 1017 2016-05-28 20:35:09Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.logik.Wuerfel;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/** Wrfel (Darstellung). */
@SuppressWarnings("serial")
class Wuerfelbild extends JToggleButton {

    /** Randabstand Wrfel-Icon zu Button-Rand. */
    private static final int RAND = 4;
    /** Verzgerung fr Wrfelgerusche. */
    private static final int DELAY = 80;
    /** Wrfel-Icons. */
    private static final String WUERFEL = "Wuerfel";
    /** Wrfel wird zur Zhlung genommen. */
    private static final ImageIcon[] BILDER = new ImageIcon[Wuerfel.MAXIMALAUGENAUGENZAHL];
    /** Wrfel wird in den Becher gelegt (selektiert). */
    private static final ImageIcon[] BILDER_S = new ImageIcon[Wuerfel.MAXIMALAUGENAUGENZAHL];

    static {
        for (int i = 0; i < Wuerfel.MAXIMALAUGENAUGENZAHL; i++) {
            BILDER[i] = Grafik.icon(WUERFEL + (i + 1) + ".gif");
            BILDER_S[i] = Grafik.icon(WUERFEL + (i + 1) + "s.gif");
        }
    }

    /** Gerusche beim Herausnehmen. */
    private static final Geraeusch LEERUNG = new Geraeusch("Leerung.wav");
    /** Gerusche beim Hineinlegen. */
    private static final Geraeusch FUELLUNG = new Geraeusch("Fuellung.wav");

    /** Kurzwahltaste: die Ziffer aus 1 bis 5, welche der Wrfelposition entspricht. */
    private final int taste;

    /**
     * Konstruktor.
     *
     * @param position
     *            Position in der Darstellung
     */
    Wuerfelbild(int position) {
        taste = position + 1;

        setFocusable(false);
        setMargin(new Insets(RAND, RAND, RAND, RAND));
        setHorizontalAlignment(CENTER);
        setEnabled(false);
        setIcon(BILDER[0]);

        getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_1 + position, 0), this);
        getActionMap().put(this, new AbstractAction() {
            // Verzgerung bei Klick durch Tastatur
            private static final int KLICKZEIT = 100;

            // Mausklick wird simuliert
            @Override
            public void actionPerformed(ActionEvent ev) {
                JToggleButton button = (JToggleButton) ev.getSource();
                button.doClick(KLICKZEIT);
            }
        });

        addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent ce) {
                aktualisiere();
                Wuerfel wuerfel = modell();
                if (wuerfel.isPressed()) {
                    if (wuerfel.isSelected()) {
                        FUELLUNG.play(DELAY);
                    } else {
                        LEERUNG.play(DELAY);
                    }
                }
            }
        });
    }

    /**
     * Aktivieren.
     *
     * @param enabled
     */
    @Override
    public void setEnabled(boolean enabled) {
        setToolTipText(enabled ? "<html>" + "Angewhlte Wrfel liegen im Becher" + "<br>"
                + "<small>Mausklick oder Taste \"" + taste + "\"" + "<html>" : "Bitte in der Tabelle setzen!");
        setBorderPainted(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setModel(ButtonModel modell) {
        super.setModel(modell);
        if (modell instanceof Wuerfel) {
            aktualisiere();
        }
    }

    /** Darstellung anpassen etwa bei Wurf oder Modellwechsel. */
    private void aktualisiere() {
        setIcon(BILDER[augen() - 1]);
        setSelectedIcon(BILDER_S[augen() - 1]);
        setDisabledIcon(BILDER[augen() - 1]);
    }

    /** @return Augenzahl */
    private int augen() {
        return modell().augen();
    }

    /** @return Wrfelmodell der Darstellung */
    Wuerfel modell() {
        return (Wuerfel) getModel();
    }

}
