/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Aenderungen;
import jafuffy.logik.CEWuerfel;
import java.util.Random;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;

public class Wuerfel
extends JToggleButton.ToggleButtonModel
implements Comparable<Wuerfel> {
    private static final long serialVersionUID = 6889772262239748227L;
    private static final Random ZUFALL = new Random();
    public static final int MAXIMALAUGENAUGENZAHL = 6;
    private final Aenderungen<CEWuerfel> aenderungen;
    private int augen;
    private boolean vorgeschlagen;

    Wuerfel(int augen) {
        this.augen = augen;
        this.aenderungen = new Aenderungen();
    }

    public int augen() {
        return this.augen;
    }

    @Override
    public int compareTo(Wuerfel wuerfel) {
        return Integer.compare(this.augen(), wuerfel.augen());
    }

    public void entferneChangeListener(ChangeListener changeListener) {
        this.aenderungen.removeChangeListener(changeListener);
    }

    public int vorkommen(int[] haeufigkeiten) {
        return haeufigkeiten[this.augen - 1];
    }

    public void installiereChangeListener(ChangeListener changeListener) {
        this.aenderungen.addChangeListener(changeListener);
    }

    @Override
    public void setSelected(boolean selektiert) {
        boolean feuern = this.isSelected() ^ selektiert;
        super.setSelected(selektiert);
        if (feuern) {
            this.aenderungen.fireStateChanged(selektiert ? CEWuerfel.ANWAHL : CEWuerfel.ABWAHL);
        }
    }

    public boolean vorgeschlagen() {
        return this.vorgeschlagen;
    }

    void setzeVorschlag(boolean vorschlagen) {
        this.vorgeschlagen = vorschlagen;
    }

    void wirf() {
        this.vorgeschlagen = false;
        this.augen = ZUFALL.nextInt(6) + 1;
        this.aenderungen.fireStateChanged(CEWuerfel.WURF);
        this.setSelected(false);
    }
}

