/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Report;
import jafuffy.logik.Statistik;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

class Verlaufsgrafik
extends JPanel {
    private static final int RAND = 20;
    private static final int FAKTORBASIS = 10;
    private static final int BESCHRIFTUNG = 20;
    private static final double LUECKE_HOR = 50.0;
    private static final double LUECKE_VERT = 15.0;
    private static final double BALKENBREITE = 75.0;
    private static final double BALKENTIEFE = 15.0;
    private static final double STEIGUNG = 0.5;
    private static final float[] DASH = new float[]{16.0f};
    private static final Color WAND_RECHTS = new Color(240, 240, 240);
    private static final Color WAND_UNTEN = new Color(235, 235, 235);
    private static final Color WAND_HINTEN = new Color(245, 245, 245);
    private static final Color[] BALKEN_UNTEN = new Color[4];
    private static final Color[] BALKEN_OBEN = new Color[4];
    private final JPopupMenu popup = new JPopupMenu();
    private final JMenuItem kleiner = new JMenuItem("Verkleinern");
    private final JMenuItem groesser = new JMenuItem("Vergr\u00f6\u00dfern");
    private final JMenuItem normal = new JMenuItem("Standard");
    private final JMenuItem aktuell = new JMenuItem("Aktuell");
    private final Statistik statistik;
    private ArrayList<Integer>[] verlauf;
    private int anzahl;
    private double maximalhoehe;
    private double wandhoehe;
    private AffineTransform trafo;
    private int faktor = 1;

    static {
        int i = 0;
        while (i < 4) {
            Verlaufsgrafik.BALKEN_UNTEN[i] = Report.FARBEN[i].darker();
            Verlaufsgrafik.BALKEN_OBEN[i] = Report.FARBEN[i].brighter();
            ++i;
        }
    }

    Verlaufsgrafik(Statistik statistik) {
        this.setBackground(Color.white);
        this.statistik = statistik;
        this.setToolTipText("<html><p>Aufschl\u00fcsselung nach den einzelnen Spielen.</p><p>Zoomfunktionen auf rechter Maustaste.</p><p>Ziehen (\"Dragging\") verf\u00fcgbar.</p></html>");
        ActionListener zoom = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Verlaufsgrafik.this.zoome(event);
            }
        };
        this.kleiner.setEnabled(false);
        this.kleiner.addActionListener(zoom);
        this.groesser.addActionListener(zoom);
        this.normal.setEnabled(false);
        this.normal.addActionListener(zoom);
        this.aktuell.addActionListener(zoom);
        this.aktuell.setToolTipText("Letzten Stand anzeigen");
        this.popup.add(this.kleiner);
        this.popup.add(this.groesser);
        this.popup.addSeparator();
        this.popup.add(this.normal);
        this.popup.addSeparator();
        this.popup.add(this.aktuell);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Verlaufsgrafik.this.kleiner.setEnabled(Verlaufsgrafik.this.faktor > 1);
                    Verlaufsgrafik.this.normal.setEnabled(Verlaufsgrafik.this.faktor > 1);
                    Verlaufsgrafik.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void setVisible(boolean sichtbar) {
        this.aktualisiere();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    private void bestimmeFaktor() {
        this.faktor = (int)Math.round(Math.pow(2.0, Math.floor(Math.log(Math.ceil((double)this.anzahl / 10.0)) / Math.log(2.0))));
    }

    private Color deckelfarbe(int s, int punkte) {
        int r1 = BALKEN_UNTEN[s].getRed();
        int g1 = BALKEN_UNTEN[s].getGreen();
        int b1 = BALKEN_UNTEN[s].getBlue();
        int r2 = BALKEN_OBEN[s].getRed();
        int g2 = BALKEN_OBEN[s].getGreen();
        int b2 = BALKEN_OBEN[s].getBlue();
        if ((double)punkte < this.wandhoehe) {
            return new Color(r1 + (r2 - r1) * punkte / (int)this.wandhoehe, g1 + (g2 - g1) * punkte / (int)this.wandhoehe, b1 + (b2 - b1) * punkte / (int)this.wandhoehe);
        }
        return BALKEN_OBEN[s];
    }

    private void erstelleKoordinaten(Graphics2D g2, boolean zeichnen) {
        double skalierung;
        super.paintComponent(g2);
        g2.setFont(new Font("Dialog", 0, 20));
        FontMetrics fm = g2.getFontMetrics();
        double beschriftungslaenge = 10 + fm.stringWidth(String.valueOf(this.statistik.mittelwert()));
        double nutzbreite = (double)this.getWidth() - beschriftungslaenge - 40.0;
        double nutzhoehe = this.getHeight() - 40;
        double grundbreite = (double)this.statistik.spieler().size() * 125.0 - 50.0;
        double grundhoehe = -this.y(this.anzahl);
        double breite = grundbreite + grundhoehe / 0.5;
        double hoehe = grundhoehe + this.maximalhoehe;
        this.trafo = g2.getTransform();
        if (hoehe / breite <= nutzhoehe / nutzbreite) {
            skalierung = nutzbreite / breite;
            g2.translate(grundbreite * skalierung + 20.0, (nutzhoehe - hoehe * skalierung) / 2.0 + this.maximalhoehe * skalierung + 20.0);
        } else {
            skalierung = nutzhoehe / hoehe;
            g2.translate((nutzbreite - breite * skalierung) / 2.0 + grundbreite * skalierung + 20.0, this.maximalhoehe * skalierung + 20.0);
        }
        g2.scale(skalierung, skalierung);
        if (zeichnen) {
            int punkte = 0;
            while ((double)punkte <= this.wandhoehe) {
                g2.drawString(String.valueOf(punkte), (float)(10.0 + grundhoehe / 0.5), (float)(grundhoehe - (double)punkte - 5.0));
                punkte += 100;
            }
        }
        g2.scale(-1.0, -1.0);
        this.trafo = g2.getTransform();
        if (!zeichnen) {
            return;
        }
        BasicStroke dick = new BasicStroke((float)(2.0 / skalierung));
        BasicStroke normal = new BasicStroke((float)(1.0 / skalierung));
        BasicStroke gestrichelt = new BasicStroke((float)(1.0 / skalierung), 0, 2, 1.0f, DASH, 0.0f);
        Rectangle2D.Double rechteck = new Rectangle2D.Double(0.0, 0.0, grundbreite, this.wandhoehe);
        g2.setTransform(this.trafo);
        g2.setPaint(WAND_HINTEN);
        g2.fill(rechteck);
        g2.setPaint(Color.black);
        g2.setStroke(dick);
        g2.draw(rechteck);
        g2.setStroke(normal);
        double y = 100.0;
        while (y < this.wandhoehe) {
            g2.draw(new Line2D.Double(0.0, y, grundbreite, y));
            y += 100.0;
        }
        g2.setStroke(gestrichelt);
        y = 50.0;
        while (y < this.wandhoehe) {
            g2.draw(new Line2D.Double(0.0, y, grundbreite, y));
            y += 100.0;
        }
        rechteck = new Rectangle2D.Double(-grundhoehe / 0.5, 0.0, grundhoehe / 0.5, this.wandhoehe);
        g2.setTransform(this.trafo);
        g2.shear(0.0, 0.5);
        g2.setPaint(WAND_RECHTS);
        g2.fill(rechteck);
        g2.setPaint(Color.black);
        g2.setStroke(dick);
        g2.draw(rechteck);
        g2.setStroke(normal);
        y = 100.0;
        while (y < this.wandhoehe) {
            g2.draw(new Line2D.Double(-grundhoehe / 0.5, y, 0.0, y));
            y += 100.0;
        }
        g2.setStroke(gestrichelt);
        y = 50.0;
        while (y < this.wandhoehe) {
            g2.draw(new Line2D.Double(-grundhoehe / 0.5, y, 0.0, y));
            y += 100.0;
        }
        rechteck = new Rectangle2D.Double(0.0, -grundhoehe, grundbreite, grundhoehe);
        g2.setTransform(this.trafo);
        g2.shear(2.0, 0.0);
        g2.setPaint(WAND_UNTEN);
        g2.fill(rechteck);
        g2.setPaint(Color.black);
        g2.setStroke(dick);
        g2.draw(rechteck);
        g2.setStroke(new BasicStroke((float)(1.5 / skalierung)));
    }

    private double x(int s, int i) {
        return 125.0 * (double)(this.statistik.spieler().size() - s - 1) + this.y(i) / 0.5;
    }

    private double y(int i) {
        return -30.0 * (double)i;
    }

    private void zeichneBalkengrafik(Graphics2D g2) {
        int s = this.verlauf.length - 1;
        while (s >= 0) {
            int i = 0;
            while (i < this.verlauf[s].size()) {
                int punkte = this.verlauf[s].get(i);
                double x = this.x(s, i) - 30.0;
                double y = this.y(i) - 15.0;
                if (punkte > 0) {
                    if (this.y(i) + (double)punkte > this.maximalhoehe) {
                        this.maximalhoehe = this.y(i) + (double)punkte;
                    }
                    Rectangle2D.Double rechteck = new Rectangle2D.Double(x, y, 75.0, punkte);
                    GradientPaint farbverlauf = new GradientPaint(0.0f, (float)y, BALKEN_UNTEN[s], 0.0f, (float)(y + this.wandhoehe), BALKEN_OBEN[s]);
                    g2.setPaint(farbverlauf);
                    g2.setTransform(this.trafo);
                    g2.fill(rechteck);
                    g2.setPaint(Color.black);
                    g2.draw(rechteck);
                    rechteck = new Rectangle2D.Double(0.0, 0.0, 30.0, punkte);
                    farbverlauf = new GradientPaint(0.0f, 0.0f, BALKEN_UNTEN[s], 0.0f, (float)this.wandhoehe, BALKEN_OBEN[s]);
                    g2.setTransform(this.trafo);
                    g2.translate(x + 75.0, y);
                    g2.shear(0.0, 0.5);
                    g2.setPaint(farbverlauf);
                    g2.fill(rechteck);
                    g2.setPaint(Color.black);
                    g2.draw(rechteck);
                    rechteck = new Rectangle2D.Double(0.0, 0.0, 75.0, 15.0);
                    g2.setPaint(this.deckelfarbe(s, punkte));
                    g2.setTransform(this.trafo);
                    g2.translate(x, y + (double)punkte);
                    g2.shear(2.0, 0.0);
                    g2.fill(rechteck);
                    g2.setPaint(Color.black);
                    g2.draw(rechteck);
                }
                ++i;
            }
            --s;
        }
    }

    private void zoome() {
        this.setPreferredSize(new Dimension(this.faktor * this.getVisibleRect().width, this.faktor * this.getVisibleRect().height));
        this.revalidate();
    }

    private void zoome(ActionEvent event) {
        String ac = event.getActionCommand();
        Rectangle r = ((JViewport)this.getParent()).getViewRect();
        int u = r.x + r.width / 2;
        int v = r.y + r.height / 2;
        if (ac.equals("Vergr\u00f6\u00dfern")) {
            this.faktor *= 2;
            this.zoome();
            this.scrollRectToVisible(new Rectangle((u *= 2) - r.width / 2, (v *= 2) - r.height / 2, r.width, r.height));
        } else if (ac.equals("Verkleinern") && this.faktor > 1) {
            this.faktor /= 2;
            this.zoome();
            this.scrollRectToVisible(new Rectangle((u /= 2) - r.width / 2, (v /= 2) - r.height / 2, r.width, r.height));
        } else if (ac.equals("Standard")) {
            this.faktor = 1;
            this.zoome();
        } else if (ac.equals("Aktuell")) {
            this.aktualisiere();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.erstelleKoordinaten(g2, true);
        this.zeichneBalkengrafik(g2);
    }

    void aktualisiere() {
        this.erstelleKoordinaten((Graphics2D)this.getGraphics(), false);
        int aktuell = this.verlauf[0].size() - 1;
        double[] src = new double[]{this.x(0, aktuell) + 75.0, this.y(aktuell) - 15.0, this.x(this.verlauf.length - 1, aktuell) - 30.0, this.y(aktuell) + this.wandhoehe};
        double[] dest = new double[4];
        this.trafo.transform(src, 0, dest, 0, 2);
        this.scrollRectToVisible(new Rectangle((int)dest[0] - 10, (int)dest[3] - 10, (int)(dest[2] - dest[0]) + 20, (int)(dest[1] - dest[3]) + 20));
        this.repaint();
    }

    void beende() {
        if (this.statistik.anzahl() == 0) {
            ++this.anzahl;
            this.bestimmeFaktor();
            this.zoome();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Verlaufsgrafik.this.aktualisiere();
                }
            });
        }
    }

    void starte() {
        this.verlauf = this.statistik.verlauf();
        this.maximalhoehe = this.wandhoehe = Math.ceil((double)(this.statistik.mittelwert() + this.statistik.abweichung()) / 100.0) * 100.0;
        this.anzahl = Integer.max(this.statistik.anzahl(), this.verlauf[0].size());
        this.bestimmeFaktor();
        this.zoome();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Verlaufsgrafik.this.aktualisiere();
            }
        });
    }
}

