/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Verlaufsgrafik;
import jafuffy.bedienung.Verlaufstabelle;
import jafuffy.bedienung.Zwischenstand;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.CEStatistik;
import jafuffy.logik.Statistik;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class Report
extends JDialog
implements PropertyChangeListener,
ChangeListener {
    private static final int BREITE = 480;
    private static final int HOEHE = 480;
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final Border RAHMEN = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
    static final Color[] FARBEN = new Color[]{Color.MAGENTA.darker(), Color.GREEN.darker(), Color.ORANGE.darker(), Color.CYAN.darker()};
    private final Statistik statistik;
    private final JPanel legende = new JPanel(new GridLayout(0, 1, 0, 8));
    private final Verlaufsgrafik verlaufsgrafik;
    private final Verlaufstabelle verlaufstabelle;
    private final Zwischenstand zwischenstand;

    public Report(Statistik statistik) {
        this.statistik = statistik;
        UIManager.addPropertyChangeListener(this);
        this.zwischenstand = new Zwischenstand(statistik);
        JScrollPane zwischenstandscrolling = new JScrollPane(this.zwischenstand);
        zwischenstandscrolling.setBorder(BorderFactory.createTitledBorder(RAHMEN, "(Zwischen)Stand im bisherigen Verlauf des Turniers", 0, 1));
        JScrollPane verlaufsgrafikscrolling = new JScrollPane();
        verlaufsgrafikscrolling.setBorder(RAHMEN);
        this.verlaufsgrafik = this.verlaufsgrafik(verlaufsgrafikscrolling);
        this.verlaufstabelle = new Verlaufstabelle(statistik);
        JPanel verlaufstabellenfeld = this.verlaufstabellenfeld();
        JTabbedPane verlauf = new JTabbedPane();
        verlauf.addTab("Balkendiagramm zum Verlauf", verlaufsgrafikscrolling);
        verlauf.addTab("Tabellenauflistung des Verlaufs", verlaufstabellenfeld);
        verlauf.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.setContentPane(this.feld(zwischenstandscrolling, verlauf));
        this.setTitle(this.titel());
        this.setIconImages(Oberflaeche.LOGOS);
        this.setPreferredSize(new Dimension(480, 480));
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEStatistik.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEStatistik)((Object)cej.ereignis())) {
                case TURNIER_START: 
                case TURNIER_WEITER: {
                    this.starte();
                    this.zwischenstand.starte();
                    this.verlaufsgrafik.starte();
                    this.verlaufstabelle.starte();
                    this.revalidate();
                    break;
                }
                case SPIEL_ENDE: {
                    this.verlaufsgrafik.beende();
                    this.verlaufstabelle.beende();
                    break;
                }
                case STAND: {
                    this.zwischenstand.aktualisiere();
                    this.verlaufsgrafik.aktualisiere();
                    this.verlaufstabelle.aktualisiere();
                    break;
                }
            }
            this.setTitle(this.titel());
            this.repaint();
        }
    }

    private JPanel feld(JScrollPane zwischenstandscrolling, JTabbedPane verlauf) {
        JPanel feld = new JPanel(new BorderLayout(0, 4));
        feld.add((Component)zwischenstandscrolling, "First");
        feld.add((Component)verlauf, "Center");
        feld.add((Component)this.leiste(), "Last");
        feld.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return feld;
    }

    private JPanel leiste() {
        JButton schliessen = new JButton("Report schlie\u00dfen");
        schliessen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Report.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(schliessen);
        JButton zeigen = new JButton("Legende zeigen");
        zeigen.setToolTipText("Zeigt die Zuordnung von Farben zu Spielern");
        zeigen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(Report.this, Report.this.legende, "JaFuffy (Legende)", 1);
            }
        });
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(schliessen);
        leiste.add(zeigen);
        return leiste;
    }

    private void starte() {
        this.legende.removeAll();
        int i = 0;
        while (i < this.statistik.spieler().size()) {
            JLabel name = new JLabel(this.statistik.spieler().get(i).toString(), 0);
            this.legende.add(name);
            name.setOpaque(true);
            name.setForeground(FARBEN[i]);
            name.setBackground(Color.white);
            name.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(FARBEN[i], 2), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
            ++i;
        }
    }

    private String titel() {
        if (this.statistik.verlauf() == null) {
            return "JaFuffy (Report)";
        }
        if (this.statistik.istTurnierLaufend()) {
            if (this.statistik.anzahl() == 0 || this.statistik.anzahl() > 1) {
                return "JaFuffy (Report: " + this.statistik.verlauf()[0].size() + ". Spiel im Turnier)";
            }
            return "JaFuffy (Report: Einziges Spiel im Turnier)";
        }
        return "JaFuffy (Report: Turnierendergebnis)";
    }

    private Verlaufsgrafik verlaufsgrafik(final JScrollPane verlaufsgrafikscrolling) {
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){
            private int x;
            private int y;

            @Override
            public void mouseDragged(MouseEvent event) {
                Rectangle rechteck = verlaufsgrafikscrolling.getViewport().getViewRect();
                rechteck.translate(this.x - event.getX(), this.y - event.getY());
                ((JPanel)event.getSource()).scrollRectToVisible(rechteck);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.x = e.getX();
                this.y = e.getY();
            }
        };
        Verlaufsgrafik grafik = new Verlaufsgrafik(this.statistik);
        grafik.addMouseMotionListener(mouseInputListener);
        grafik.addMouseListener(mouseInputListener);
        verlaufsgrafikscrolling.setViewportView(grafik);
        return grafik;
    }

    private JPanel verlaufstabellenfeld() {
        final JPanel verlaufstabellenfeld = new JPanel();
        verlaufstabellenfeld.setBorder(RAHMEN);
        JScrollPane verlaufstabellenscrolling = new JScrollPane(this.verlaufstabelle){

            @Override
            public Dimension getPreferredSize() {
                Insets rand = this.getInsets();
                Insets verlaufstabellenfeldrand = verlaufstabellenfeld.getInsets();
                Dimension verlaufstabellengroesse = Report.this.verlaufstabelle.getPreferredSize();
                Dimension verlaufstabellenfeldgroesse = verlaufstabellenfeld.getSize();
                return new Dimension(verlaufstabellengroesse.width + this.getVerticalScrollBar().getWidth() + rand.left + rand.right, verlaufstabellenfeldgroesse.height - verlaufstabellenfeldrand.top - verlaufstabellenfeldrand.bottom - rand.top - 1 - rand.bottom - 1);
            }
        };
        verlaufstabellenscrolling.setVerticalScrollBarPolicy(22);
        verlaufstabellenfeld.add(verlaufstabellenscrolling);
        return verlaufstabellenfeld;
    }
}

