/******************************************************************************
 ** $Id: BalkenStand.java 794 2015-10-13 20:54:59Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.logik.Spieler;
import jafuffy.logik.Statistik;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

import javax.swing.JPanel;

/**
 * Anzeige aller erwrfelten Punkte, nach jeder Runde aktualisiert.
 */
@SuppressWarnings("serial")
class BalkenStand extends JPanel {

    // Konstanten fr Balkengrafik
    private static final int BREITE = 400, LUECKE = 6, BALKENDICKE = 12;

    // Statistikdaten
    private final Statistik statistik;
    // erwartete Punkte fr das ganze Turnier
    private int erwartetePunkte;
    // Stand erst nach jeder Runde aktualisieren (zwischenspeichern!)
    private int[] staende;

    /**
     * Konstruktor.
     *
     * @param statistik
     */
    BalkenStand(Statistik statistik) {
        setBackground(Color.white);
        setToolTipText("Alle bisher im Turnier erspielten Punkte");
        this.statistik = statistik;
    }

    /**
     * Gewnschte Gre bekanntgeben.
     */
    @Override
    public Dimension getPreferredSize() {
        if (statistik.spieler() == null) {
            return new Dimension(BREITE, Spieler.SPIELER * (BALKENDICKE + LUECKE) + LUECKE);
        } else {
            return new Dimension(BREITE, statistik.spieler().size() * (BALKENDICKE + LUECKE)
                    + LUECKE);
        }
    }

    /**
     * Balkendiagramm neu zeichnen.
     */
    @Override
    public void paintComponent(Graphics g) {

        int i;
        int n = statistik.spieler().size();
        int y;
        int h;

        g.setFont(new Font("Dialog", Font.BOLD, 12));
        FontMetrics fm = g.getFontMetrics();
        super.paintComponent(g);
        for (i = 0; i < n; i++) {
            g.setColor(Report.FARBEN[i]);
            h =
                    (getWidth() - fm.stringWidth(String.valueOf(erwartetePunkte)) - fm
                            .charWidth(' ')) * staende[i] / erwartetePunkte;
            y = (getHeight() - n * BALKENDICKE) * (i + 1) / (n + 1) + i * BALKENDICKE;
            g.fillRect(0, y, h, BALKENDICKE);
            g.drawString(String.valueOf(staende[i]), h + fm.charWidth(' '), y
                    + (BALKENDICKE - 1 + fm.getAscent()) / 2 - 1);
        }

    }

    /**
     * Neues Turnier gestartet.
     */
    void neuesTurnier() {
        staende = new int[statistik.spieler().size()];
        erwartetePunkte =
                statistik.mittelwert() * (statistik.anzahl() == 0 ? 1 : statistik.anzahl());
        neuerStand();
        repaint();
    }

    /**
     * Neuer Stand.
     */
    void neuerStand() {
        boolean schaetzen = false;
        for (int i = 0; i < statistik.spieler().size(); i++) {
            staende[i] = statistik.stand(i);
            if (staende[i] > erwartetePunkte) {
                schaetzen = true;
                erwartetePunkte = staende[i];
            }
        }
        if (schaetzen) {
            if (statistik.anzahl() == 0) {
                erwartetePunkte *= 2;
            } else {
                erwartetePunkte +=
                        statistik.mittelwert() * statistik.rest() + statistik.abweichung();
            }
        }
        for (int i = 0; i < statistik.spieler().size(); i++) {
            staende[i] = statistik.stand(i);
        }
    }

}
