/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.logik.Aenderungen;
import jafuffy.logik.Analyse;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;

public abstract class Auswertung
extends Aenderungen<CEAblauf> {
    private static final long serialVersionUID = -7315969783651586016L;
    protected final Analyse analyse;
    protected final Wuerfel[] wuerfel;
    protected Spieler aktiver;
    protected boolean sindTippsAngefordert;

    protected Auswertung(Wuerfel[] wuerfel, Analyse analyse) {
        this.wuerfel = wuerfel;
        this.analyse = analyse;
    }

    public abstract int abweichung();

    public Tabzeile bester() {
        return this.analyse.bester();
    }

    public boolean bester(Tabzeile eintrag) {
        return this.analyse.bester() == eintrag;
    }

    public void erstelleVorschlag(Tabzeile eintrag) {
        Wuerfel[] wuerfelArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = wuerfelArray[n2];
            w.setzeVorschlag(this.analyse.erneut(eintrag, w));
            ++n2;
        }
        this.fireStateChanged(CEAblauf.VORGESCHLAGEN);
    }

    public boolean istVorschlagEntsprechendWuerfelauswahl(Tabzeile eintrag) {
        return this.analyse.vorgeschlagen(eintrag);
    }

    public abstract int mittelwert();

    public boolean sindTippsAngefordert() {
        return this.sindTippsAngefordert;
    }

    public String spicker(Tabzeile eintrag) {
        String text;
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.aktiver.gewuerfelt() && this.aktiver.setzbar(eintrag) && eintrag.alle()) {
            int punkte = this.wert(eintrag);
            text = String.valueOf(new Integer(punkte).toString()) + (punkte != 1 ? " Punkte" : " Punkt");
            if (this.sindTippsAngefordert()) {
                text = "<html><p>" + text + "</p>" + "<p><small><i>Siehe auch Kontextmen\u00fc!</i></small></p>" + "<p><small><i>Beachte Men\u00fc \"Extras\".</i></small></p>" + "</html>";
            }
        } else {
            text = null;
        }
        return text;
    }

    public abstract String text(Tabzeile var1);

    public abstract String toString();

    public abstract int wert(Tabzeile var1);

    public double wichtung(Tabzeile eintrag) {
        return this.analyse.wichtung(eintrag);
    }

    void aktiviereTipps(boolean tipps) {
        if (tipps) {
            if (!this.sindTippsAngefordert) {
                this.analyse.prognostiziere(this.aktiver);
                this.sindTippsAngefordert = true;
            }
        } else {
            this.sindTippsAngefordert = false;
        }
    }

    void erstelleVorschlag() {
        this.aktiviereTipps(true);
        this.erstelleVorschlag(this.bester());
    }

    void reagiereAufWurf(Spieler spieler) {
        this.aktiver = spieler;
        this.sindTippsAngefordert = false;
        this.analyse.errechne();
    }
}

