/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.hello;

import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;
import java.util.ArrayList;
import java.util.Properties;

public class HelloConsolePanel
extends AbstractConsolePanel {
    public HelloConsolePanel(PanelView<ConsolePanel> panel) {
        super(panel);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.display(installData, console);
        return this.promptEndPanel(installData, console);
    }

    protected void display(InstallData installData, Console console) {
        Messages messages = installData.getMessages();
        Info info = installData.getInfo();
        String welcomeText = messages.get("HelloPanel.welcome1", new Object[0]) + info.getAppName() + " " + info.getAppVersion() + messages.get("HelloPanel.welcome2", new Object[0]);
        console.println(welcomeText);
        ArrayList<Info.Author> authors = info.getAuthors();
        if (!authors.isEmpty()) {
            console.println(messages.get("HelloPanel.authors", new Object[0]));
            for (Info.Author author : authors) {
                String email = author.getEmail() != null && author.getEmail().length() > 0 ? " <" + author.getEmail() + ">" : "";
                console.println(" - " + author.getName() + email);
            }
        }
        if (info.getAppURL() != null) {
            String urlText = messages.get("HelloPanel.url", new Object[0]) + info.getAppURL();
            console.println(urlText);
        }
    }
}

