/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.auswertung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Auswahl;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.auswertung.Klassisch;

public class Erweitert
extends Klassisch {
    private static final long serialVersionUID = -5463902030609191338L;
    public static final Class<? extends Auswahl> AUSWAHLKLASSE = jafuffy.bedienung.auswahl.Erweitert.class;
    public static final String REGEL = "Erweiterte Regeln";
    private static final int ABWEICHUNG = 60;
    private static final int MITTELWERT = 240;
    public static final int JOKER = 100;
    private boolean istBonusnachrichtAngefordert = false;
    private boolean istJokerNachrichtAngefordert = false;
    private boolean istSetzzwangNachrichtAngefordert = false;

    public Erweitert(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    @Override
    public int abweichung() {
        return 60;
    }

    public boolean istJokerVorliegend() {
        return super.wert(Tabzeile.JAFUFFY) > 0 && this.aktiver.punkte(Tabzeile.JAFUFFY) > 0 && !this.aktiver.setzbar(Tabzeile.oben(this.wuerfel[0].augen()));
    }

    @Override
    public int mittelwert() {
        return 240;
    }

    public boolean setzzwang() {
        return super.wert(Tabzeile.JAFUFFY) > 0 && this.aktiver.punkte(Tabzeile.JAFUFFY) > 0 && this.aktiver.setzbar(Tabzeile.oben(this.wuerfel[0].augen()));
    }

    @Override
    public String spicker(Tabzeile eintrag) {
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.aktiver.gewuerfelt() && this.istJokerVorliegend() && eintrag == Tabzeile.JAFUFFY) {
            String text = "<p align=center><em>Joker (+ 100 Bonuspunkte)!</em></p><p>Bitte Wurf in freies Feld eintragen.</p>";
            if (this.sindTippsAngefordert()) {
                return "<html>" + text + "<p>Kontextmen\u00fc!</p></html>";
            }
            return "<html>" + text + "</html>";
        }
        return super.spicker(eintrag);
    }

    @Override
    public String text(Tabzeile eintrag) {
        if (eintrag == Tabzeile.JAFUFFY && this.istJokerNachrichtAngefordert) {
            return "Joker!";
        }
        if (eintrag == Tabzeile.JAFUFFY && this.istBonusnachrichtAngefordert) {
            return "Bonus!";
        }
        if (this.istSetzzwangNachrichtAngefordert && eintrag == Tabzeile.oben(this.wuerfel[0].augen())) {
            return "Gesetzt!";
        }
        return null;
    }

    @Override
    public String toString() {
        return REGEL;
    }

    @Override
    public int wert(Tabzeile eintrag) {
        switch (eintrag) {
            case KLEINESTRASSE: {
                return this.istJokerVorliegend() || super.wert(eintrag) > 0 ? 30 : 0;
            }
            case GROSSESTRASSE: {
                return this.istJokerVorliegend() || super.wert(eintrag) > 0 ? 40 : 0;
            }
            case JAFUFFY: {
                if (super.wert(eintrag) <= 0 || this.aktiver.punkte(eintrag) <= 0) break;
                return this.aktiver.punkte(eintrag) + 100;
            }
        }
        return super.wert(eintrag);
    }

    public void zeigeBonusnachricht(boolean istBonusErzielt) {
        this.istBonusnachrichtAngefordert = istBonusErzielt;
    }

    public void zeigeJokernachricht(boolean istJokerVerfuegbar) {
        if (istJokerVerfuegbar) {
            Wuerfel[] wuerfelArray = this.wuerfel;
            int n = this.wuerfel.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                w.setEnabled(false);
                ++n2;
            }
        }
        this.istJokerNachrichtAngefordert = istJokerVerfuegbar;
    }

    public void zeigeSetzzwangnachricht(boolean istSetzzwangGegeben) {
        if (istSetzzwangGegeben) {
            Wuerfel[] wuerfelArray = this.wuerfel;
            int n = this.wuerfel.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                w.setEnabled(false);
                ++n2;
            }
        }
        this.istSetzzwangNachrichtAngefordert = istSetzzwangGegeben;
    }
}

