/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Report;
import jafuffy.logik.Statistik;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;

class BalkenStand
extends JPanel {
    private static final int BREITE = 400;
    private static final int LUECKE = 6;
    private static final int BALKENDICKE = 12;
    private final Statistik statistik;
    private int erwartetePunkte;
    private int[] staende;

    BalkenStand(Statistik statistik) {
        this.setBackground(Color.white);
        this.setToolTipText("Alle bisher im Turnier erspielten Punkte");
        this.statistik = statistik;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.statistik.spieler() == null) {
            return new Dimension(400, 78);
        }
        return new Dimension(400, this.statistik.spieler().size() * 18 + 6);
    }

    @Override
    public void paintComponent(Graphics g) {
        int n = this.statistik.spieler().size();
        g.setFont(new Font("Dialog", 1, 12));
        FontMetrics fm = g.getFontMetrics();
        super.paintComponent(g);
        int i = 0;
        while (i < n) {
            g.setColor(Report.FARBEN[i]);
            int h = (this.getWidth() - fm.stringWidth(String.valueOf(this.erwartetePunkte)) - fm.charWidth(' ')) * this.staende[i] / this.erwartetePunkte;
            int y = (this.getHeight() - n * 12) * (i + 1) / (n + 1) + i * 12;
            g.fillRect(0, y, h, 12);
            g.drawString(String.valueOf(this.staende[i]), h + fm.charWidth(' '), y + (11 + fm.getAscent()) / 2 - 1);
            ++i;
        }
    }

    void neuesTurnier() {
        this.staende = new int[this.statistik.spieler().size()];
        this.erwartetePunkte = this.statistik.mittelwert() * (this.statistik.anzahl() == 0 ? 1 : this.statistik.anzahl());
        this.neuerStand();
        this.repaint();
    }

    void neuerStand() {
        boolean schaetzen = false;
        int i = 0;
        while (i < this.statistik.spieler().size()) {
            this.staende[i] = this.statistik.stand(i);
            if (this.staende[i] > this.erwartetePunkte) {
                schaetzen = true;
                this.erwartetePunkte = this.staende[i];
            }
            ++i;
        }
        if (schaetzen) {
            this.erwartetePunkte = this.statistik.anzahl() == 0 ? (this.erwartetePunkte *= 2) : (this.erwartetePunkte += this.statistik.mittelwert() * this.statistik.rest() + this.statistik.abweichung());
        }
        i = 0;
        while (i < this.statistik.spieler().size()) {
            this.staende[i] = this.statistik.stand(i);
            ++i;
        }
    }
}

