/******************************************************************************
 ** $Id: Pfad.java 748 2015-07-19 20:40:59Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.Eigenschaften;

import java.awt.Component;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/** Pfad zu Statistik-Daten und Turnierstnden auswhlen. */
@SuppressWarnings("serial")
public class Pfad extends JFileChooser {

    /**
     * Konstruktor.
     *
     * @param eigenschaften
     *            Die Eigenschaften enthalten den Pfad zur Speicherung der Statistik und den
     *            Turnierstnden.
     * @param feld
     *            Dialog wird zum Feld zentriert
     */
    Pfad(Eigenschaften eigenschaften, Component feld) {

        super(eigenschaften.pfad());
        setDialogTitle("JaFuffy"
                + " (Frage nach Speicherort von Statistikdaten und Turnierstnden)");
        setFileSelectionMode(DIRECTORIES_ONLY);

        if (showDialog(feld, "Dorthin speichern") == CANCEL_OPTION) {
            Signal.WARNUNG.play();
            JOptionPane.showMessageDialog(feld, "Kein Pfad gewhlt!\n"
                    + "Momentan eingestellter Pfad:\n" + eigenschaften.pfad(),
                    "JaFuffy (Warnung)", JOptionPane.WARNING_MESSAGE);
        } else {
            eigenschaften.pfad(getSelectedFile().getAbsolutePath());
        }

    }

}
