/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

final class Kombinatorik {
    private static final float[] AUGENZAHLEN = new float[]{0.0f, 3.5f, 4.25f, 4.6666665f};
    private static final float[] GLEICHENWAHRSCHEINLICHKEIT = new float[]{0.09259259f, 0.6944444f, 0.19290124f, 0.019290123f, 7.7160494E-4f};
    private static final int[][] STIRLING2 = new int[6][];

    static {
        Kombinatorik.STIRLING2[0] = new int[1];
        Kombinatorik.STIRLING2[0][0] = 1;
        int n = 1;
        while (n <= 5) {
            Kombinatorik.STIRLING2[n] = new int[n + 1];
            Kombinatorik.STIRLING2[n][0] = 0;
            int k = 1;
            while (k < n) {
                Kombinatorik.STIRLING2[n][k] = k * STIRLING2[n - 1][k] + STIRLING2[n - 1][k - 1];
                ++k;
            }
            Kombinatorik.STIRLING2[n][n] = 1;
            ++n;
        }
    }

    static float augenzahl(int rest) {
        return AUGENZAHLEN[rest];
    }

    static int binom(int n, int k) {
        if (k < 0 || k > n) {
            return 0;
        }
        if (2 * k > n) {
            return Kombinatorik.binom(n, n - k);
        }
        int koeffizient = 1;
        n -= k;
        int i = 1;
        while (i <= k) {
            koeffizient *= ++n;
            koeffizient /= i;
            ++i;
        }
        return koeffizient;
    }

    static int fakultaet(int n) {
        int p = 1;
        while (n > 0) {
            p *= n;
            --n;
        }
        return p;
    }

    static int fallend(int n, int k) {
        int p;
        if (k < 0) {
            p = 0;
        } else {
            p = 1;
            int i = 0;
            while (i < k) {
                p *= n;
                ++i;
                --n;
            }
        }
        return p;
    }

    static float gleichenmittel(int n, int r) {
        float p = 1.0f - (float)Math.pow(0.8333333134651184, r);
        return (float)n * p;
    }

    static float gleichenwahrscheinlichkeit(int m) {
        return GLEICHENWAHRSCHEINLICHKEIT[m - 1];
    }

    static float gleichenwahrscheinlichkeit(int n, int r) {
        float p = 1.0f - (float)Math.pow(0.8333333134651184, r);
        return (float)Math.pow(p, n);
    }

    static float gleichenwahrscheinlichkeit(int n, int k, int r) {
        float p = 1.0f - (float)Math.pow(0.8333333134651184, r);
        return (float)Kombinatorik.binom(n, k) * (float)Math.pow(p, k) * (float)Math.pow(1.0f - p, n - k);
    }

    static float mindestgleichenwahrscheinlichkeit(int n, int min, int r) {
        float p = 0.0f;
        int k = min;
        while (k <= 5) {
            p += Kombinatorik.gleichenwahrscheinlichkeit(n, k, r);
            ++k;
        }
        return p;
    }

    static float mindestgleichenwahrscheinlichkeit(int min) {
        return Kombinatorik.mindestgleichenwahrscheinlichkeit(5, min, 3);
    }

    static int stirling2(int n, int k) {
        if (k <= n) {
            return STIRLING2[n][k];
        }
        return 0;
    }

    static int strassenteilschablone(int n, int d, int k) {
        int summe = 0;
        int i = k;
        while (i <= n) {
            summe = (int)((double)summe + (double)(Kombinatorik.stirling2(i, k) * Kombinatorik.binom(n, i)) * Math.pow(d, n - i));
            ++i;
        }
        return summe;
    }

    static float strassenteilsequenz(int n, int d, int k, int m) {
        return Kombinatorik.fallend(m, k) * Kombinatorik.strassenteilschablone(n, d, k);
    }

    private Kombinatorik() {
    }
}

