/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Wuerfelfeld;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Status
extends JPanel
implements ChangeListener {
    private static final int NACHRICHTENSCHRIFTGROESSE = 12;
    private static final int VERTIKALABSTAND = 4;
    private final Verfolgung verfolgung;
    private final JLabel nachricht = new JLabel();
    private final JLabel restanzeige = new JLabel();

    Status(Wuerfelfeld.Kontextmenue kontextmenue, Verfolgung verfolgung) {
        super(new BorderLayout());
        this.verfolgung = verfolgung;
        verfolgung.addMouseListener(kontextmenue);
        this.dekoriere(kontextmenue);
        this.add((Component)this.baue(), "Center");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: 
                case SPIEL: 
                case GEWUERFELT: 
                case GESETZT: 
                case RUECKGAENGIG: {
                    this.aktualisiere((Turnier)ce.getSource());
                    break;
                }
                case RESULTAT: {
                    this.beendeSpiel();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.beendeTurnier();
                    break;
                }
            }
            this.verfolgung.stateChanged(ce);
        }
    }

    private void aktualisiere(Turnier turnier) {
        Spieler aktiver = turnier.aktiver();
        int rest = aktiver.rest();
        boolean fertig = rest == 0;
        this.nachricht.setText(String.valueOf(aktiver.toString()) + " ist an der Reihe!");
        this.nachricht.setFont(new Font("Dialog", 1, 12));
        if (fertig) {
            this.restanzeige.setText("Bitte in der Tabelle setzen!");
        } else {
            this.restanzeige.setText(String.valueOf(rest) + " mal darf noch gew\u00fcrfelt werden.");
        }
    }

    private JPanel baue() {
        JPanel elemente = new JPanel();
        elemente.setLayout(new BoxLayout(elemente, 1));
        elemente.add(Box.createVerticalGlue());
        elemente.add(Box.createVerticalStrut(4));
        elemente.add(this.verfolgung);
        elemente.add(Box.createVerticalStrut(4));
        elemente.add(Box.createVerticalGlue());
        elemente.add(this.nachricht);
        elemente.add(Box.createVerticalStrut(4));
        elemente.add(this.restanzeige);
        elemente.add(Box.createVerticalGlue());
        return elemente;
    }

    private void beendeSpiel() {
        this.nachricht.setText(" ");
        this.restanzeige.setText(" ");
    }

    private void beendeTurnier() {
        this.nachricht.setText("Das Turnier ist beendet!");
        this.nachricht.setFont(new Font("Dialog", 3, 12));
        this.restanzeige.setText(" ");
    }

    private void dekoriere(Wuerfelfeld.Kontextmenue kontextmenue) {
        this.nachricht.setAlignmentX(0.5f);
        this.restanzeige.setAlignmentX(0.5f);
    }
}

