/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    public static File convertUrlToFile(URL url) {
        return new File(FileUtil.convertUrlToFilePath(url));
    }

    public static String convertUrlToFilePath(URL url) {
        try {
            return URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getLockFile(String applicationName) {
        String tempDir = System.getProperty("java.io.tmpdir");
        String fileName = "iz-" + applicationName + ".tmp";
        return new File(tempDir, fileName);
    }

    public static List<String> getFileContent(String fileName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File aFile = new File(fileName);
        if (!aFile.isFile()) {
            return result;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(aFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return result;
        }
        String aLine = null;
        while ((aLine = reader.readLine()) != null) {
            result.add(aLine + "\n");
        }
        reader.close();
        return result;
    }

    public static boolean fileContains(String aFileName, String aSearchString) {
        return FileUtil.fileContains(aFileName, aSearchString, false);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean fileContains(String aFileName, String aSearchString, boolean caseInSensitiveSearch) {
        boolean result = false;
        String searchString = caseInSensitiveSearch ? aSearchString.toLowerCase() : aSearchString;
        List<Object> fileContent = new ArrayList();
        try {
            fileContent = FileUtil.getFileContent(aFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String string : fileContent) {
            void var7_8;
            if (caseInSensitiveSearch) {
                String string2 = string.toLowerCase();
            }
            if (!var7_8.contains(searchString)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static long getFileDateTime(URL url) {
        if (url == null) {
            return -1L;
        }
        String fileName = url.getFile();
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            fileName = fileName.substring(1, fileName.length());
        }
        try {
            File file = new File(fileName);
            if (!file.isDirectory() && !file.isFile()) {
                return -1L;
            }
            return file.lastModified();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static String[] getFileNames(String dirPath) throws Exception {
        return FileUtil.getFileNames(dirPath, null);
    }

    public static String[] getFileNames(String dirPath, FilenameFilter fileNameFilter) throws Exception {
        String[] fileNames = null;
        File dir = new File(dirPath);
        if (dir.isDirectory()) {
            fileNames = fileNameFilter != null ? dir.list(fileNameFilter) : dir.list();
        }
        return fileNames;
    }

    public static File getAbsoluteFile(String filename, String basedir) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(basedir, file.getPath());
    }

    public static String getRelativeFileName(File file, File basedir) throws IOException {
        int length;
        String canonicalBaseDirPath;
        String canonicalFilePath = file.getCanonicalPath();
        if (canonicalFilePath.startsWith(canonicalBaseDirPath = basedir.getCanonicalPath()) && (length = canonicalBaseDirPath.length()) < canonicalFilePath.length()) {
            return canonicalFilePath.substring(length + 1);
        }
        return null;
    }
}

