/******************************************************************************
 ** $Id$
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

/** Beginnmodus. */
public enum Beginner {

    /** Verlierer beginnt das nchste Spiel. */
    VERLIERER("Verlierer beginnt"),
    /** Gewinner beginnt das nchste Spiel. */
    GEWINNER("Gewinner beginnt"),
    /** Immer derselbe beginnt das nchste Spiel. */
    DERSELBE("Immer derselbe beginnt"),
    /** Beginn verluft reihum. */
    REIHUM("Beginner reihum auswhlen"),
    /** Beginner fr das nchste Spiel zufllig ausgewhlt. */
    ZUFALL("Beginner zufllig auswhlen");

    /** Name des Beginnmodus. */
    private final String bezeichnung;

    /**
     * Konstruktor.
     *
     * @param bezeichnung
     *            Bezeichnung des Beginnmodus
     */
    Beginner(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }

    /** Umwandlung in String. */
    @Override
    public String toString() {
        return bezeichnung;
    }
}
