/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.AuswertungKlassisch;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;

public class AuswertungImHieb
extends AuswertungKlassisch {
    private static final long serialVersionUID = 6730182688848850948L;
    private static final int IM_HIEB_MIN = 5;
    private static final int IM_HIEB_MAX = 30;
    private static final int MITTELWERT = 235;
    private static final int ABWEICHUNG = 45;
    static final String REGEL = "Im-Hieb-Regeln";
    private boolean imHiebNachricht = false;
    private Tabzeile imHiebEintrag;

    public AuswertungImHieb(Wuerfel[] wuerfel) {
        super(wuerfel);
    }

    @Override
    public String toString() {
        return REGEL;
    }

    public void imHiebNachrichtDeaktiv() {
        this.imHiebNachricht = false;
    }

    public void imHiebNachrichtAktiv(Tabzeile imHiebEintrag) {
        this.imHiebEintrag = imHiebEintrag;
        this.imHiebNachricht = true;
    }

    public boolean imHieb(Tabzeile eintrag) {
        return eintrag.unten() && eintrag != Tabzeile.CHANCE && this.aktiver.einmalig() && super.wert(eintrag) > 0;
    }

    @Override
    int mittelwert() {
        return 235;
    }

    @Override
    int abweichung() {
        return 45;
    }

    @Override
    public int wert(Tabzeile eintrag) {
        if (this.imHieb(eintrag)) {
            return super.wert(eintrag) + (eintrag == Tabzeile.JAFUFFY ? 30 : 5);
        }
        return super.wert(eintrag);
    }

    @Override
    public String text(Tabzeile eintrag) {
        return this.imHiebNachricht && eintrag == this.imHiebEintrag ? "Im Hieb!" : null;
    }
}

