/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Kombinatorik;
import jafuffy.logik.Spieler;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Wuerfel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

class Analyse
implements Serializable {
    private static final long serialVersionUID = -6325984568972413728L;
    private static final int EINS = 0;
    private static final int ZWEI = 1;
    private static final int DREI = 2;
    private static final int VIER = 3;
    private static final int FUENF = 4;
    private static final int SECHS = 5;
    private static final int ZWEI_GLEICHE = 0;
    private static final int DREI_GLEICHE = 1;
    private static final int VIER_GLEICHE = 2;
    private static final int FUENF_GLEICHE = 3;
    private static final float[] RESTWAHRSCHEINLICHKEIT = new float[]{0.03935185f, 0.23148148f, 0.1736111f, 0.46296296f, 0.0f, 0.09259259f};
    private static final Random ZUFALL = new Random();
    private static final float NEUTRALWICHTUNG = 1.0f;
    private Tabzeile bester;
    private int augensumme;
    private final int[] anzahl = new int[6];
    private final boolean[] gleich = new boolean[4];
    private final Wuerfel[] wuerfel;
    private final HashMap<Tabzeile, Eintrag> eintraege = new HashMap(Tabzeile.ANZAHL);

    Analyse(Wuerfel[] wuerfel) {
        this.wuerfel = wuerfel;
        this.eintraege.put(Tabzeile.EINS, new Oben(0));
        this.eintraege.put(Tabzeile.ZWEI, new Oben(1));
        this.eintraege.put(Tabzeile.DREI, new Oben(2));
        this.eintraege.put(Tabzeile.VIER, new Oben(3));
        this.eintraege.put(Tabzeile.FUENF, new Oben(4));
        this.eintraege.put(Tabzeile.SECHS, new Oben(5));
        this.eintraege.put(Tabzeile.GESAMT, null);
        this.eintraege.put(Tabzeile.BONUS, null);
        this.eintraege.put(Tabzeile.OSUMME, null);
        this.eintraege.put(Tabzeile.DREIERPASCH, new Pasch(3));
        this.eintraege.put(Tabzeile.VIERERPASCH, new Pasch(4));
        this.eintraege.put(Tabzeile.FULLHOUSE, new FullHouse());
        this.eintraege.put(Tabzeile.KLEINESTRASSE, new KleineStrasse());
        this.eintraege.put(Tabzeile.GROSSESTRASSE, new GrosseStrasse());
        this.eintraege.put(Tabzeile.JAFUFFY, new JaFuffy());
        this.eintraege.put(Tabzeile.CHANCE, new Chance());
        this.eintraege.put(Tabzeile.USUMME, null);
        this.eintraege.put(Tabzeile.ESUMME, null);
    }

    private float findeMaximum(Spieler spieler) {
        float max = 0.0f;
        this.bester = null;
        Tabzeile[] tabzeileArray = Tabzeile.ALLE;
        int n = Tabzeile.ALLE.length;
        int n2 = 0;
        while (n2 < n) {
            float endstand;
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z) && (endstand = this.eintraege.get((Object)z).endsumme()) > max) {
                this.bester = z;
                max = endstand;
            }
            ++n2;
        }
        return max;
    }

    private float findeMinimum(Spieler spieler, float max) {
        float min = max;
        Tabzeile[] tabzeileArray = Tabzeile.ALLE;
        int n = Tabzeile.ALLE.length;
        int n2 = 0;
        while (n2 < n) {
            float endstand;
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z) && (endstand = this.eintraege.get((Object)z).endsumme()) < min) {
                min = endstand;
            }
            ++n2;
        }
        return min;
    }

    private void gewichte(Spieler spieler, float min, float max) {
        Tabzeile[] tabzeileArray = Tabzeile.ALLE;
        int n = Tabzeile.ALLE.length;
        int n2 = 0;
        while (n2 < n) {
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z)) {
                if (max - min > 0.0f) {
                    float endstand = this.eintraege.get((Object)z).endsumme();
                    this.eintraege.get((Object)z).gewichte((endstand - min) / (max - min));
                } else {
                    this.eintraege.get((Object)z).gewichte(1.0f);
                }
            } else {
                this.eintraege.get((Object)z).gewichte(0.0f);
            }
            ++n2;
        }
    }

    private void tippe(Spieler spieler) {
        float mittlererObererZuwachs = 0.0f;
        int anzahlObereFreieEintraege = 0;
        int augensummeObereFreieEintraege = 0;
        Tabzeile[] tabzeileArray = Tabzeile.OBEN;
        int n = Tabzeile.OBEN.length;
        int n2 = 0;
        while (n2 < n) {
            Tabzeile z = tabzeileArray[n2];
            if (spieler.setzbar(z)) {
                Oben eintrag = (Oben)this.eintraege.get((Object)z);
                mittlererObererZuwachs += eintrag.mittel();
                ++anzahlObereFreieEintraege;
                augensummeObereFreieEintraege += eintrag.augen;
            }
            ++n2;
        }
        float mittlererUntererZuwachs = 0.0f;
        Tabzeile[] tabzeileArray2 = Tabzeile.UNTEN;
        int n3 = Tabzeile.UNTEN.length;
        n = 0;
        while (n < n3) {
            Tabzeile z = tabzeileArray2[n];
            if (spieler.setzbar(z)) {
                mittlererUntererZuwachs += this.eintraege.get((Object)z).mittel();
            }
            ++n;
        }
        Zuwachs zuwachs = new Zuwachs(spieler.gesamt(), mittlererObererZuwachs, augensummeObereFreieEintraege, anzahlObereFreieEintraege, mittlererUntererZuwachs);
        Tabzeile[] tabzeileArray3 = Tabzeile.ALLE;
        int n4 = Tabzeile.ALLE.length;
        n3 = 0;
        while (n3 < n4) {
            Tabzeile z = tabzeileArray3[n3];
            if (spieler.setzbar(z)) {
                this.eintraege.get((Object)z).tippe(spieler, zuwachs);
            }
            ++n3;
        }
    }

    Tabzeile bester() {
        return this.bester;
    }

    boolean erneut(Tabzeile eintrag, int w) {
        return this.eintraege.get((Object)eintrag).erneut(w);
    }

    void errechne() {
        Arrays.fill(this.anzahl, 0);
        this.augensumme = 0;
        Object[] objectArray = this.wuerfel;
        int n = this.wuerfel.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel w = objectArray[n2];
            this.augensumme += w.augen();
            int n3 = w.augen() - 1;
            this.anzahl[n3] = this.anzahl[n3] + 1;
            ++n2;
        }
        int j = 0;
        while (j <= 3) {
            this.gleich[j] = false;
            int i = 0;
            while (i < 6) {
                this.gleich[j] = this.anzahl[i] == j + 2 || this.gleich[j];
                ++i;
            }
            ++j;
        }
        objectArray = Tabzeile.ALLE;
        n = Tabzeile.ALLE.length;
        n2 = 0;
        while (n2 < n) {
            Wuerfel z = objectArray[n2];
            this.eintraege.get(z).bewerte();
            ++n2;
        }
    }

    void prognostiziere(Spieler spieler) {
        this.tippe(spieler);
        float max = this.findeMaximum(spieler);
        float min = this.findeMinimum(spieler, max);
        this.gewichte(spieler, min, max);
    }

    boolean vorgeschlagen(Tabzeile eintrag) {
        int[] anzahlenJeAugenAusgewaehlte = new int[6];
        int[] anzahlenJeAugenVorgeschlagene = new int[6];
        int w = 0;
        while (w < 5) {
            int a = this.wuerfel[w].augen() - 1;
            if (this.wuerfel[w].isSelected()) {
                int n = a;
                anzahlenJeAugenAusgewaehlte[n] = anzahlenJeAugenAusgewaehlte[n] + 1;
            }
            if (this.eintraege.get((Object)eintrag).erneut(w)) {
                int n = a;
                anzahlenJeAugenVorgeschlagene[n] = anzahlenJeAugenVorgeschlagene[n] + 1;
            }
            ++w;
        }
        int a = 0;
        while (a < 6) {
            if (anzahlenJeAugenAusgewaehlte[a] != anzahlenJeAugenVorgeschlagene[a]) {
                return false;
            }
            ++a;
        }
        return true;
    }

    int wert(Tabzeile eintrag) {
        return this.eintraege.get((Object)eintrag).wert();
    }

    float wichtung(Tabzeile eintrag) {
        return this.eintraege.get((Object)eintrag).wichtung();
    }

    class Chance
    extends Unten {
        private static final long serialVersionUID = -3411668587180538841L;
        private float punkte;

        Chance() {
            this.mittel = 5.0f * Kombinatorik.augenzahl(3);
        }

        @Override
        float prognose(Spieler spieler, Zuwachs zuwachs) {
            return this.punkte;
        }

        @Override
        int punkte() {
            return Analyse.this.augensumme;
        }

        @Override
        void waehle(Spieler spieler) {
            this.punkte = 0.0f;
            int w = 0;
            while (w < 5) {
                int a;
                float m = Kombinatorik.augenzahl(spieler.rest());
                this.erneut[w] = m > (float)(a = Analyse.this.wuerfel[w].augen());
                this.punkte += this.erneut[w] ? m : (float)a;
                ++w;
            }
        }
    }

    abstract class Eintrag
    implements Serializable {
        private static final long serialVersionUID = -1491939796847928172L;
        protected float endsumme;
        private float wichtung;
        protected int wert;
        protected boolean[] erneut = new boolean[5];
        protected float mittel;

        Eintrag() {
        }

        void bewerte() {
            this.wert = this.punkte();
        }

        float endsumme() {
            return this.endsumme;
        }

        abstract float endsumme(Spieler var1, Zuwachs var2);

        boolean erneut(int w) {
            return this.erneut[w];
        }

        void gewichte(float wichtung) {
            this.wichtung = wichtung;
        }

        int maxgleich() {
            int max = 5;
            while (max >= 2 && !Analyse.this.gleich[max - 2]) {
                --max;
            }
            return max;
        }

        float mittel() {
            return this.mittel;
        }

        abstract float prognose(Spieler var1, Zuwachs var2);

        abstract int punkte();

        void tippe(Spieler spieler, Zuwachs zuwachs) {
            this.endsumme = this.endsumme(spieler, zuwachs);
            if (spieler.rest() > 0) {
                this.waehle(spieler);
                this.endsumme += this.prognose(spieler, zuwachs);
            } else {
                Arrays.fill(this.erneut, true);
                this.endsumme += (float)this.punkte();
            }
        }

        abstract void waehle(Spieler var1);

        int wert() {
            return this.wert;
        }

        float wichtung() {
            return this.wichtung;
        }
    }

    class FullHouse
    extends Unten {
        private static final long serialVersionUID = -1069152277729232203L;
        static final int PUNKTE = 25;
        private int fehlend;

        FullHouse() {
            this.mittel = this.prognose(5, 3);
        }

        private float prognose(int k, int r) {
            return 25.0f * this.restwahrscheinlichkeit(k, r);
        }

        private float restwahrscheinlichkeit(int k) {
            return RESTWAHRSCHEINLICHKEIT[k];
        }

        private float restwahrscheinlichkeit(int k, int r) {
            switch (k) {
                case 0: {
                    return 1.0f;
                }
                case 1: {
                    return 1.0f - (float)Math.pow(0.6666666865348816, r);
                }
                case 2: {
                    return 1.0f - (float)Math.pow(0.8333333134651184, r);
                }
                case 3: {
                    switch (r) {
                        case 1: {
                            return 0.097222224f;
                        }
                        case 2: {
                            return 0.27469134f;
                        }
                    }
                    return 0.0f;
                }
                case 5: {
                    if (r == 0) {
                        return 0.0f;
                    }
                    float restwahrscheinlichkeit = 0.0f;
                    int i = 0;
                    while (i <= 5) {
                        restwahrscheinlichkeit += this.restwahrscheinlichkeit(i) * this.restwahrscheinlichkeit(i, r - 1);
                        ++i;
                    }
                    return restwahrscheinlichkeit;
                }
            }
            return 0.0f;
        }

        @Override
        float prognose(Spieler spieler, Zuwachs zuwachs) {
            return this.prognose(this.fehlend, spieler.rest());
        }

        @Override
        int punkte() {
            if (Analyse.this.gleich[0] && Analyse.this.gleich[1] || Analyse.this.gleich[3]) {
                return 25;
            }
            return 0;
        }

        @Override
        void waehle(Spieler spieler) {
            if (Analyse.this.gleich[0] && Analyse.this.gleich[1] || Analyse.this.gleich[3]) {
                Arrays.fill(this.erneut, false);
                this.fehlend = 0;
            } else if (Analyse.this.gleich[1] || Analyse.this.gleich[2]) {
                int zaehler = 0;
                int w = 0;
                while (w < 5) {
                    boolean bl = this.erneut[w] = Analyse.this.anzahl[Analyse.this.wuerfel[w].augen() - 1] <= 2 || zaehler == 3;
                    if (Analyse.this.anzahl[Analyse.this.wuerfel[w].augen() - 1] > 2) {
                        ++zaehler;
                    }
                    ++w;
                }
                this.fehlend = 2;
            } else if (Analyse.this.gleich[0]) {
                this.fehlend = 0;
                int ind = 0;
                while (ind < 6) {
                    if (Analyse.this.anzahl[ind] == 2) {
                        this.fehlend = this.fehlend == 0 ? 3 : 1;
                    }
                    ++ind;
                }
                int w = 0;
                while (w < 5) {
                    this.erneut[w] = Analyse.this.anzahl[Analyse.this.wuerfel[w].augen() - 1] == 1;
                    ++w;
                }
            } else {
                Arrays.fill(this.erneut, true);
                this.fehlend = 5;
            }
        }
    }

    class GrosseStrasse
    extends Unten {
        private static final long serialVersionUID = 8292592862416663732L;
        static final int PUNKTE = 40;
        private final int[] kandidat;
        private int fehlend;

        GrosseStrasse() {
            this.kandidat = new int[6];
            this.mittel = 40.0f * this.q(5, 3);
        }

        private float p(int n, int r) {
            if (r > 1) {
                float summe = 0.0f;
                int i = 0;
                while (i <= n) {
                    summe += this.u(n, i) * this.p(n - i, r - 1);
                    ++i;
                }
                return summe;
            }
            return (float)Kombinatorik.fakultaet(n) / (float)Math.pow(6.0, n);
        }

        private float q(int n, int r) {
            if (r > 1) {
                float summe = 0.0f;
                int i = 0;
                while (i <= n) {
                    summe += this.w(n, i) * this.p(n - i, r - 1) + this.v(n, i) * this.q(n - i, r - 1);
                    ++i;
                }
                return summe;
            }
            if (n > 0) {
                return (float)(2 * Kombinatorik.fakultaet(n)) / (float)Math.pow(6.0, n);
            }
            return 0.0f;
        }

        private float u(int n, int i) {
            return Kombinatorik.strassenteilsequenz(n, 6 - n, i, n) / (float)Math.pow(6.0, n);
        }

        private float v(int n, int i) {
            return Kombinatorik.strassenteilsequenz(n, 5 - n, i, n - 1) / (float)Math.pow(6.0, n);
        }

        private float w(int n, int i) {
            return (float)(i * Kombinatorik.fallend(n - 1, i - 1) * (2 * Kombinatorik.strassenteilschablone(n, 5 - n, i) + (i + 1) * Kombinatorik.strassenteilschablone(n, 5 - n, i + 1))) / (float)Math.pow(6.0, n);
        }

        @Override
        float prognose(Spieler spieler, Zuwachs zuwachs) {
            if (Analyse.this.anzahl[0] > 0 || Analyse.this.anzahl[5] > 0) {
                return 40.0f * this.p(this.fehlend, spieler.rest());
            }
            return 40.0f * this.q(this.fehlend, spieler.rest());
        }

        @Override
        int punkte() {
            if (Analyse.this.anzahl[1] == 1 && Analyse.this.anzahl[2] == 1 && Analyse.this.anzahl[3] == 1 && Analyse.this.anzahl[4] == 1 && (Analyse.this.anzahl[0] == 1 || Analyse.this.anzahl[5] == 1)) {
                return 40;
            }
            return 0;
        }

        @Override
        void waehle(Spieler spieler) {
            System.arraycopy(Analyse.this.anzahl, 0, this.kandidat, 0, 6);
            if (this.kandidat[0] > 0 && this.kandidat[5] > 0) {
                if (ZUFALL.nextBoolean()) {
                    this.kandidat[0] = 0;
                } else {
                    this.kandidat[5] = 0;
                }
            }
            this.fehlend = 0;
            int w = 0;
            while (w < 5) {
                int i = Analyse.this.wuerfel[w].augen() - 1;
                boolean bl = this.erneut[w] = this.kandidat[i] == 0;
                if (this.erneut[w]) {
                    ++this.fehlend;
                } else {
                    this.kandidat[i] = 0;
                }
                ++w;
            }
        }
    }

    class JaFuffy
    extends Unten {
        private static final long serialVersionUID = -6921954073317063844L;
        static final int PUNKTE = 50;

        JaFuffy() {
            this.mittel = this.prognose(3, 0);
        }

        private float prognose(int r, int max) {
            float p;
            if (max <= 1) {
                p = 0.0f;
                int j = 0;
                while (j < r) {
                    int i = 2;
                    while (i <= 5) {
                        p = (float)((double)p + Math.pow(Kombinatorik.gleichenwahrscheinlichkeit(1), r - 1 - j) * (double)Kombinatorik.gleichenwahrscheinlichkeit(i) * (double)Kombinatorik.gleichenwahrscheinlichkeit(5 - i, j));
                        ++i;
                    }
                    ++j;
                }
            } else {
                p = Kombinatorik.gleichenwahrscheinlichkeit(5 - max, r);
            }
            return p * 50.0f;
        }

        @Override
        float prognose(Spieler spieler, Zuwachs zuwachs) {
            return this.prognose(spieler.rest(), this.maxgleich());
        }

        @Override
        int punkte() {
            return Analyse.this.gleich[3] ? 50 : 0;
        }

        @Override
        void waehle(Spieler spieler) {
            int max = this.maxgleich();
            ArrayList<Integer> augenauswahl = new ArrayList<Integer>();
            int ind = 0;
            while (ind < 6) {
                if (Analyse.this.anzahl[ind] == max) {
                    augenauswahl.add(new Integer(ind + 1));
                }
                ++ind;
            }
            int augen = (Integer)augenauswahl.get(ZUFALL.nextInt(augenauswahl.size()));
            int w = 0;
            while (w < 5) {
                this.erneut[w] = max == 1 || augen != Analyse.this.wuerfel[w].augen();
                ++w;
            }
        }
    }

    class KleineStrasse
    extends Unten {
        private static final long serialVersionUID = 3736058022544823661L;
        private static final float P_TOT = 0.6025279f;
        static final int PUNKTE = 30;
        private int aussen;
        private int innen;
        private int mitte;

        KleineStrasse() {
            this.mittel = 18.075838f;
        }

        private void behalte(Strassenpaar paar) {
            int[] nArray = paar.feld();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int augen = nArray[n2];
                if (Analyse.this.anzahl[augen] > 0) {
                    int w = 0;
                    while (w < 5) {
                        if (Analyse.this.wuerfel[w].augen() == augen + 1) {
                            this.erneut[w] = false;
                            break;
                        }
                        ++w;
                    }
                }
                ++n2;
            }
        }

        @Override
        float prognose(Spieler spieler, Zuwachs zuwachs) {
            if (this.aussen + this.innen + this.mitte < 4) {
                return KleineStrasseIndex.TABELLE.get(new KleineStrasseIndex(this.aussen, this.innen, this.mitte, spieler.rest())).floatValue() * 30.0f;
            }
            return 30.0f;
        }

        @Override
        int punkte() {
            if (Analyse.this.anzahl[2] > 0 && Analyse.this.anzahl[3] > 0 && (Analyse.this.anzahl[0] > 0 && Analyse.this.anzahl[1] > 0 || Analyse.this.anzahl[1] > 0 && Analyse.this.anzahl[4] > 0 || Analyse.this.anzahl[4] > 0 && Analyse.this.anzahl[5] > 0)) {
                return 30;
            }
            return 0;
        }

        @Override
        void waehle(Spieler spieler) {
            Arrays.fill(this.erneut, true);
            this.aussen = 0;
            this.innen = Strassenpaar.INNEN.vorkommen(Analyse.this.anzahl);
            this.mitte = Strassenpaar.MITTE.vorkommen(Analyse.this.anzahl);
            int links = Strassenpaar.LINKS.vorkommen(Analyse.this.anzahl);
            int rechts = Strassenpaar.RECHTS.vorkommen(Analyse.this.anzahl);
            if (this.innen == 2) {
                this.behalte(Strassenpaar.INNEN);
            } else if (this.innen == 1 && links <= 1 && rechts <= 1) {
                this.behalte(Strassenpaar.INNEN);
            } else if (links > rechts) {
                this.aussen = links - this.innen;
                this.behalte(Strassenpaar.LINKS);
            } else if (links < rechts) {
                this.aussen = rechts - this.innen;
                this.behalte(Strassenpaar.RECHTS);
            } else {
                this.aussen = links - this.innen;
                this.behalte(ZUFALL.nextBoolean() ? Strassenpaar.LINKS : Strassenpaar.RECHTS);
            }
            this.behalte(Strassenpaar.MITTE);
        }
    }

    static class KleineStrasseIndex
    implements Serializable {
        private static final long serialVersionUID = -6498075827504305923L;
        static final Map<KleineStrasseIndex, Float> TABELLE = new HashMap<KleineStrasseIndex, Float>();
        private final int aussen;
        private final int innen;
        private final int mitte;
        private final int rest;

        static {
            KleineStrasseIndex.tabelliere(0, 0, 1, 1, 0.212963f);
            KleineStrasseIndex.tabelliere(0, 0, 1, 2, 0.489169f);
            KleineStrasseIndex.tabelliere(0, 0, 2, 1, 0.3611111f);
            KleineStrasseIndex.tabelliere(0, 0, 2, 2, 0.6584362f);
            KleineStrasseIndex.tabelliere(0, 1, 0, 1, 0.1481481f);
            KleineStrasseIndex.tabelliere(0, 1, 0, 2, 0.3912751f);
            KleineStrasseIndex.tabelliere(0, 1, 1, 1, 0.25f);
            KleineStrasseIndex.tabelliere(0, 1, 1, 2, 0.5150463f);
            KleineStrasseIndex.tabelliere(0, 1, 2, 1, 0.5555556f);
            KleineStrasseIndex.tabelliere(0, 1, 2, 2, 0.8024691f);
            KleineStrasseIndex.tabelliere(0, 2, 0, 1, 0.1388889f);
            KleineStrasseIndex.tabelliere(0, 2, 0, 2, 0.3526235f);
            KleineStrasseIndex.tabelliere(0, 2, 1, 1, 0.3055556f);
            KleineStrasseIndex.tabelliere(0, 2, 1, 2, 0.5177469f);
            KleineStrasseIndex.tabelliere(1, 0, 0, 1, 0.1018519f);
            KleineStrasseIndex.tabelliere(1, 0, 0, 2, 0.3410851f);
            KleineStrasseIndex.tabelliere(1, 0, 1, 1, 0.1666667f);
            KleineStrasseIndex.tabelliere(1, 0, 1, 2, 0.4293981f);
            KleineStrasseIndex.tabelliere(1, 0, 2, 1, 0.3611111f);
            KleineStrasseIndex.tabelliere(1, 0, 2, 2, 0.6296296f);
            KleineStrasseIndex.tabelliere(1, 1, 0, 1, 0.1388889f);
            KleineStrasseIndex.tabelliere(1, 1, 0, 2, 0.3526235f);
            KleineStrasseIndex.tabelliere(1, 1, 1, 1, 0.3055556f);
            KleineStrasseIndex.tabelliere(1, 1, 1, 2, 0.5177469f);
        }

        private static void tabelliere(int aussen, int innen, int mitte, int rest, float p) {
            TABELLE.put(new KleineStrasseIndex(aussen, innen, mitte, rest), Float.valueOf(p));
        }

        KleineStrasseIndex(int aussen, int innen, int mitte, int rest) {
            this.aussen = aussen;
            this.innen = innen;
            this.mitte = mitte;
            this.rest = rest;
        }

        public boolean equals(Object obj) {
            KleineStrasseIndex index = (KleineStrasseIndex)obj;
            return this.aussen == index.aussen && this.innen == index.innen && this.mitte == index.mitte && this.rest == index.rest;
        }

        public int hashCode() {
            return 3 * (3 * (3 * this.aussen + this.innen) + this.mitte) + this.rest;
        }
    }

    class Oben
    extends Eintrag {
        private static final long serialVersionUID = -5829769579272736329L;
        private final int ind;
        private final int augen;

        Oben(int ind) {
            this.ind = ind;
            this.augen = ind + 1;
            this.mittel = (float)this.augen * Kombinatorik.gleichenmittel(5, 3);
        }

        @Override
        float endsumme(Spieler spieler, Zuwachs zuwachs) {
            return (float)spieler.endsumme() + zuwachs.zuwachs(spieler.gesamt(), Analyse.this.anzahl[this.ind], spieler.rest(), this.augen) - this.mittel;
        }

        @Override
        float prognose(Spieler spieler, Zuwachs zuwachs) {
            float min;
            int n = 5 - Analyse.this.anzahl[this.ind];
            float punkte = min = (float)(this.augen * Analyse.this.anzahl[this.ind]);
            int k = 1;
            while (k <= n) {
                float p = Kombinatorik.gleichenwahrscheinlichkeit(n, k, spieler.rest());
                float neu = k * this.augen;
                punkte += p * neu;
                ++k;
            }
            return punkte;
        }

        @Override
        int punkte() {
            return Analyse.this.anzahl[this.ind] * this.augen;
        }

        @Override
        void waehle(Spieler spieler) {
            int w = 0;
            while (w < 5) {
                this.erneut[w] = Analyse.this.wuerfel[w].augen() != this.augen;
                ++w;
            }
        }
    }

    class Pasch
    extends Unten {
        private static final long serialVersionUID = 8666151619656864766L;
        private static final int KLEIN = 3;
        private static final int GROSS = 4;
        private final int pasch;
        private int versuch;

        Pasch(int pasch) {
            this.pasch = pasch;
            this.mittel = 0.0f;
            int augen = 1;
            while (augen <= 6) {
                int max = 1;
                while (max <= 5) {
                    this.mittel += this.prognose(max, 2, augen) * this.q(max, augen);
                    ++max;
                }
                ++augen;
            }
        }

        private float augenzahl(int m, int j, int augen) {
            float grenze = Kombinatorik.augenzahl(j);
            int n = (int)grenze;
            float punkte = (float)(this.pasch * augen) + (float)(m - this.pasch) * Math.max((float)augen, grenze);
            float s = (float)((n + 7) * (6 - n)) / 2.0f;
            if ((float)augen <= grenze) {
                float alpha = (float)(n - 1) / 5.0f;
                punkte += (float)(5 - m) * (alpha * grenze + (1.0f - alpha) * s / (float)(6 - n));
            } else {
                float alpha = (float)n / 5.0f;
                punkte += (float)(5 - m) * (alpha * grenze + (1.0f - alpha) * (s - (float)augen) / (float)(5 - n));
            }
            return punkte;
        }

        private boolean pasch() {
            return this.pasch == 3 && Analyse.this.gleich[1] || Analyse.this.gleich[2] || Analyse.this.gleich[3];
        }

        private float prognose(int max, int r, int augen) {
            float punkte = 0.0f;
            if (max < this.pasch) {
                int n = 5 - max;
                int k = this.pasch - max;
                while (k <= n) {
                    int j = 1;
                    while (j <= r) {
                        float gw0 = Kombinatorik.gleichenwahrscheinlichkeit(n, k, j);
                        float gw1 = Kombinatorik.gleichenwahrscheinlichkeit(n, k, j - 1);
                        punkte += (gw0 - gw1) * this.augenzahl(max + k, j - 1, augen);
                        ++j;
                    }
                    ++k;
                }
            } else if (Analyse.this.wuerfel != null) {
                int w = 0;
                while (w < 5) {
                    punkte = this.erneut[w] ? (punkte += Kombinatorik.augenzahl(r)) : (punkte += (float)Analyse.this.wuerfel[w].augen());
                    ++w;
                }
            } else {
                punkte = this.augenzahl(max, 2, augen);
            }
            return punkte;
        }

        private float q(int max, int augen) {
            if (max >= 3) {
                return Kombinatorik.gleichenwahrscheinlichkeit(max) / 6.0f;
            }
            if (max == 2) {
                return ((float)(augen - 1) * 120.0f + 600.0f) / 7776.0f;
            }
            if (augen <= 4) {
                return 0.0f;
            }
            if (augen == 5) {
                return 0.015432099f;
            }
            return 0.07716049f;
        }

        @Override
        float prognose(Spieler spieler, Zuwachs zuwachs) {
            return this.prognose(this.maxgleich(), spieler.rest(), this.versuch);
        }

        @Override
        int punkte() {
            return this.pasch() ? Analyse.this.augensumme : 0;
        }

        @Override
        void waehle(Spieler spieler) {
            this.versuch = 6;
            while (Analyse.this.anzahl[this.versuch - 1] < this.maxgleich()) {
                --this.versuch;
            }
            int zaehler = 0;
            int w = 0;
            while (w < 5) {
                boolean kandidat = Analyse.this.wuerfel[w].augen() == this.versuch ? ++zaehler > this.pasch && Kombinatorik.augenzahl(spieler.rest()) > (float)Analyse.this.wuerfel[w].augen() : !this.pasch() || Kombinatorik.augenzahl(spieler.rest()) > (float)Analyse.this.wuerfel[w].augen();
                this.erneut[w] = kandidat;
                ++w;
            }
        }
    }

    static enum Strassenpaar {
        LINKS(0, 1),
        INNEN(1, 4),
        RECHTS(4, 5),
        MITTE(2, 3);

        private final int[] feld = new int[2];

        private Strassenpaar(int paar0, int paar1) {
            this.feld[0] = paar0;
            this.feld[1] = paar1;
        }

        final int[] feld() {
            return this.feld;
        }

        int vorkommen(int[] anzahl) {
            int gefunden = 0;
            int[] nArray = this.feld;
            int n = this.feld.length;
            int n2 = 0;
            while (n2 < n) {
                int augen = nArray[n2];
                if (anzahl[augen] > 0) {
                    ++gefunden;
                }
                ++n2;
            }
            return gefunden;
        }
    }

    abstract class Unten
    extends Eintrag {
        private static final long serialVersionUID = 8894740065051562154L;

        Unten() {
        }

        @Override
        float endsumme(Spieler spieler, Zuwachs zuwachs) {
            return (float)spieler.endsumme() + zuwachs.zuwachs() - this.mittel;
        }
    }

    class Zuwachs {
        private final int teilung;
        private final float p;
        private final float mittlererBonusZuwachs;
        private final float mittlererZuwachs;

        Zuwachs(int gesamt, float mittlererObererZuwachs, int augensummeObereFreieEintraege, int anzahlFreieObereEintraege, float mittlererUntererZuwachs) {
            if (gesamt < 63 && augensummeObereFreieEintraege > 0) {
                this.teilung = (63 - gesamt + augensummeObereFreieEintraege - 1) / augensummeObereFreieEintraege;
                float q = Kombinatorik.mindestgleichenwahrscheinlichkeit(this.teilung);
                this.mittlererBonusZuwachs = (float)Math.pow(q, anzahlFreieObereEintraege) * 35.0f;
                this.p = q != 0.0f ? q : 1.0f;
            } else {
                this.teilung = 0;
                this.p = 1.0f;
                this.mittlererBonusZuwachs = 0.0f;
            }
            this.mittlererZuwachs = mittlererObererZuwachs + mittlererUntererZuwachs;
        }

        float zuwachs() {
            return this.mittlererZuwachs + this.mittlererBonusZuwachs;
        }

        float zuwachs(int gesamt, int guenstige, int r, int augen) {
            float q = 0.0f;
            int punkteBisZumBonus = 63 - gesamt;
            if (punkteBisZumBonus > 0) {
                q = 1.0f;
                if ((punkteBisZumBonus -= guenstige * augen) > 0) {
                    int n = 5 - guenstige;
                    int min = guenstige <= this.teilung ? this.teilung - guenstige : 0;
                    q = Kombinatorik.mindestgleichenwahrscheinlichkeit(n, min, r);
                }
            }
            return this.mittlererZuwachs + q / this.p * this.mittlererBonusZuwachs;
        }
    }
}

