/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Becher;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Intro;
import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Wuerfelfeld;
import jafuffy.bedienung.Zettel;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Spielplatz
extends JPanel
implements PropertyChangeListener,
ChangeListener {
    private static final String KLICKEN = "<html><p>Klicken um Turnier zu beginnen, oder<br>Men\u00fc \"Turnier\" -> \"Beginnen...\"</p></html>";
    static final String INTRO = "Intro";
    static final String TEXT = "Text";
    static final String FELD = "Feld";
    private static final int KOMPONENTENRAND = 2;
    private static final ImageIcon KRANZ = Grafik.icon("Kranz.png");
    private static final Font TITEL = new Font("SansSerif", 3, 32);
    private static final Font UNTERTITEL = new Font("SansSerif", 1, 24);
    private final Zettel zettel = new Zettel();
    private final Wuerfelfeld wuerfelfeld;

    public Spielplatz(Becher becher, Verfolgung verfolgung) {
        super(new CardLayout());
        this.wuerfelfeld = new Wuerfelfeld(becher, verfolgung);
        UIManager.addPropertyChangeListener(this);
        JPanel zettelfeld = new JPanel(new BorderLayout());
        zettelfeld.add((Component)this.zettel, "Center");
        MouseAdapter klick = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Spielplatz.this.firePropertyChange("Beginnen", null, Spielplatz.this.getRootPane());
            }
        };
        this.add((Component)this.spielfeld(zettelfeld), FELD);
        Intro intro = new Intro();
        intro.addMouseListener(klick);
        intro.setToolTipText(KLICKEN);
        this.add((Component)intro, INTRO);
        JPanel titelfeld = this.titelfeld();
        titelfeld.addMouseListener(klick);
        titelfeld.setToolTipText(KLICKEN);
        this.add((Component)titelfeld, TEXT);
        this.zeige(Eigenschaften.GLOBAL.aktiv(INTRO));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        } else if (event.getPropertyName().equals("Karte")) {
            this.zeige(event.getNewValue().equals(INTRO));
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.wuerfelfeld.stateChanged(ce);
        this.zettel.stateChanged(ce);
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: {
                    ((CardLayout)this.getLayout()).show(this, FELD);
                    break;
                }
                case RESULTAT: {
                    this.zeigeTurnierausgang((Turnier)ce.getSource());
                }
            }
        }
    }

    private JPanel spielfeld(JPanel zettelfeld) {
        JPanel spielfeld = new JPanel();
        spielfeld.setLayout(new BoxLayout(spielfeld, 0));
        zettelfeld.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        spielfeld.add(zettelfeld);
        this.wuerfelfeld.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        spielfeld.add(this.wuerfelfeld);
        return spielfeld;
    }

    private JPanel titelfeld() {
        JPanel titelfeld = new JPanel();
        titelfeld.setLayout(new BoxLayout(titelfeld, 3));
        JLabel titel = new JLabel("JaFuffy!", 0);
        titel.setEnabled(false);
        titel.setFont(TITEL);
        titel.setAlignmentX(0.5f);
        titelfeld.add((Component)titel, "Center");
        JLabel untertitel = new JLabel("- Das W\u00fcrfelspiel -", 0);
        untertitel.setEnabled(false);
        untertitel.setFont(UNTERTITEL);
        untertitel.setAlignmentX(0.5f);
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(titel);
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(untertitel);
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(Box.createVerticalGlue());
        return titelfeld;
    }

    private void zeige(boolean intro) {
        ((CardLayout)this.getLayout()).show(this, intro ? INTRO : TEXT);
    }

    private void zeigeTurnierausgang(Turnier turnier) {
        JPanel rangliste = new JPanel();
        ArrayList<Spieler> spieler = turnier.spieler();
        if (spieler.size() == 1) {
            rangliste.setLayout(new GridLayout(1, 2));
            rangliste.add(new JLabel(spieler.get(0).toString(), 0));
            rangliste.add(new JLabel(String.valueOf(spieler.get(0).endsumme()) + " Punkte", 0));
        } else {
            Object[] plaetze = spieler.toArray();
            Arrays.sort(plaetze);
            int lowscore = ((Spieler)plaetze[spieler.size() - 1]).endsumme();
            rangliste.setLayout(new GridLayout(0, 3));
            int i = spieler.size() - 1;
            int rang = 1;
            while (i >= 0) {
                int score = ((Spieler)plaetze[i]).endsumme();
                if (score < lowscore) {
                    ++rang;
                    lowscore = score;
                }
                rangliste.add(new JLabel(String.valueOf(rang) + ". Platz: "));
                rangliste.add(new JLabel(((Spieler)plaetze[i]).toString()));
                rangliste.add(new JLabel(String.valueOf(score) + " Punkte", 4));
                --i;
            }
        }
        JOptionPane.showMessageDialog(this, rangliste, turnier.nummer() < turnier.anzahl() || turnier.anzahl() == 0 ? "JaFuffy (Resultat " + turnier.nummer() + ". Spiel)" : "JaFuffy (Resultat letztes Spiel)", 1, KRANZ);
    }
}

