/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.Ressource;
import jafuffy.bedienung.Bestenliste;
import jafuffy.bedienung.Fortsetzung;
import jafuffy.bedienung.Hilfe;
import jafuffy.bedienung.Info;
import jafuffy.bedienung.Lizenzierung;
import jafuffy.bedienung.Pfad;
import jafuffy.bedienung.Report;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Signal;
import jafuffy.bedienung.Vorschlagen;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Turnier;
import jafuffy.logik.Update;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Menue
extends JMenuBar
implements PropertyChangeListener,
ChangeListener {
    private static final String APPLET = "<html><p>Steht nicht zur Verf\u00fcgung</p><p>(<i>JaFuffy</i> wurde als Applet gestartet)</p></html>";
    private final Report report;
    private final Bestenliste bestenliste;
    private final Fortsetzung fortsetzung;
    private final Update update;
    private final Info info = new Info();
    private final Lizenzierung lizenzierung = new Lizenzierung();
    private final JMenuItem speichern = new JMenuItem("Speichern");
    private final JMenuItem speichernUnter = new JMenuItem("Speichern unter...");
    private final JMenuItem berichten = new JMenuItem("Report");
    private final JMenuItem rueckgaengig = new JMenuItem("R\u00fcckg\u00e4ngig");
    private final JMenuItem beenden = new JMenuItem("Beenden");
    private final Vorschlagen vorschlagen;
    private final Setzen setzen;
    private boolean betrieb = false;

    public Menue(Vorschlagen vorschlagen, Setzen setzen, Report report, Bestenliste bestenliste, Fortsetzung fortsetzung, Update update) {
        this.vorschlagen = vorschlagen;
        this.setzen = setzen;
        this.report = report;
        this.bestenliste = bestenliste;
        this.fortsetzung = fortsetzung;
        this.update = update;
        UIManager.addPropertyChangeListener(this);
        this.erzeugeTurniermenue();
        this.erzeugeStatistikmenue();
        this.erzeugeExtrasmenue();
        this.erzeugeEinstellungenmenue();
        this.erzeugeHilfemenue();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        } else if (event.getPropertyName().equals("Speichern")) {
            this.speichern.setEnabled((Boolean)event.getNewValue());
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            Turnier turnier = (Turnier)cej.quelle(Turnier.class);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: {
                    this.meldeTurnierAn(turnier);
                    break;
                }
                case RESULTAT: {
                    this.vorschlagen.setEnabled(false);
                    this.setzen.setEnabled(false);
                    this.rueckgaengig.setEnabled(false);
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.meldeTurnierAb(turnier);
                    break;
                }
                case GEWUERFELT: 
                case RUECKGAENGIG: {
                    this.vorschlagen.setEnabled(true);
                    this.setzen.setEnabled(false);
                    this.rueckgaengig.setEnabled(false);
                    break;
                }
                case GESETZT: {
                    this.vorschlagen.setEnabled(false);
                    this.setzen.setEnabled(false);
                    this.rueckgaengig.setEnabled(true);
                    break;
                }
            }
        }
    }

    private boolean applikation() {
        return this.fortsetzung != null;
    }

    private void erzeugeEinstellungenmenue() {
        JMenu menu = new JMenu("Einstellungen");
        menu.setMnemonic('E');
        this.add(menu);
        JMenuItem menuItem = menu.add(new JCheckBoxMenuItem("Setzen durch Einfachklick"));
        menuItem.setToolTipText("<html>Wahl zwischen einmaligem und zweimaligem Klicken<br>zum Setzen des Wurfs in der Tabelle</html>");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Einfachklick"));
        menuItem.addActionListener(new Wechsel("Einfachklick"));
        JMenu subMenu = new JMenu("Botverhalten");
        menu.add(subMenu);
        menuItem = subMenu.add(new JCheckBoxMenuItem("\u00dcberlegungen nur andeuten"));
        menuItem.setToolTipText("<html>Falls ausgew\u00e4hlt werden die \u00dcberlegungen des Bots zur W\u00fcrfelauswahl nur kurz dargestellt,<br> m\u00fcssen aber nicht best\u00e4tigt werden.</html>");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Ueberlegungsdarstellungsbeschleunigung"));
        menuItem.addActionListener(new Wechsel("Ueberlegungsdarstellungsbeschleunigung"));
        menuItem = subMenu.add(new JCheckBoxMenuItem("Beschleunigung der Aktionskontrolle"));
        menuItem.setToolTipText("Falls ausgew\u00e4hlt werden Aktionen des Bots k\u00fcrzer dargestellt.");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Aktionsdarstellungsbeschleunigung"));
        menuItem.addActionListener(new Wechsel("Aktionsdarstellungsbeschleunigung"));
        menu.addSeparator();
        menuItem = menu.add(new JCheckBoxMenuItem("Zwischenstandsanzeige"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, 0));
        menuItem.setToolTipText("<html>Die Punktezahl des derzeitigen Wurfs<br>f\u00fcr jeden freien Tabellenplatz anzeigen?</html>");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Zwischenstand"));
        menuItem.addActionListener(new Wechsel("Zwischenstand"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getRootPane(Menue.this).repaint();
            }
        });
        subMenu = new JMenu("Meldungen");
        subMenu.setToolTipText("Meldungen ein/ausschalten bei...");
        menu.add(subMenu);
        menuItem = subMenu.add(new JCheckBoxMenuItem("Hinweise"));
        menuItem.setToolTipText("Allgemeine Hinweise (\"ToolTips\" in K\u00e4sten) anzeigen?");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Hinweis"));
        ToolTipManager.sharedInstance().setEnabled(Eigenschaften.GLOBAL.aktiv("Hinweis"));
        menuItem.addActionListener(new Wechsel(this, "Hinweis"){

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ToolTipManager.sharedInstance().setEnabled(this.aktiv());
            }
        });
        menuItem = subMenu.add(new JCheckBoxMenuItem("Spicker"));
        menuItem.setToolTipText("Spicker f\u00fcr W\u00fcrfelpunkte in Tabelle?");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Spicker"));
        menuItem.addActionListener(new Wechsel("Spicker"));
        menuItem = subMenu.add(new JCheckBoxMenuItem("Erinnerung abgebrochenes Turnier"));
        if (this.applikation()) {
            menuItem.setToolTipText("Erinnerung an abgebrochenes Turnier zum Weiterspielen?");
            menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Erinnerung"));
            menuItem.addActionListener(new Wechsel("Erinnerung"));
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
        subMenu = new JMenu("Effekte");
        subMenu.setToolTipText("Grafik- und Toneffekte");
        menu.add(subMenu);
        menuItem = subMenu.add(new JCheckBoxMenuItem("Eingangsgrafik"));
        menuItem.setToolTipText("Eingangsgrafik ein/ausschalten");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Intro"));
        menuItem.addActionListener(new Wechsel(this, "Intro"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!betrieb) {
                    super.actionPerformed(e);
                    if (this.aktiv()) {
                        this.firePropertyChange("Karte", "Text", "Intro");
                    } else {
                        this.firePropertyChange("Karte", "Intro", "Text");
                    }
                }
            }
        });
        menuItem = subMenu.add(new JCheckBoxMenuItem("Ger\u00e4usche"));
        menuItem.setEnabled(Ressource.soundsystem());
        menuItem.setToolTipText("Ger\u00e4usche ein/ausschalten");
        menuItem.setSelected(Ressource.soundsystem() && Eigenschaften.GLOBAL.aktiv("Geraeusche"));
        menuItem.addActionListener(new Wechsel("Geraeusche"));
        subMenu = new JMenu("Look and Feel");
        subMenu.setToolTipText("<html><p>Look & Feel der Benutzeroberfl\u00e4che.</p><p>Je nach Auswahl kann ein Neustart erforderlich sein, siehe Extras-Men\u00fc.</p></html>");
        menu.add(subMenu);
        ButtonGroup oberflaechengruppe = new ButtonGroup();
        for (final UIManager.LookAndFeelInfo laf : this.lafs()) {
            menuItem = new JRadioButtonMenuItem(laf.getName());
            String alt = Eigenschaften.GLOBAL.getProperty("LookAndFeel");
            menuItem.setSelected(alt.equals(laf.getClassName()));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String alt = Eigenschaften.GLOBAL.getProperty("LookAndFeel");
                    String neu = laf.getClassName();
                    Menue.this.firePropertyChange("LookAndFeel", alt, neu);
                }
            });
            subMenu.add(menuItem);
            oberflaechengruppe.add(menuItem);
        }
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Pfad..."));
        if (this.applikation()) {
            menuItem.setToolTipText("<html><p>Pfad zu Statistikdaten und Turnierst\u00e4nden einstellen.</p><p>Aktuelle Einstellung: <strong>" + Eigenschaften.GLOBAL.pfad() + "</strong></p>" + "</html>");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Pfad(Eigenschaften.GLOBAL, SwingUtilities.getRootPane(Menue.this));
                }
            });
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
        menu.addSeparator();
        menuItem = menu.add(new JCheckBoxMenuItem("Nach neuerer Version schauen"));
        menuItem.setToolTipText("<html>Bei jedem Programmstart automatisch nach neuerer Version auf <i>JaFuffy</i>-Homepage suchen<html>");
        if (this.applikation()) {
            menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Nachschauen"));
            menuItem.addActionListener(new Wechsel("Nachschauen"));
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
    }

    private void erzeugeExtrasmenue() {
        JMenu menu = new JMenu("Extras");
        menu.setMnemonic('X');
        this.add(menu);
        menu.add(this.rueckgaengig);
        this.rueckgaengig.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        this.rueckgaengig.setActionCommand("Rueckgaengig");
        this.rueckgaengig.setEnabled(false);
        this.rueckgaengig.setToolTipText("Letztes Setzen r\u00fcckg\u00e4ngig machen");
        menu.add(this.setzen);
        menu.addSeparator();
        JMenuItem menuItem = menu.add(new JMenuItem("Fenster anpassen"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        if (this.applikation()) {
            menuItem.setToolTipText("Fenstergr\u00f6\u00dfe optimal anpassen an Tabelle, W\u00fcrfelfeld und Look & Feel");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Window umgebung = SwingUtilities.getWindowAncestor(Menue.this);
                            umgebung.pack();
                        }
                    });
                }
            });
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Neu zeichnen"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 0));
        menuItem.setToolTipText("Alles neu zeichnen zur Beseitigung von Darstellungsfehlern");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getRootPane(Menue.this).repaint();
            }
        });
        menuItem = menu.add(new JMenuItem("Neustart"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Eigenschaften.GLOBAL.merkeNeustartAnforderung(Menue.this.betrieb);
                Menue.this.beenden.doClick();
            }
        });
        if (this.applikation()) {
            menuItem.setToolTipText("<html><p>Neustart durchf\u00fchren mit automatischer Turnierfortsetzung.</p><p>Hilfreich weil Look & Feel-Wechsel nicht immer funktionieren.</p></html>");
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
    }

    private void erzeugeHilfemenue() {
        JMenu menu = new JMenu("Hilfe");
        menu.setMnemonic('H');
        this.add(menu);
        menu.add(this.vorschlagen);
        this.vorschlagen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.setzen.setEnabled(true);
            }
        });
        menu.addSeparator();
        JMenuItem menuItem = menu.add(new JMenuItem("Hilfethemen"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(72, 0));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Hilfe hilfe = new Hilfe();
                    hilfe.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                    hilfe.setVisible(true);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    Signal.WARNUNG.play();
                    JOptionPane.showMessageDialog(SwingUtilities.getRootPane(Menue.this), "Hilfetexte k\u00f6nnen nicht angezeigt werden!\nFehlerhafte oder fehlende HTML-Dateien?\n", "JaFuffy (Warnung)", 2);
                }
            }
        });
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("<html>\u00dcber <i>JaFuffy</i></html>"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.info.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                Menue.this.info.setVisible(true);
            }
        });
        menuItem = menu.add(new JMenuItem("Lizenzierung"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.lizenzierung.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                Menue.this.lizenzierung.setVisible(true);
            }
        });
        menu.addSeparator();
        menuItem = menu.add(new JMenuItem("Aktualisieren..."));
        if (this.applikation()) {
            menuItem.setToolTipText("<html>Sucht auf der <i>JaFuffy</i>-Homepage nach neuerer Version<html>");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.update.ueberpruefe(SwingUtilities.getRootPane(Menue.this));
                }
            });
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
    }

    private void erzeugeStatistikmenue() {
        JMenu menu = new JMenu("Statistik");
        menu.setMnemonic('S');
        this.add(menu);
        menu.add(this.berichten);
        this.berichten.setToolTipText("(Zischen)Stand & Turnierverlauf");
        this.berichten.setEnabled(false);
        this.berichten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.report.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                Menue.this.report.setVisible(true);
            }
        });
        JMenuItem menuItem = menu.add(new JMenuItem("Bestenliste"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.bestenliste.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                Menue.this.bestenliste.setVisible(true);
            }
        });
    }

    private void erzeugeTurniermenue() {
        JMenu menu = new JMenu("Turnier");
        menu.setMnemonic('T');
        this.add(menu);
        JMenuItem menuItem = menu.add(new JMenuItem("Beginnen..."));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 0));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.firePropertyChange("Beginnen", null, SwingUtilities.getRootPane(Menue.this));
            }
        });
        menu.addSeparator();
        menu.add(this.speichern);
        this.speichern.setEnabled(false);
        this.speichern.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        if (this.applikation()) {
            this.speichern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.fortsetzung.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                    Menue.this.fortsetzung.speichere();
                }
            });
        } else {
            this.speichern.setToolTipText(APPLET);
        }
        menu.add(this.speichernUnter);
        this.speichernUnter.setEnabled(false);
        if (this.applikation()) {
            this.speichernUnter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.fortsetzung.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                    Menue.this.fortsetzung.speichereUnter();
                    Menue.this.fortsetzung.setVisible(true);
                }
            });
        } else {
            this.speichernUnter.setToolTipText(APPLET);
        }
        menuItem = menu.add(new JMenuItem("Fortsetzen..."));
        if (this.applikation()) {
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.fortsetzung.setLocationRelativeTo(SwingUtilities.getRootPane(Menue.this));
                    Menue.this.fortsetzung.setzeFort();
                    Menue.this.fortsetzung.setVisible(true);
                }
            });
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
        menu.addSeparator();
        menu.add(this.beenden);
        if (this.applikation()) {
            this.beenden.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Window umgebung = SwingUtilities.getWindowAncestor(Menue.this);
                    WindowEvent ereignis = new WindowEvent(umgebung, 201);
                    umgebung.dispatchEvent(ereignis);
                }
            });
        } else {
            this.beenden.setEnabled(false);
            this.beenden.setToolTipText(APPLET);
        }
    }

    private List<UIManager.LookAndFeelInfo> lafs() {
        List<UIManager.LookAndFeelInfo> lafs = Arrays.asList(UIManager.getInstalledLookAndFeels());
        Collections.sort(lafs, new Comparator<UIManager.LookAndFeelInfo>(){

            @Override
            public int compare(UIManager.LookAndFeelInfo laf1, UIManager.LookAndFeelInfo laf2) {
                return laf1.getName().compareToIgnoreCase(laf2.getName());
            }
        });
        return lafs;
    }

    private void meldeTurnierAb(Turnier turnier) {
        this.setzen.removeActionListener(turnier);
        this.setzen.setEnabled(false);
        this.vorschlagen.removeActionListener(turnier);
        this.vorschlagen.setEnabled(false);
        this.rueckgaengig.removeActionListener(turnier);
        this.rueckgaengig.setEnabled(false);
    }

    private void meldeTurnierAn(Turnier turnier) {
        this.betrieb = true;
        this.speichern.setEnabled(false);
        this.speichernUnter.setEnabled(this.applikation());
        this.berichten.setEnabled(true);
        this.rueckgaengig.addActionListener(turnier);
        this.rueckgaengig.setEnabled(false);
        this.vorschlagen.addActionListener(turnier);
        this.vorschlagen.setEnabled(turnier.aktiver().gewuerfelt());
        this.setzen.addActionListener(turnier);
        this.setzen.setEnabled(false);
    }

    private class Wechsel
    implements ActionListener {
        private final String schluessel;

        Wechsel(String schluessel) {
            this.schluessel = schluessel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Eigenschaften.GLOBAL.wechsle(this.schluessel);
        }

        boolean aktiv() {
            return Eigenschaften.GLOBAL.aktiv(this.schluessel);
        }
    }
}

