/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Erster;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.logik.Beginner;
import jafuffy.logik.Bot;
import jafuffy.logik.Manager;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.Variante;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Absprache
extends JDialog
implements PropertyChangeListener {
    private static final String[] BOTNAMEN = new String[]{"Annabot", "Bennobot", "Clarabot", "Dragobot"};
    private static final ImageIcon BOT_AKTIV = Grafik.icon("Aktivbot.png");
    private static final ImageIcon BOT_RUHT = Grafik.icon("Ruhebot.png");
    private static final int ANZAHL = 20;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BUTTONABSTAND = 8;
    private static final int DIALOGRAHMENABSTAND = 4;
    private static final int FEINTICKS = 1;
    private static final int ORIENTIERUNGSTICKS = 5;
    private static final int SPALTEN = 8;
    private static final int TICKLABELS = 5;
    private final JButton abbruch = new JButton("Abbruch");
    private final JSlider anzahlschieberegler = new JSlider(0, 20);
    private final JComboBox<Beginner> beginnmodusauswahl = new JComboBox<Beginner>(Beginner.values());
    private final Eigenschaften eigenschaften;
    private final Manager manager;
    private final JButton ok = new JButton("OK");
    private final JComboBox<Variante> variantenauswahl = new JComboBox<Variante>(Variante.values());
    private final Nominierung[] nominierungen = new Nominierung[4];
    private final Botselektion[] botselektionen = new Botselektion[4];

    public Absprache(Eigenschaften eigenschaften, Manager manager) {
        this.eigenschaften = eigenschaften;
        this.manager = manager;
        UIManager.addPropertyChangeListener(this);
        this.baue();
        this.aktiviere();
        this.aktualisiere();
        this.setTitle("JaFuffy (Daten f\u00fcr neues Turnier)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.getRootPane().setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setModal(true);
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Beginnen")) {
            this.setLocationRelativeTo((JRootPane)event.getNewValue());
            this.setVisible(true);
        } else if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    @Override
    public void setVisible(boolean sichtbar) {
        this.ok.requestFocus();
        super.setVisible(sichtbar);
    }

    private void aktiviere() {
        this.abbruch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Absprache.this.aktualisiere();
                Absprache.this.setVisible(false);
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ArrayList spieler = Absprache.this.uebernehmeSpieler();
                Absprache.this.manager.betreibe(new Turnier(Absprache.this.uebernehmeVariante(), spieler, Absprache.this.erster(spieler), Absprache.this.uebernehmeBeginnmodus(), Absprache.this.uebernehmeAnzahl()));
                Absprache.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(this.ok);
    }

    private JPanel anzahlauswahl() {
        JLabel label = new JLabel("Anzahl der Spiele im Turnier");
        label.setAlignmentX(0.5f);
        int anzahl = Integer.parseInt(this.eigenschaften.getProperty("Anzahl"));
        this.anzahlschieberegler.setValue(anzahl);
        this.anzahlschieberegler.setMinorTickSpacing(1);
        this.anzahlschieberegler.setMajorTickSpacing(5);
        this.anzahlschieberegler.setPaintTicks(true);
        this.anzahlschieberegler.setPaintLabels(true);
        this.anzahlschieberegler.setSnapToTicks(true);
        Hashtable<Integer, JComponent> hashtable = this.anzahlschieberegler.createStandardLabels(5);
        hashtable.put(new Integer(0), new JLabel("beliebig"));
        this.anzahlschieberegler.setLabelTable(hashtable);
        JPanel anzahlfeld = new JPanel();
        anzahlfeld.setLayout(new BoxLayout(anzahlfeld, 1));
        anzahlfeld.add(label);
        anzahlfeld.add(Box.createVerticalStrut(2));
        anzahlfeld.add(Box.createVerticalGlue());
        anzahlfeld.add(Box.createVerticalStrut(2));
        anzahlfeld.add(this.anzahlschieberegler);
        return anzahlfeld;
    }

    private void baue() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 0));
        container.add(this.nominierungsfeld());
        container.add(Box.createHorizontalStrut(4));
        JPanel regelnfeld = new JPanel(new BorderLayout());
        regelnfeld.add((Component)this.regelnfeld(), "Center");
        container.add(regelnfeld);
        container.add(Box.createHorizontalStrut(4));
        JPanel buttonleiste = new JPanel(new BorderLayout());
        buttonleiste.add((Component)this.buttonleiste(), "Center");
        container.add(buttonleiste);
    }

    private JPanel buttonleiste() {
        JPanel buttonleiste = new JPanel(new GridLayout(0, 1, 0, 8));
        buttonleiste.setBorder(new EmptyBorder(12, 2, 8, 2));
        buttonleiste.add(this.ok);
        buttonleiste.add(this.abbruch);
        return buttonleiste;
    }

    private int erster(ArrayList<Spieler> spieler) {
        Erster erster = new Erster(spieler);
        erster.setLocationRelativeTo(this);
        erster.setVisible(true);
        return erster.erster();
    }

    private void konfiguriereBeginnmodusauswahl() {
        this.beginnmodusauswahl.setAlignmentX(0.5f);
        this.beginnmodusauswahl.setSelectedIndex(this.eigenschaften.beginnmodus());
        this.beginnmodusauswahl.setToolTipText("Auswahl, welcher Mitspieler jedes neue Spiel beginnt");
    }

    private void konfiguriereVariantenauswahl() {
        this.variantenauswahl.setActionCommand("Var");
        this.variantenauswahl.setAlignmentX(0.5f);
        this.variantenauswahl.setSelectedIndex(this.eigenschaften.variante());
        this.variantenauswahl.setToolTipText("Nach welchen Spielregeln soll gespielt werden?");
    }

    private JPanel nominierungsfeld() {
        JPanel namenfeld = new JPanel(new GridBagLayout());
        namenfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Namen"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(1, 0, 1, 0);
        int i = 0;
        while (i < 4) {
            constraints.anchor = 21;
            constraints.gridx = 0;
            constraints.gridy = i;
            constraints.ipadx = 8;
            constraints.fill = 3;
            constraints.weightx = 0.0;
            String name = this.eigenschaften.getProperty("Spieler" + i);
            boolean kuenstlich = this.eigenschaften.aktiv("Bot" + i);
            this.nominierungen[i] = new Nominierung(name, kuenstlich, this);
            this.variantenauswahl.addActionListener(this.nominierungen[i]);
            this.botselektionen[i] = new Botselektion(kuenstlich, this.nominierungen[i], this.variantenauswahl);
            this.variantenauswahl.addActionListener(this.botselektionen[i]);
            namenfeld.add((Component)this.botselektionen[i], constraints);
            constraints.anchor = 10;
            constraints.gridx = 1;
            constraints.ipadx = 4;
            constraints.weightx = 0.0;
            namenfeld.add((Component)new JLabel(String.valueOf(i + 1) + ". Spieler: ", 0), constraints);
            constraints.anchor = 22;
            constraints.gridx = 2;
            constraints.ipadx = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            namenfeld.add((Component)this.nominierungen[i], constraints);
            ++i;
        }
        namenfeld.add(new JLabel());
        JLabel label = new JLabel("Viel Spa\u00df!");
        label.setHorizontalAlignment(0);
        Font font = label.getFont().deriveFont(2);
        label.setFont(font);
        constraints.anchor = 22;
        constraints.gridx = 2;
        constraints.gridy = 4;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 2.0;
        constraints.insets = new Insets(4, 0, 0, 0);
        namenfeld.add((Component)label, constraints);
        return namenfeld;
    }

    private JPanel regelnfeld() {
        this.konfiguriereVariantenauswahl();
        this.konfiguriereBeginnmodusauswahl();
        JPanel regelnfeld = new JPanel();
        regelnfeld.setLayout(new BoxLayout(regelnfeld, 1));
        regelnfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Regeln"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        regelnfeld.add(this.beginnmodusauswahl);
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(this.variantenauswahl);
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(this.anzahlauswahl());
        regelnfeld.add(Box.createVerticalGlue());
        return regelnfeld;
    }

    private int uebernehmeAnzahl() {
        this.eigenschaften.setProperty("Anzahl", Integer.toString(this.anzahlschieberegler.getValue()));
        return this.anzahlschieberegler.getValue();
    }

    private Beginner uebernehmeBeginnmodus() {
        Beginner beginnmodus = Beginner.values()[this.beginnmodusauswahl.getSelectedIndex()];
        this.eigenschaften.setProperty("Beginnmodus", beginnmodus.name());
        return beginnmodus;
    }

    private ArrayList<Spieler> uebernehmeSpieler() {
        ArrayList<Spieler> spieler = new ArrayList<Spieler>(4);
        int index = 0;
        while (index < 4) {
            this.eigenschaften.setProperty("Spieler" + index, "");
            this.eigenschaften.setProperty("Bot" + index, "");
            ++index;
        }
        int anzahl = 0;
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            nominierung.trimme();
            String name = nominierung.name();
            if (!name.isEmpty()) {
                if (nominierung.kuenstlich()) {
                    this.eigenschaften.setProperty("Bot" + anzahl, "aktiv");
                    spieler.add(new Bot(name, 3));
                } else {
                    spieler.add(new Spieler(name, 3));
                    this.eigenschaften.setProperty("Spieler" + anzahl, name);
                }
                ++anzahl;
            }
            ++n2;
        }
        return spieler;
    }

    private Variante uebernehmeVariante() {
        Variante variante = (Variante)((Object)this.variantenauswahl.getSelectedItem());
        this.eigenschaften.setProperty("Variante", variante.name());
        return variante;
    }

    void aktualisiere() {
        int spieleranzahl = 0;
        int botanzahl = 0;
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            nominierung.name(null);
            if (nominierung.kuenstlich()) {
                nominierung.name(BOTNAMEN[botanzahl]);
                ++spieleranzahl;
                ++botanzahl;
            } else if (!nominierung.name().isEmpty()) {
                ++spieleranzahl;
            }
            ++n2;
        }
        this.beginnmodusauswahl.setEnabled(spieleranzahl > 1);
        this.ok.setEnabled(spieleranzahl > 0);
    }

    static class Botselektion
    extends JCheckBox
    implements ActionListener {
        private static final Color BOT_INAKTIV_FARBE = Color.GRAY;
        private static final Color BOT_AKTIV_FARBE = Color.ORANGE.darker();
        private final JComboBox<Variante> variantenauswahl;

        Botselektion(boolean kuenstlich, Nominierung nominierung, JComboBox<Variante> variantenauswahl) {
            super("Bot");
            this.variantenauswahl = variantenauswahl;
            this.addActionListener(nominierung);
            this.setIcon(BOT_RUHT);
            this.setRolloverIcon(BOT_AKTIV);
            this.setSelectedIcon(BOT_AKTIV);
            this.setSelected(kuenstlich);
            this.setToolTipText("<html><p>Wenn angew\u00e4hlt, \u00fcbernimmt <i>JaFuffy</i> die Rolle des Spielers.</p><p><small>Bot steht bei erweiterten Regeln nicht zur Verf\u00fcgung.</small></p></html>");
            this.addActionListener(this);
            this.aktualisiere();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.aktualisiere();
        }

        private void aktualisiere() {
            boolean botfaehig = this.variantenauswahl.getSelectedItem() != Variante.ERWEITERT;
            this.setEnabled(botfaehig);
            if (botfaehig) {
                if (this.isSelected()) {
                    this.setForeground(BOT_AKTIV_FARBE);
                } else {
                    this.setForeground(BOT_INAKTIV_FARBE);
                }
            } else {
                this.setSelected(false);
                this.setForeground(Color.LIGHT_GRAY);
            }
        }
    }

    static class Nominierung
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private static final String MENSCH = "Mensch";
        private static final String BOT = "Bot";
        private final Absprache absprache;
        private final JTextField spielernameneingabe = new JTextField(8);
        private final JTextField botnamenanzeige = new JTextField();
        private boolean kuenstlich;

        Nominierung(String name, boolean kuenstlich, Absprache absprache) {
            super(new CardLayout());
            this.absprache = absprache;
            this.kuenstlich = kuenstlich;
            this.add((Component)this.spielernameneingabe, MENSCH);
            this.add((Component)this.botnamenanzeige, BOT);
            this.initialisiere(name, kuenstlich);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String kommando = event.getActionCommand();
            if (kommando.equals(BOT)) {
                JCheckBox entscheidung = (JCheckBox)event.getSource();
                CardLayout layout = (CardLayout)this.getLayout();
                this.kuenstlich = entscheidung.isSelected();
                if (this.kuenstlich) {
                    layout.show(this, BOT);
                } else {
                    layout.show(this, MENSCH);
                }
                this.absprache.aktualisiere();
            } else if (kommando.equals("Var")) {
                boolean botfaehig;
                JComboBox variantenauswahl = (JComboBox)event.getSource();
                boolean bl = botfaehig = variantenauswahl.getSelectedItem() != Variante.ERWEITERT;
                if (!botfaehig) {
                    this.kuenstlich = false;
                    CardLayout layout = (CardLayout)this.getLayout();
                    layout.show(this, MENSCH);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.absprache.aktualisiere();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.absprache.aktualisiere();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.absprache.aktualisiere();
        }

        private void initialisiere(String name, boolean kuenstlich) {
            CardLayout layout = (CardLayout)this.getLayout();
            if (kuenstlich) {
                layout.show(this, BOT);
            } else {
                layout.show(this, MENSCH);
            }
            this.spielernameneingabe.setText(name);
            this.spielernameneingabe.getDocument().addDocumentListener(this);
            this.botnamenanzeige.setEditable(false);
            this.botnamenanzeige.setEnabled(false);
        }

        boolean kuenstlich() {
            return this.kuenstlich;
        }

        String name() {
            String name = this.kuenstlich ? this.botnamenanzeige.getText() : this.spielernameneingabe.getText();
            return name.trim();
        }

        void name(String name) {
            this.botnamenanzeige.setText(name);
        }

        void trimme() {
            String name = this.spielernameneingabe.getText();
            this.spielernameneingabe.setText(name.trim());
        }
    }
}

