/******************************************************************************
 ** $Id: CEJaFuffy.java 739 2015-05-23 16:13:32Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

import javax.swing.event.ChangeEvent;

/** Behlter fr nderungsereignis. */
public class CEJaFuffy<E> extends ChangeEvent {

    private static final long serialVersionUID = 3157912329618967872L;

    /** Detaillierung des auslsenden Ereignisses . */
    private final E ereignis;

    /**
     * Ereignis aus generischem nderungsereignis extrahieren.
     *
     * @param ce
     *            Generisches nderungsereignis
     * @return Typgerechtes Ereignis
     */
    @SuppressWarnings("unchecked")
    public
    static <E> E ereignis(ChangeEvent ce) {
        return ((CEJaFuffy<E>) ce).ereignis();
    }

    /**
     * @return Gibt an, ob Quelle vom Typ her gleich dieser Klasse ist.
     */
    public static boolean adressiert(ChangeEvent ce, Class<?> klasse) {
        return (ereignis(ce).getClass() == klasse);
    }

    /**
     * Konstruktor.
     *
     * @param quelle
     *            Auslser.
     * @param ereignis
     *            Detaillierung des Ereignisses.
     */
    CEJaFuffy(Object quelle, E ereignis) {
        super(quelle);
        this.ereignis = ereignis;
    }

    /**
     * @param klasse
     *            Diese Ereignisklasse soll adressiert sein.
     * @return Gibt an, ob das Ereignis zur angegebenen Klasse gehrt.
     */
    boolean addressiert(Class<?> klasse) {
        return ereignis.getClass() == klasse;
    }

    /** @return Gespeichertes Ereignis. */
    E ereignis() {
        return ereignis;
    }

}
