/******************************************************************************
 ** $Id: Becher.java 739 2015-05-23 16:13:32Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.CEWuerfel;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.Wuerfel;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Wrfel-Button (Becher).
 */
@SuppressWarnings("serial")
class Becher extends JButton implements ChangeListener {

    /** Grafiken im Button frs Wrfeln. */
    private static final ImageIcon[] BECHER = new ImageIcon[Wuerfel.AUGEN];
    static {
        for (int i = 0; i <= Turnier.WUERFEL; i++) {
            BECHER[i] = Grafik.icon("Becher" + i + ".gif");
        }
    }
    /** Wurfgerusche. */
    private static final Geraeusch[] WUERFELN = new Geraeusch[Turnier.WUERFEL];
    static {
        for (int i = 0; i < Turnier.WUERFEL; i++) {
            WUERFELN[i] = new Geraeusch("Wuerfeln" + (i + 1) + ".wav");
        }
    }
    /** Schttelgerusch. */
    private static final Geraeusch SCHUETTELN = new Geraeusch("Schuetteln.wav");
    /** Verzgerung Schtteln/Wrfeln. */
    private static final int DELAY = 75;
    /** Mit Becher wrfeln (Kontexthilfe). */
    private static final String WERFEN = "<html>" + "Wrfel im Becher werfen" + "<br>"
            + "<small>Mausklick oder Taste \"w\"</small>" + "</html>";
    /** Wrfel in Becher zurcklegen (Kontexthilfe). */
    private static final String LEGEN = "Bitte Wrfel in Becher legen";
    /** Wurf in Tabelle setzen (Kontexthilfe). */
    private static final String SETZEN = "Bitte in der Tabelle setzen";

    /** Anzahl der in den Becher gelegten Wrfel. */
    private int gelegt = 0;
    /** Anzahl der geworfenen Wrfel. */
    private int geworfen = 0;

    /** Konstruktor. */
    Becher() {
        setFocusable(false);
        setAlignmentX(CENTER_ALIGNMENT);
        setToolTipText(WERFEN);
        setEnabled(false);
        setIcon(BECHER[0]);
        getInputMap(WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_W, 0), this);
        getActionMap().put(this, new AbstractAction() {
            // Verzgerung bei Klick durch Tastatur
            private static final int KLICKZEIT = 200;

            // Mausklick wird simuliert
            @Override
            public void actionPerformed(ActionEvent ev) {
                JButton button = (JButton) ev.getSource();
                button.doClick(KLICKZEIT);
            }
        });
    }

    /**
     * Modelldaten haben sich verndert.
     *
     * @param ce
     *            Wrfelauswahl oder Spielablauf.
     */
    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEWuerfel.class)) {
            switch (CEJaFuffy.<CEWuerfel> ereignis(ce)) {
            case ANWAHL:
                gelegt++;
                aktualisiere();
                break;
            case ABWAHL:
                gelegt--;
                aktualisiere();
                break;
            case WURF:
                geworfen++;
                break;
            default:
                break;
            }
        } else if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch (CEJaFuffy.<CEAblauf> ereignis(ce)) {
            case START:
                aktualisiere();
            case GESETZT:
                SCHUETTELN.play(DELAY);
                break;
            case WUERFELN:
                wuerfle();
                break;
            case GEWUERFELT:
                aktualisiere(((Turnier) ce.getSource()).aktiver());
                break;
            case ABBRUCH:
            case ENDE:
                gelegt = 0;
                geworfen = 0;
                break;
            default:
                break;
            }
        }
    }

    /** Anzeige des Bechers aktualisieren. */
    private void aktualisiere() {
        setEnabled(gelegt > 0);
        setIcon(BECHER[gelegt]);
        setToolTipText(zustandsbeschreibung());
    }

    /**
     * Anzeige des Bechers aktualisieren.
     *
     * @param aktiv
     *            Aktiver Spieler.
     */
    private void aktualisiere(Spieler aktiv) {
        setEnabled(false);
        setToolTipText(zustandsbeschreibung(aktiv));
    }

    /** Geruschuntermalung beim Wrfeln. */
    private void wuerfle() {
        WUERFELN[geworfen - 1].play(DELAY);
        geworfen = 0;
    }

    /**
     * Hilfetext fr Zustandsbeschreibung.
     *
     * @return Tool Tip Text
     */
    private String zustandsbeschreibung() {
        if (gelegt > 0) {
            return WERFEN;
        } else {
            return LEGEN;
        }
    }

    /**
     * Hilfetext fr Zustandsbeschreibung.
     *
     * @param aktiv
     *            Aktiver Spieler.
     * @return Tool Tip Text
     */
    private String zustandsbeschreibung(Spieler aktiv) {
        if (aktiv.rest() == 0) {
            return SETZEN;
        } else {
            return zustandsbeschreibung();
        }
    }

}
