/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Geraeusch;
import jafuffy.bedienung.Tabelle;
import jafuffy.logik.Auswertung;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Turnier;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public abstract class Auswahl
extends DefaultCellEditor {
    private static final int ABSTAND = 4;
    static final Geraeusch HURRA = new Geraeusch("Hurra.wav");
    static final NumberFormat NF = NumberFormat.getInstance(Locale.GERMAN);
    private final JButton setzen;
    protected Turnier turnier;
    protected Auswertung auswertung;
    protected int clicks;
    protected Tabzeile eintrag;
    protected Tabelle tabelle;

    static {
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(2);
    }

    Auswahl(Turnier turnier) {
        super(new JCheckBox());
        this.turnier = turnier;
        this.auswertung = turnier.auswertung();
        this.setClickCountToStart(1);
        this.setzen = new JButton("setzen");
        this.setzen.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.setzen.setFocusPainted(false);
        this.setzen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Auswahl.this.geklickt();
            }
        });
    }

    public void doClick() {
        this.setzen.doClick();
        if (!Eigenschaften.GLOBAL.aktiv("Einfachklick")) {
            this.setzen.doClick();
        }
    }

    void aktiviere(Tabzeile eintrag) {
        this.eintrag = eintrag;
        this.clicks = 0;
        this.editorComponent = this.setzen;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.aktiviere(Tabzeile.eintrag(row));
        this.tabelle = (Tabelle)table;
        this.aktualisiere();
        return this.editorComponent;
    }

    abstract void geklickt();

    void gewuerfelt() {
        this.aktualisiere();
    }

    private void aktualisiere() {
        if (this.eintrag != null) {
            this.fireEditingCanceled();
            String text = "1 Klick = " + this.auswertung.wert(this.eintrag) + " Punkte";
            if (this.auswertung.tipps()) {
                text = "<html><p>" + text + "</p>" + "<p>Endstandwertung " + NF.format(this.auswertung.wichtung(this.eintrag)) + "</p></html>";
            }
            this.editorComponent.setToolTipText(text);
        }
    }
}

