/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.rules.Condition;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContainsCondition
extends Condition {
    private static final long serialVersionUID = 114116957546161583L;
    private static final transient Logger logger = Logger.getLogger(ContainsCondition.class.getName());
    private static final String VALUE_ELEMENT_NAME = "value";
    private static final String VALUE_ATTR_REGEX_NAME = "regex";
    private static final String VALUE_ATTR_CASEINSENSITIVE_NAME = "caseInsensitive";
    private static final String VALUE_ATTR_BYLINE_NAME = "byLine";
    private ContentType contentType;
    private String source = null;
    private String value = null;
    private boolean isRegEx = false;
    private boolean isCaseInsensitive = false;
    private boolean isByLine = true;
    private Pattern pattern = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTrue() {
        String content = null;
        if (this.source == null) {
            return false;
        }
        Variables variables = this.getInstallData().getVariables();
        switch (this.contentType) {
            case STRING: {
                content = variables.replace(this.source);
                break;
            }
            case VARIABLE: {
                content = this.getInstallData().getVariable(this.source);
                break;
            }
            case FILE: {
                File file = new File(variables.replace(this.source));
                if (this.isByLine) {
                    BufferedReader in = null;
                    try {
                        boolean bl = this.matchesByLine(new FileReader(file));
                        return bl;
                    }
                    catch (FileNotFoundException e) {
                        logger.log(Level.WARNING, e.getMessage());
                        boolean e2 = false;
                        return e2;
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                byte[] buffer = new byte[(int)file.length()];
                BufferedInputStream f = null;
                try {
                    f = new BufferedInputStream(new FileInputStream(file));
                    f.read(buffer);
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.getMessage());
                    return false;
                }
                content = new String(buffer);
                break;
            }
            default: {
                logger.warning("Illegal source type '" + this.contentType.getAttribute() + "' for condition \"" + this.getId() + "\"");
            }
        }
        if (content == null) {
            return false;
        }
        if (this.isRegEx) {
            if (this.isByLine) {
                return this.matchesByLine(new StringReader(content));
            }
            this.pattern = Pattern.compile(this.value);
        }
        return this.matchesString(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesByLine(Reader reader) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(reader);
            String line = in.readLine();
            while (true) {
                if (line != null) {
                    if (this.matchesString(line)) {
                        boolean bl = true;
                        return bl;
                    }
                    line = in.readLine();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return false;
    }

    private boolean matchesString(String line) {
        Matcher matcher;
        return this.isRegEx ? (matcher = this.pattern.matcher(line)).matches() : (this.isCaseInsensitive ? line.toLowerCase().contains(this.value.toLowerCase()) : line.contains(this.value));
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition != null) {
            for (IXMLElement child : xmlcondition.getChildren()) {
                ContentType contentType = ContentType.getFromAttribute(child.getName());
                if (contentType != null) {
                    this.contentType = contentType;
                    if (this.source != null) {
                        throw new Exception("Condition \"" + this.getId() + "\" has ambigous source elements");
                    }
                    this.source = child.getContent();
                    if (this.source != null && this.source.length() != 0) continue;
                    throw new Exception("Condition \"" + this.getId() + "\" has a nested '" + contentType.getAttribute() + "' element without valid contents");
                }
                if (VALUE_ELEMENT_NAME.equalsIgnoreCase(child.getName())) {
                    this.isRegEx = Boolean.valueOf(child.getAttribute(VALUE_ATTR_REGEX_NAME));
                    this.isCaseInsensitive = Boolean.valueOf(child.getAttribute(VALUE_ATTR_CASEINSENSITIVE_NAME));
                    this.isByLine = Boolean.valueOf(child.getAttribute(VALUE_ATTR_BYLINE_NAME));
                    this.value = child.getContent();
                    if (this.value != null && this.value.length() != 0) continue;
                    throw new Exception("Condition \"" + this.getId() + "\" has a nested '" + VALUE_ELEMENT_NAME + "' element without valid contents");
                }
                throw new Exception("Unknown nested element '" + child.getName() + "' for condition \"" + this.getId() + "\"");
            }
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String content) {
        this.source = content;
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl el1 = new XMLElementImpl(this.contentType.getAttribute(), conditionRoot);
        el1.setContent(this.source);
        conditionRoot.addChild(el1);
        XMLElementImpl el2 = new XMLElementImpl(VALUE_ELEMENT_NAME, conditionRoot);
        el2.setContent(this.value);
        el2.setAttribute(VALUE_ATTR_REGEX_NAME, Boolean.toString(this.isRegEx));
        el2.setAttribute(VALUE_ATTR_CASEINSENSITIVE_NAME, Boolean.toString(this.isCaseInsensitive));
        el2.setAttribute(VALUE_ATTR_BYLINE_NAME, Boolean.toString(this.isByLine));
        conditionRoot.addChild(el2);
    }

    public static enum ContentType {
        VARIABLE("variable"),
        STRING("string"),
        FILE("file");

        private static Map<String, ContentType> lookup;
        private String attribute;

        private ContentType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static ContentType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, ContentType>();
            for (ContentType operation : EnumSet.allOf(ContentType.class)) {
                lookup.put(operation.getAttribute(), operation);
            }
        }
    }
}

