/******************************************************************************
 ** $Id: Aenderungen.java 739 2015-05-23 16:13:32Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

import java.io.Serializable;

import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/**
 * Speichert Objekte, die an einem nderungsereignis interessiert sind, und benachrichtigt
 * diese.
 */
class Aenderungen<E> implements Serializable {

    private static final long serialVersionUID = 7998252922545416326L;

    // Liste aller Listener (bei jedem Programmlauf erneuert)
    private transient EventListenerList liste;

    /**
     * ChangeListener eintragen.
     *
     * @param cl
     */
    public void addChangeListener(ChangeListener cl) {
        if (liste == null) {
            liste = new EventListenerList();
        }
        liste.add(ChangeListener.class, cl);
    }

    /**
     * ChangeListener entfernen.
     *
     * @param cl
     */
    public void removeChangeListener(ChangeListener cl) {
        liste.remove(ChangeListener.class, cl);
    }

    /**
     * Ereignis abfeuern. Achtung: Empfnger des Ereignisses drfen kein Ereignis abfeuern!
     *
     * @param ereignis
     */
    void fireStateChanged(E ereignis) {
        CEJaFuffy<E> ce = new CEJaFuffy<E>(this, ereignis);
        if (liste != null) {
            Object[] listeners = liste.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] == ChangeListener.class) {
                    ((ChangeListener) listeners[i + 1]).stateChanged(ce);
                }
            }
        }
    }

}
