/******************************************************************************
 ** $Id: AuswahlErweitert.java 739 2015-05-23 16:13:32Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.logik.AuswertungErweitert;
import jafuffy.logik.Punkte;
import jafuffy.logik.Tabzeile;
import jafuffy.logik.Turnier;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Timer;

/**
 * Auswahl der Zelle, in die das Wrfelresultat gesetzt wird (erweiterte Regeln). Gibt
 * JaFuffy/Joker/Bonus-Meldung aus; fhrt "Zwangssetzung" aus.
 */
@SuppressWarnings("serial")
public class AuswahlErweitert extends AuswahlKlassisch {

    // Timer (Zwangsetzung, Jokersetzung) in ms
    private static final int ZWANGDELAY = 1500;
    private static final int JOKERDELAY = 1500;
    // Zwangsetzung: belege Feld im oberen Teil und JaFuffy-Joker, Nachricht
    private final Timer zwangtimer = new Timer(ZWANGDELAY, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            Tabzeile eintrag = Tabzeile.oben(turnier.wuerfel(0).augen());
            ((AuswertungErweitert) auswertung).setzzwangnachricht(false);
            ((AuswertungErweitert) auswertung).bonusnachricht(false);
            turnier.aktiver().eintragen(eintrag, auswertung.wert(eintrag));
            turnier.setze(Tabzeile.JAFUFFY, turnier.aktiver().punkte(Tabzeile.JAFUFFY)
                    + AuswertungErweitert.JOKER);
        }
    }) {
        @Override
        public boolean isRepeats() {
            return false;
        }
    };
    // Zwangsetzung: JaFuffy-Joker, Nachricht
    private final Timer jokertimer = new Timer(JOKERDELAY, new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            ((AuswertungErweitert) auswertung).bonusnachricht(false);
            turnier.setze(Tabzeile.JAFUFFY, turnier.aktiver().punkte(Tabzeile.JAFUFFY)
                    + AuswertungErweitert.JOKER);
        }
    }) {
        @Override
        public boolean isRepeats() {
            return false;
        }
    };

    /**
     * Konstruktor.
     *
     * @param turnier
     */
    public AuswahlErweitert(Turnier turnier) {
        super(turnier);
    }

    /**
     * Spieler hat gewrfelt.
     */
    @Override
    void gewuerfelt() {
        super.gewuerfelt();
        if (((AuswertungErweitert) auswertung).setzzwang()) {
            ((Punkte) tabelle.getModel()).auswaehlbar(false);
            ((AuswertungErweitert) auswertung).setzzwangnachricht(true);
            ((AuswertungErweitert) auswertung).bonusnachricht(true);
            HURRA.play();
            zwangtimer.start();
        } else if (((AuswertungErweitert) auswertung).joker()) {
            ((AuswertungErweitert) auswertung).jokernachricht(true);
        }
    }

    /* Geklickt! */
    @Override
    void geklickt() {
        if (++clicks == 2 || Eigenschaften.GLOBAL.aktiv("Einfachklick")) {
            fireEditingStopped();
            if (((AuswertungErweitert) auswertung).joker()) {
                turnier.pausiere();
                ((AuswertungErweitert) auswertung).jokernachricht(false);
                ((AuswertungErweitert) auswertung).bonusnachricht(true);
                turnier.aktiver().eintragen(eintrag, auswertung.wert(eintrag));
                HURRA.play();
                jokertimer.start();
            } else {
                turnier.setze(eintrag);
            }
        }
    }

}
