/******************************************************************************
 ** $Id: Willkommen.java 701 2015-02-08 21:10:06Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.WindowConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/**
 * Einfhrungsdialog beim erstmaligen Programmstart.
 */
@SuppressWarnings("serial")
class Willkommen extends JDialog {

    /** Erstes Icon zur Wechselgrafik beim Willkommendialog. */
    private static final ImageIcon WILLKOMMEN1 = Grafik.icon("Willkommen1.gif");
    /** ID des erstens Icons zur Wechselgrafik. */
    private static final String ID1 = "1";
    /** Zweites Icon zur Wechselgrafik beim Willkommendialog. */
    private static final ImageIcon WILLKOMMEN2 = Grafik.icon("Willkommen2.gif");
    /** ID des zweiten Icons zur Wechselgrafik. */
    private static final String ID2 = "2";
    /** Installationsseite (Name) aus der Hilfe. */
    private static final String INSTALLATION = "Installation.html";
    /** Installationsseite (URL) aus der Hilfe. */
    private static final URL HINWEISE = Ressource.LIESMICH.url(INSTALLATION);
    /** Font, der im Willkommensdialog verwendet wird. */
    private static final Font BOLD18 = new Font("Dialog", Font.BOLD, 18);

    /** Konstruktor. */
    Willkommen() {

        // Titel
        JLabel titel = new JLabel("Willkommen zu JaFuffy!", SwingConstants.CENTER);
        titel.setFont(BOLD18);

        // Wechselgrafiken
        final JPanel grafik = new JPanel(new CardLayout());
        grafik.add(new JLabel(WILLKOMMEN1), ID1);
        grafik.add(new JLabel(WILLKOMMEN2), ID2);

        // Timer zum Wechseln der Grafik
        final Timer timer = new Timer(5000, new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout) grafik.getLayout()).next(grafik);
            }
        });

        // Kurzbeschreibung
        JTextArea beschreibung =
                new JTextArea("JaFuffy ist ein Wrfelspiel mit drei Spielregelvarianten, "
                        + "hnlich zu Kniffel, Yahtzee oder Fuffy. "
                        + "Spiele knnen zu Turnieren zusammengefasst, "
                        + "gespeichert und geladen werden. "
                        + "Die besten Punktzahlen werden in Listen eingetragen. "
                        + "Bis zu vier Mitspieler sind mglich.", 3, 45);
        beschreibung.setLineWrap(true);
        beschreibung.setWrapStyleWord(true);
        beschreibung.setEditable(false);
        beschreibung.setOpaque(false);
        beschreibung.setBorder(BorderFactory.createTitledBorder(null, "Kurzbeschreibung",
                TitledBorder.LEFT, TitledBorder.ABOVE_TOP));

        // Automatisch bei Programmstart nach Updates suchen?
        JCheckBox nachschauen = new JCheckBox();
        nachschauen.setSelected(Eigenschaften.GLOBAL.aktiv("Nachschauen"));
        nachschauen.setBorderPainted(true);
        nachschauen.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(2, 4, 2, 2),
                BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(),
                        new EmptyBorder(0, 8, 0, 8))));
        nachschauen.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Eigenschaften.GLOBAL.wechsle("Nachschauen");
            }
        });
        JTextArea suchverhalten =
                new JTextArea(
                        "Automatisch bei jedem Programmstart "
                                + "nach neuerer Version auf JaFuffys Homepage suchen. "
                                + "Das Verhalten kann nachtrglich im Menpunkt "
                                + "\"Einstellungen - Nachschauen\" festgelegt werden. "
                                + "Der Menpunkt \"Hilfe - Aktualisieren...\" stt die Suche explizit an.",
                        3, 45);
        suchverhalten.setLineWrap(true);
        suchverhalten.setWrapStyleWord(true);
        suchverhalten.setEditable(false);
        suchverhalten.setOpaque(false);
        JPanel aktualiserungsfeld = new JPanel(new BorderLayout());
        aktualiserungsfeld.setBorder(BorderFactory.createTitledBorder(null,
                "Auf Homepage nachschauen", TitledBorder.LEFT, TitledBorder.ABOVE_TOP));
        aktualiserungsfeld.add(nachschauen, BorderLayout.EAST);
        aktualiserungsfeld.add(suchverhalten, BorderLayout.CENTER);

        // Kurzinstallationshilfe
        JEditorPane hilfe;
        try {
            hilfe = new JEditorPane(HINWEISE);
        } catch (IOException e) {
            e.printStackTrace();
            Signal.WARNUNG.play();
            JOptionPane.showMessageDialog(null, "(De)Installationshinweise \"" + INSTALLATION
                    + "\" knnen nicht geladen werden!", "JaFuffy (Warnung)",
                    JOptionPane.WARNING_MESSAGE);
            hilfe =
                    new JEditorPane("text", "(De)Installationshinweise \"" + INSTALLATION
                            + "\" knnen nicht geladen werden!");
        }
        hilfe.setEditable(false);
        hilfe.addHyperlinkListener(new HyperlinkListener() {
            @Override
            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(he.getURL().toURI());
                    } catch (Exception ex) {
                        System.out.println(ex);
                    }
                }
            }
        });
        JScrollPane hilfescroll = new JScrollPane(hilfe);
        JPanel hilfefeld = new JPanel(new BorderLayout());
        hilfefeld.setPreferredSize(new Dimension(400, 275));
        hilfefeld.setBorder(BorderFactory.createTitledBorder(null,
                "Hinweise zur (De)Installation", TitledBorder.LEFT, TitledBorder.ABOVE_TOP));
        hilfefeld.add(grafik, BorderLayout.WEST);
        hilfefeld.add(hilfescroll, BorderLayout.CENTER);

        // Button-Leiste
        JPanel leiste = new JPanel(new GridLayout(1, 2, 4, 4));
        JButton abbruch = new JButton("Abbruch");
        abbruch.setToolTipText("Programm beenden");
        abbruch.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JButton weiter = new JButton("Weiter");
        weiter.setToolTipText("Einstellungspfad whlen und Programm beginnen");
        weiter.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                timer.stop();
            }
        });
        weiter.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                new Pfad(Willkommen.this);
                setVisible(false);
                timer.stop();
            }
        });
        leiste.add(weiter);
        leiste.add(abbruch);

        // Texte
        JPanel texte = new JPanel(new BorderLayout(8, 8));
        texte.add(beschreibung, BorderLayout.NORTH);
        texte.add(hilfefeld, BorderLayout.CENTER);
        texte.add(aktualiserungsfeld, BorderLayout.SOUTH);

        // Aufbau
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.setBorder(BorderFactory.createEmptyBorder(8, 4, 4, 4));
        titel.setAlignmentX(Component.CENTER_ALIGNMENT);
        panel.add(titel);
        panel.add(Box.createVerticalStrut(8));
        panel.add(texte);
        panel.add(Box.createVerticalStrut(8));
        panel.add(leiste);

        // Darstellung
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("JaFuffy (Erffnungsmeldung)");
        setIconImages(Oberflaeche.LOGOS);
        setModal(true);
        setContentPane(panel);
        getRootPane().setDefaultButton(weiter);
        pack();
        setLocationRelativeTo(null);
        timer.start();
        setVisible(true);
    }
}
