/******************************************************************************
 ** $Id: AuswertungKlassisch.java 591 2014-08-02 12:29:04Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

/** Klassische Auswertung. */
class AuswertungKlassisch extends Auswertung {

    private static final long serialVersionUID = -8337338622524893182L;

    /** Erwartete Punktzahl pro Spiel (Schtzung). */
    private static final int MITTELWERT = 235;
    /** Standardabweichung (Schtzung). */
    private static final int ABWEICHUNG = 45;

    /** Regelname. */
    static final String REGEL = "Klassische Regeln";

    /**
     * Konstruktor.
     * 
     * @param variante
     *            Spielregelvariante
     * @param wuerfel
     *            Die im Turnier benutzten Wrfel.
     */
    public AuswertungKlassisch(Variante variante, Wuerfel[] wuerfel) {
        super(variante, wuerfel);
    }

    /**
     * @return Regelname
     */
    @Override
    public String toString() {
        return REGEL;
    }

    /**
     * @return mittlere Punktzahl pro Spiel
     */
    @Override
    int mittelwert() {
        return MITTELWERT;
    }

    /**
     * @return Abweichung von mittlerer Punktzahl pro Spiel
     */
    @Override
    int abweichung() {
        return ABWEICHUNG;
    }

    /**
     * @param eintrag
     *            Nummer des Eintrags auf dem Punktezettel
     * @return erwrfelte Punkte fr das Eintragsfeld
     */
    @Override
    int wert(Tabzeile eintrag) {
        return analyse.wert(eintrag);
    }

    /**
     * @param eintrag
     *            Zeilennummer des Eintrags
     * @return Texteintrag
     */
    @Override
    String text(Tabzeile eintrag) {
        return null;
    }

}
