/******************************************************************************
 ** $Id: Pfad.java 605 2014-11-12 03:40:08Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.awt.Component;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

/** Pfad zu Statistik-Daten und Turnierstnden auswhlen. */
@SuppressWarnings("serial")
class Pfad extends JFileChooser {

    /**
     * Liefert ein File-Objekt zur Datei zurck, zusammengebaut aus dem Speicherverzeichnis und
     * dem Dateinamen.
     *
     * @param name
     *            Der Dateiname, aus dem das File-Objekt erzeugt wird.
     *
     * @return Das File-Objekt zur Datei.
     */
    static File datei(String name) {
        return new File(pfad(), name);
    }

    /**
     * @return Pfad zum Speicherverzeichnis.
     */
    static String pfad() {
        return Eigenschaften.GLOBAL.getProperty("Pfad", System.getProperty("user.home"));
    }

    /**
     * Konstruktor.
     *
     * @param feld
     *            Dialog wird zum Feld zentriert
     */
    Pfad(Component feld) {

        super(Eigenschaften.GLOBAL.getProperty("Pfad", System.getProperty("user.home")));
        setDialogTitle("JaFuffy"
                + " (Frage nach Speicherort von Statistikdaten und Turnierstnden)");
        setFileSelectionMode(DIRECTORIES_ONLY);

        if (showDialog(feld, "Dorthin speichern") == CANCEL_OPTION) {
            Signal.WARNUNG.play();
            JOptionPane.showMessageDialog(
                    feld,
                    "Kein Pfad gewhlt!\n"
                            + "Momentan eingestellter Pfad:\n"
                            + Eigenschaften.GLOBAL.getProperty("Pfad",
                                    System.getProperty("user.home")), "JaFuffy (Warnung)",
                    JOptionPane.WARNING_MESSAGE);
        } else {
            Eigenschaften.GLOBAL.setProperty("Pfad", getSelectedFile().getAbsolutePath());
        }

    }

}
