/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Auswertung;
import jafuffy.Spieler;
import jafuffy.Tabzeile;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class Punkte
extends AbstractTableModel {
    private final ArrayList<Spieler> spieler;
    private final Auswertung auswertung;
    private boolean auswaehlbar = true;

    Punkte(ArrayList<Spieler> spieler, Auswertung auswertung) {
        this.spieler = spieler;
        this.auswertung = auswertung;
        for (Spieler s : spieler) {
            s.beobachten(new Meldung(spieler.indexOf(s)));
        }
    }

    @Override
    public int getRowCount() {
        return Tabzeile.ANZAHL;
    }

    @Override
    public int getColumnCount() {
        return this.spieler.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.spieler.get(col).toString();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.spieler.get(col).punkte(Tabzeile.eintrag(row));
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Spieler s = this.spieler.get(col);
        return s.gewuerfelt() && s.setzbar(Tabzeile.eintrag(row)) && this.auswaehlbar;
    }

    Auswertung auswertung() {
        return this.auswertung;
    }

    void auswaehlbar(boolean auswaehlbar) {
        this.auswaehlbar = auswaehlbar;
    }

    boolean aktiv(int col) {
        Spieler s = this.spieler.get(col);
        return s.rest() > 0 || s.gewuerfelt();
    }

    void aktiv() {
        int col = 0;
        while (col < this.getColumnCount()) {
            if (this.aktiv(col)) {
                this.spieler.get(col).reaktivieren();
            }
            ++col;
        }
    }

    boolean offen(int col) {
        return this.spieler.get(col).rest() > 0;
    }

    boolean angefangen(int col) {
        return this.aktiv(col) && this.spieler.get(col).rest() < 3;
    }

    boolean setzbar(int row, int col) {
        return this.spieler.get(col).setzbar(Tabzeile.eintrag(row));
    }

    class Meldung {
        private final int spalte;

        Meldung(int spalte) {
            this.spalte = spalte;
        }

        void mitteilen() {
            Punkte.this.fireTableChanged(new TableModelEvent(Punkte.this, 0, Punkte.this.getRowCount() - 1, this.spalte));
        }
    }
}

