/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Grafik;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.Timer;

class Intro
extends JPanel
implements ActionListener {
    private static final String SCHRIFTZUG = "JaFuffy!";
    private static final int SCHRIFTGROESSE = 18;
    private static final int SKALIERUNG = 3;
    private static final String WUERFEL = "Wuerfel";
    private static final int ANZAHL_WUERFELSEITEN = 6;
    private static final BufferedImage[] BILDER = new BufferedImage[6];
    private static final int D;
    private static final int ANZAHL_WUERFEL = 5;
    private static final int PERIODE = 3000;
    private static final int ITERATIONEN = 5;
    private final Random zufall = new Random();
    private BufferedImage bild;
    private int s;
    private int faktor;
    private int muster;
    private final Timer timer = new Timer(3000, this);
    private int zaehler;

    static {
        Image[] images = new Image[6];
        int i = 0;
        while (i < 6) {
            images[i] = Grafik.bild(WUERFEL + (i + 1) + ".gif");
            ++i;
        }
        RescaleOp invertierung = new RescaleOp(-1.0f, 255.0f, null);
        int i2 = 0;
        while (i2 < 6) {
            Intro.BILDER[i2] = new BufferedImage(images[i2].getWidth(null), images[i2].getHeight(null), 1);
            BILDER[i2].getGraphics().drawImage(images[i2], 0, 0, null);
            Intro.BILDER[i2] = invertierung.filter(BILDER[i2], null);
            ++i2;
        }
        D = BILDER[0].getWidth(null);
    }

    Intro() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Intro.this.initialisiereGenerierung();
                Intro.this.starteGenerierung();
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (Intro.this.isShowing()) {
                    Intro.this.timer.start();
                } else {
                    Intro.this.timer.stop();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.bild == null) {
            return;
        }
        BufferedImage kopie = new BufferedImage(this.s / 3, this.s / 3, 1);
        kopie.getGraphics().drawImage(this.bild.getScaledInstance(this.s / 3, this.s / 3, 4), 0, 0, null);
        Graphics grafik = this.bild.getGraphics();
        grafik.setColor(this.getBackground());
        grafik.fillRect(0, 0, this.s, this.s);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i == 1 && j == 1 || (i + j) % 2 == this.muster) {
                    grafik.drawImage(kopie, i * this.s / 3, j * this.s / 3, null);
                }
                ++j;
            }
            ++i;
        }
        ++this.zaehler;
        if (this.zaehler >= 5) {
            this.starteGenerierung();
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.bild != null) {
            g.drawImage(this.bild, (this.getWidth() - this.bild.getWidth()) / 2, (this.getHeight() - this.bild.getHeight()) / 2, null);
        }
    }

    private void initialisiereGenerierung() {
        this.s = this.getWidth() > this.getHeight() ? this.getHeight() : this.getWidth();
        if (this.s <= 3 * D / 2) {
            return;
        }
        this.faktor = this.s <= 3 * D ? 0 : (this.s <= 6 * D ? 1 : 2);
        this.bild = new BufferedImage(this.s, this.s, 1);
    }

    private void starteGenerierung() {
        int i;
        int[] x = new int[5];
        int[] y = new int[5];
        block0: do {
            i = 0;
            while (i < 5) {
                x[i] = this.zufall.nextInt(this.s - D);
                y[i] = this.zufall.nextInt(this.s - D);
                ++i;
            }
            i = 0;
            while (i < 5) {
                int j = 0;
                while (j < i) {
                    if ((x[i] - x[j]) * (x[i] - x[j]) + (y[i] - y[j]) * (y[i] - y[j]) <= this.faktor * D * D) continue block0;
                    ++j;
                }
                ++i;
            }
        } while (i < 5);
        Graphics grafik = this.bild.getGraphics();
        grafik.setColor(this.getBackground());
        grafik.fillRect(0, 0, this.s, this.s);
        grafik.setColor(this.getBackground().darker());
        grafik.setFont(new Font("SansSerif", 3, 18));
        Rectangle2D rahmen = grafik.getFontMetrics().getStringBounds(SCHRIFTZUG, grafik);
        int w = this.bild.getWidth() / (int)((double)this.bild.getWidth() / rahmen.getWidth());
        int h = this.bild.getHeight() / (int)((double)this.bild.getHeight() / rahmen.getHeight());
        int m = 0;
        while (m < this.bild.getWidth()) {
            int n = h;
            while (n < this.bild.getHeight()) {
                grafik.drawString(SCHRIFTZUG, m, n);
                n += h;
            }
            m += w;
        }
        i = 0;
        while (i < 5) {
            grafik.drawImage(BILDER[this.zufall.nextInt(6)], x[i], y[i], null);
            ++i;
        }
        this.zaehler = 0;
        this.muster = this.zufall.nextInt(2);
        this.repaint();
    }
}

