/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.CEAblauf;
import jafuffy.CEJaFuffy;
import jafuffy.Eigenschaften;
import jafuffy.Pfad;
import jafuffy.Signal;
import jafuffy.Statistik;
import jafuffy.Turnier;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Ende
extends WindowAdapter
implements ChangeListener {
    private final Statistik statistik;
    private Turnier turnier;

    Ende(Statistik statistik) {
        this.statistik = statistik;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch ((CEAblauf)((Object)CEJaFuffy.ereignis(ce))) {
                case START: {
                    this.turnier = (Turnier)ce.getSource();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.turnier = null;
                }
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent we) {
        Window fenster = we.getWindow();
        if (Eigenschaften.GLOBAL.neustart() || JOptionPane.showConfirmDialog(fenster, "JaFuffy beenden?", "JaFuffy (Frage)", 0) == 0) {
            this.sichereTurnierEigenschaften(fenster);
            this.sichereStatistik(fenster);
            this.beendeApplikation();
        }
    }

    private void beendeApplikation() {
        if (this.turnier != null) {
            this.turnier.beende();
        }
    }

    private void sichereStatistik(Window fenster) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(Pfad.datei("Statistik.obj")));
            out.writeObject(this.statistik);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(fenster, "Statistik konnte nicht gesichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
    }

    private void sichereTurnierEigenschaften(Window fenster) {
        try {
            Eigenschaften.GLOBAL.speichere(fenster.getX(), fenster.getY(), fenster.getWidth(), fenster.getHeight());
        }
        catch (IOException e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane.showMessageDialog(fenster, "JaFuffy-Einstellungen konnten nicht gesichert werden!\nJava-Exception:\n" + e, "JaFuffy (Fehler)", 0);
        }
    }
}

