/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ant_deb_task;

import com.googlecode.ant_deb_task.UnixPrintWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class DesktopEntry
extends Task {
    private Properties _categories = new Properties();
    private Properties _keys = new Properties();
    private File _toFile;
    private Map _entries;
    private List _localizedEntries = new ArrayList();
    private static final Set VALID_ONLY_SHOW_IN = new HashSet<String>(Arrays.asList("GNOME", "KDE", "ROX", "XFCE", "Old"));

    public void setToFile(File toFile) {
        this._toFile = toFile;
    }

    public void setType(Type type) {
        this._entries.put("Type", type.getValue());
    }

    public void setName(String name) {
        this._entries.put("Name", name);
    }

    public void setGenericName(String genericName) {
        this._entries.put("GenericName", genericName);
    }

    public void setNoDisplay(boolean noDisplay) {
        this._entries.put("NoDisplay", noDisplay ? "true" : "false");
    }

    public void setComment(String comment) {
        this._entries.put("Comment", comment);
    }

    public void setIcon(String icon) {
        this._entries.put("Icon", icon);
    }

    public void setOnlyShowIn(String onlyShowIn) {
        if (this._entries.containsKey("NotShowIn")) {
            throw new BuildException("Only one of either OnlyShowIn or NotShowIn can be set!");
        }
        String[] categories = onlyShowIn.split(";");
        for (int i = 0; i < categories.length; ++i) {
            String category = categories[i];
            if (VALID_ONLY_SHOW_IN.contains(category)) continue;
            throw new BuildException(category + " is not a valid OnlyShowIn category!");
        }
        this._entries.put("OnlyShowIn", onlyShowIn);
    }

    public void setNotShowIn(String notShowIn) {
        if (this._entries.containsKey("OnlyShowIn")) {
            throw new BuildException("Only one of either OnlyShowIn or NotShowIn can be set!");
        }
        String[] categories = notShowIn.split(";");
        for (int i = 0; i < categories.length; ++i) {
            String category = categories[i];
            if (VALID_ONLY_SHOW_IN.contains(category)) continue;
            throw new BuildException(category + " is not a valid NotShowIn category!");
        }
        this._entries.put("NotShowIn", notShowIn);
    }

    public void setTryExec(String tryExec) {
        this._entries.put("TryExec", tryExec);
    }

    public void setExec(String exec) {
        this._entries.put("Exec", exec);
    }

    public void setPath(String path) {
        this._entries.put("Path", path);
    }

    public void setTerminal(boolean terminal) {
        this._entries.put("Terminal", terminal ? "true" : "false");
    }

    public void setMimeType(String mimeType) {
        this._entries.put("MimeType", mimeType);
    }

    public void setCategories(String categories) {
        this.validateCategories(categories);
        this._entries.put("Categories", categories);
    }

    public void setUrl(String url) {
        this._entries.put("URL", url);
    }

    public void addName(Name name) {
        this._localizedEntries.add(name);
    }

    public void addGenericName(GenericName genericName) {
        this._localizedEntries.add(genericName);
    }

    public void addComment(Comment comment) {
        this._localizedEntries.add(comment);
    }

    public void addIcon(Icon icon) {
        this._localizedEntries.add(icon);
    }

    public void init() throws BuildException {
        this._entries = new LinkedHashMap();
        this._entries.put("Version", "1.0");
        this._entries.put("Type", "Application");
        this._entries.put("Terminal", "false");
        try {
            InputStream categoriesStream = ((Object)((Object)this)).getClass().getResourceAsStream("DesktopEntryCategories.properties");
            this._categories.load(categoriesStream);
            this.log("Loaded " + this._categories.size() + " properties from DesktopEntryCategories", 3);
            InputStream keysStream = ((Object)((Object)this)).getClass().getResourceAsStream("DesktopEntryKeys.properties");
            this._keys.load(keysStream);
            this.log("Loaded " + this._keys.size() + " properties from DesktopEntryKeys", 3);
        }
        catch (Exception e) {
            throw new BuildException("Cannot load properties file!", (Throwable)e);
        }
    }

    public void execute() throws BuildException {
        try {
            this.log("Generating desktop entry to: " + this._toFile.getAbsolutePath());
            for (int i = 0; i < this._localizedEntries.size(); ++i) {
                LocalizedEntry localizedEntry = (LocalizedEntry)this._localizedEntries.get(i);
                this._entries.put(localizedEntry.toString(), localizedEntry.getValue());
            }
            this.validateKeys();
            UnixPrintWriter out = new UnixPrintWriter(this._toFile);
            out.println("[Desktop Entry]");
            Iterator keys = this._entries.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)this._entries.get(key);
                out.print(key);
                out.print('=');
                out.println(value);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void validateCategories(String categories) {
        int mainCnt = 0;
        HashSet<String> categorySet = new HashSet<String>(Arrays.asList(categories.split(";")));
        Iterator iterator = categorySet.iterator();
        while (iterator.hasNext()) {
            String require;
            String category = (String)iterator.next();
            String type = this._categories.getProperty("category." + category);
            if (type == null) {
                throw new BuildException("Unknown category: " + category);
            }
            if ("main".equals(type)) {
                ++mainCnt;
            }
            if ((require = this._categories.getProperty("category." + category + ".require")) != null) {
                if (categorySet.contains(require)) continue;
                throw new BuildException("Category " + category + " also requires " + require);
            }
            require = this._categories.getProperty("category." + category + ".require.and");
            if (require != null) {
                String[] requireAnd = require.split(";");
                for (int j = 0; j < requireAnd.length; ++j) {
                    if (categorySet.contains(requireAnd[j])) continue;
                    throw new BuildException("Category " + category + " also requires " + requireAnd[j]);
                }
                continue;
            }
            require = this._categories.getProperty("category." + category + ".require.or");
            if (require == null) continue;
            boolean found = false;
            String[] requireOr = require.split(";");
            for (int j = 0; j < requireOr.length; ++j) {
                if (!categorySet.contains(requireOr[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new BuildException("Category " + category + " also requires one of " + require);
        }
        if (mainCnt == 0) {
            throw new BuildException("At least one main category should be specified!");
        }
        if (mainCnt > 1) {
            this.log("Multiple main categories specified, the entry may appear under multiple menus!");
        }
    }

    private void validateKeys() {
        String type = (String)this._entries.get("Type");
        Iterator keys = this._entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if ("Type".equals(key)) continue;
            int idxSquare = key.indexOf(91);
            if (idxSquare != -1) {
                String baseKey = key.substring(0, idxSquare);
                if (this._entries.containsKey(baseKey)) continue;
                throw new BuildException("Unlocalized key " + baseKey + " also needed for " + key);
            }
            boolean found = false;
            String[] typeArr = this._keys.getProperty("key." + key).split(",");
            for (int i = 0; i < typeArr.length; ++i) {
                String allowedType = typeArr[i];
                if (!type.equals(allowedType)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new BuildException("Key " + key + " not allowed for desktop entry of type " + type);
        }
        Iterator<Object> propertyKeys = this._keys.keySet().iterator();
        block2: while (propertyKeys.hasNext()) {
            String property = (String)propertyKeys.next();
            if (!property.endsWith(".required")) continue;
            String[] requiredTypeArr = this._keys.getProperty(property).split(",");
            for (int i = 0; i < requiredTypeArr.length; ++i) {
                String requiredType = requiredTypeArr[i];
                if (!type.equals(requiredType)) continue;
                String key = property.substring(4, property.length() - 9);
                if (this._entries.containsKey(key)) continue block2;
                throw new BuildException("Key " + key + " is required for desktop entries of type " + type);
            }
        }
    }

    public static class Type
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"Application", "Link", "Directory"};
        }
    }

    public static class Icon
    extends LocalizedEntry {
        public Icon() {
            super("Icon");
        }
    }

    public static class Comment
    extends LocalizedEntry {
        public Comment() {
            super("Comment");
        }
    }

    public static class GenericName
    extends LocalizedEntry {
        public GenericName() {
            super("GenericName");
        }
    }

    public static class Name
    extends LocalizedEntry {
        public Name() {
            super("Name");
        }
    }

    public static class LocalizedEntry {
        private String _key;
        private String _lang;
        private String _country;
        private String _encoding;
        private String _modifier;
        private String _value;

        public LocalizedEntry(String key) {
            this._key = key;
        }

        public void setLang(String lang) {
            this._lang = lang;
        }

        public void setCountry(String country) {
            this._country = country;
        }

        public void setEncoding(String encoding) {
            this._encoding = encoding;
        }

        public void setModifier(String modifier) {
            this._modifier = modifier;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this._key);
            if (this._lang != null) {
                buffer.append('[');
                buffer.append(this._lang.toLowerCase());
                if (this._country != null) {
                    buffer.append('_');
                    buffer.append(this._country.toUpperCase());
                }
                if (this._encoding != null) {
                    buffer.append('.');
                    buffer.append(this._encoding);
                }
                if (this._modifier != null) {
                    buffer.append('@');
                    buffer.append(this._modifier);
                }
                buffer.append(']');
            }
            return buffer.toString();
        }

        public String getValue() {
            return this._value;
        }
    }
}

