/******************************************************************************
 ** $Id$
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;

import javax.swing.JOptionPane;

/** Suche nach neuerer Version auf Homepage. */
class Update {

    /** Download-URL von dem JaFuffy Web-Auftritt. */
    private static final String DOWNLOAD = "http://jafuffy.3kelvin.de/download.html";
    /** Link, wo die Information zur neuesten Version von JaFuffy abliegt. */
    private static final URL LATEST;
    static {
        URL latest = null;
        try {
            latest = new URL("http://jafuffy.3kelvin.de/jafuffy.mf");
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        LATEST = latest;
    }

    /** Fenster, in der Meldungen zentriert werden sollen. */
    private final Fenster fenster;
    /**
     * Falls wahr, erfolgt kein Hinweis, wenn es keinen neueren Stand gibt. Gleichzeitig werden
     * Internetverbindungsfehler nur auf Standardausgabe ausgegeben und sonst nicht weiter
     * gemeldet.
     */
    private boolean mitteilen = false;

    /**
     * Konstruktor.
     * 
     * @param fenster
     *            Umgebungsfenster, in dem der Nachfragedialog zentriert wird.
     */
    Update(Fenster fenster) {
        this.fenster = fenster;
    }

    /**
     * berprft auf neuere Version, gibt Hinweise und fragt nach, ob auf die Downloadseite
     * gegangen werden soll.
     */
    public void ueberpruefe() {
        String installiert = Package.getPackage("jafuffy").getImplementationVersion();
        String neueste = ermittleLetzteVersion();
        if (neueste != null) {
            if (installiert != null && neueste.compareTo(installiert) <= 0) {
                if (mitteilen) {
                    JOptionPane.showMessageDialog(fenster,
                            "Keine neuere Version auf der JaFuffy-Homepage vorhanden,\n"
                                    + "keine Aktion notwendig.", "JaFuffy (Hinweis)",
                            JOptionPane.INFORMATION_MESSAGE);
                }
            } else if (JOptionPane.showConfirmDialog(fenster,
                    "Neuere Version gefunden auf der JaFuffy-Homepage,\n"
                            + "zur Downloadseite gehen?", "JaFuffy (Frage)",
                    JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                try {
                    Desktop.getDesktop().browse(new URI(DOWNLOAD));
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /**
     * Schaut auf JaFuffy-Homepage nach neuester Version.
     *
     * @return Versionsstring (Nullreferenz, wenn keine Version ermittelt werden kann)
     */
    private String ermittleLetzteVersion() {
        String titel = new String();
        String version = null;
        Scanner in;

        // "jafuffy.mf" im Web ffnen und parsen
        try {
            in = new Scanner(new BufferedReader(new InputStreamReader(LATEST.openStream())));
            String token;
            while (in.hasNext()) {
                token = in.next();
                if (token.equals("Implementation-Version:")) {
                    version = in.nextLine().trim();
                } else if (token.equals("Implementation-Title:")) {
                    titel = in.next();
                }
            }
            in.close();
        } catch (Exception e) {
            e.printStackTrace();
            Signal.ALARM.play();
            JOptionPane
                    .showMessageDialog(
                            fenster,
                            "Kann keine Information von der JaFuffy-Homepage holen:\n"
                                    + e
                                    + "\n(Die Suche bei Programmstart kann im Men \"Einstellungen\" unterbunden werden.)",
                            "JaFuffy (Fehler)", JOptionPane.ERROR_MESSAGE);
            return null;
        }

        // Version nur zurckgeben, falls Titel auch stimmt
        return titel.equals("JaFuffy") ? version : null;
    }

    /** Neue Stnde und Fehler ab sofort jetzt auch dem Benutzer mitteilen. */
    void aktiviereMitteilung() {
        mitteilen = true;
    }
}
