/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.CEAblauf;
import jafuffy.CEJaFuffy;
import jafuffy.Eigenschaften;
import jafuffy.Menue;
import jafuffy.Oberflaeche;
import jafuffy.Spielplatz;
import jafuffy.Turnier;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Fenster
extends JFrame
implements ChangeListener,
PropertyChangeListener {
    private static final int RAHMENABSTAND = 4;
    private boolean initialisiert = false;
    private int spielerzahl;

    Fenster(String titel) {
        super(titel);
        this.setDefaultCloseOperation(3);
        this.setIconImages(Oberflaeche.LOGOS);
        UIManager.addPropertyChangeListener(this);
        this.spielerzahl = 0;
        int i = 0;
        while (i < 4) {
            if (!Eigenschaften.GLOBAL.getProperty("Spieler" + i, "").equals("")) {
                ++this.spielerzahl;
            }
            ++i;
        }
    }

    void zeige(Eigenschaften eigenschaften, Menue menue, Spielplatz spielplatz) {
        this.setJMenuBar(menue);
        spielplatz.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setContentPane(spielplatz);
        if (eigenschaften.erststart()) {
            this.setLocationRelativeTo(null);
            this.pack();
        } else {
            this.setBounds(Integer.parseInt(eigenschaften.getProperty("X")), Integer.parseInt(eigenschaften.getProperty("Y")), Integer.parseInt(eigenschaften.getProperty("Breite")), Integer.parseInt(eigenschaften.getProperty("Hoehe")));
        }
        this.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch ((CEAblauf)((Object)CEJaFuffy.ereignis(ce))) {
                case START: {
                    Turnier turnier = (Turnier)ce.getSource();
                    this.setTitle("JaFuffy (" + turnier.auswertung() + ")");
                    if (turnier.spieler().size() == this.spielerzahl) break;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Fenster.this.pack();
                        }
                    });
                    this.spielerzahl = turnier.spieler().size();
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.initialisiert) {
            SwingUtilities.updateComponentTreeUI(this);
            if (event.getOldValue().getClass() != event.getNewValue().getClass() && JOptionPane.showConfirmDialog(this, "Fenstergr\u00f6\u00dfe an Look & Feel anpassen?", "JaFuffy (Frage)", 0) == 0) {
                this.pack();
            }
        } else {
            this.initialisiert = true;
        }
    }
}

