/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Aenderungen;
import jafuffy.Analyse;
import jafuffy.CEAblauf;
import jafuffy.Eigenschaften;
import jafuffy.Spieler;
import jafuffy.Tabzeile;
import jafuffy.Variante;
import jafuffy.Wuerfel;
import java.lang.reflect.Constructor;

abstract class Auswertung
extends Aenderungen<CEAblauf> {
    private static final long serialVersionUID = -7315969783651586016L;
    private boolean tipps;
    final Wuerfel[] wuerfel;
    Analyse analyse;
    Spieler spieler;
    final Variante variante;

    static Constructor<? extends Auswertung> auswertungskonstruktor(Class<? extends Auswertung> klasse) {
        try {
            return klasse.getConstructor(Variante.class, Wuerfel[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Auswertung(Variante variante, Wuerfel[] wuerfel) {
        this.variante = variante;
        this.wuerfel = wuerfel;
        this.analyse = new Analyse(wuerfel);
    }

    public abstract String toString();

    void gewuerfelt(Spieler spieler) {
        this.spieler = spieler;
        this.tipps = false;
        this.analyse.errechne();
    }

    void tipps(boolean tipps) {
        if (tipps) {
            if (!this.tipps) {
                this.analyse.prognostiziere(this.spieler);
                this.tipps = true;
            }
        } else {
            this.tipps = false;
        }
    }

    boolean tipps() {
        return this.tipps;
    }

    boolean vorgeschlagen(Tabzeile eintrag) {
        return this.analyse.vorgeschlagen(eintrag);
    }

    boolean bester(Tabzeile eintrag) {
        return this.analyse.bester() == eintrag;
    }

    abstract int mittelwert();

    abstract int abweichung();

    abstract int wert(Tabzeile var1);

    abstract String text(Tabzeile var1);

    String spicker(Tabzeile eintrag) {
        String text;
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.spieler.gewuerfelt() && this.spieler.setzbar(eintrag) && eintrag.alle()) {
            int punkte = this.wert(eintrag);
            text = String.valueOf(new Integer(punkte).toString()) + (punkte != 1 ? " Punkte" : " Punkt");
            if (this.tipps()) {
                text = "<html><p>" + text + "</p>" + "<p><small><i>Siehe auch Kontextmen\u00fc!</i></small></p>" + "<p><small><i>Beachte Men\u00fc \"Extras\".</i></small></p>" + "</html>";
            }
        } else {
            text = null;
        }
        return text;
    }

    float wichtung(Tabzeile eintrag) {
        return this.analyse.wichtung(eintrag);
    }

    void vorschlagen(Tabzeile eintrag) {
        int w = 0;
        while (w < 5) {
            this.wuerfel[w].setzeVorschlag(this.analyse.erneut(eintrag, w));
            ++w;
        }
        this.fireStateChanged(CEAblauf.VORSCHLAGEN);
    }

    void vorschlagen() {
        this.tipps(true);
        this.vorschlagen(this.analyse.bester());
    }
}

