/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Auswertung;
import jafuffy.Eigenschaften;
import jafuffy.Geraeusch;
import jafuffy.Tabelle;
import jafuffy.Tabzeile;
import jafuffy.Turnier;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

abstract class Auswahl
extends DefaultCellEditor {
    static final Geraeusch HURRA = new Geraeusch("Hurra.wav");
    static final NumberFormat NF = NumberFormat.getInstance(Locale.GERMAN);
    Turnier turnier;
    Auswertung auswertung;
    int clicks;
    Tabzeile eintrag;
    private JButton setzen;
    Tabelle tabelle;

    static {
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(2);
    }

    static Constructor<? extends Auswahl> auswahlkonstruktor(Class<? extends Auswahl> klasse) {
        try {
            return klasse.getConstructor(Turnier.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Auswahl(Turnier turnier) {
        super(new JCheckBox());
        this.turnier = turnier;
        this.auswertung = turnier.auswertung();
        this.setClickCountToStart(1);
        this.setzen = new JButton("setzen");
        this.setzen.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.setzen.setFocusPainted(false);
        this.setzen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Auswahl.this.geklickt();
            }
        });
    }

    public void doClick() {
        this.setzen.doClick();
        if (!Eigenschaften.GLOBAL.aktiv("Einfachklick")) {
            this.setzen.doClick();
        }
    }

    void eintrag(Tabzeile eintrag) {
        this.eintrag = eintrag;
        this.clicks = 0;
        this.editorComponent = this.setzen;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.eintrag(Tabzeile.eintrag(row));
        this.tabelle = (Tabelle)table;
        this.aktualisieren();
        return this.editorComponent;
    }

    abstract void geklickt();

    void gewuerfelt() {
        this.aktualisieren();
    }

    private void aktualisieren() {
        if (this.eintrag != null) {
            this.fireEditingCanceled();
            String text = "1 Klick = " + this.auswertung.wert(this.eintrag) + " Punkte";
            if (this.auswertung.tipps()) {
                text = "<html><p>" + text + "</p>" + "<p>Endstandwertung " + NF.format(this.auswertung.wichtung(this.eintrag)) + "</p></html>";
            }
            this.editorComponent.setToolTipText(text);
        }
    }
}

