/******************************************************************************
 ** $Id: Menue.java 700 2015-02-08 21:00:42Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/

package jafuffy;

import java.awt.CardLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UIManager.LookAndFeelInfo;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * Erzeugung der Menzeile und Einrichtung der Ereignislauscher der Meneintrge.
 */
@SuppressWarnings("serial")
class Menue extends JMenuBar implements PropertyChangeListener, ChangeListener {

    /** Wechseln von Eigenschaften. */
    private class Wechsel implements ActionListener {
        private final String schluessel;

        Wechsel(String schluessel) {
            this.schluessel = schluessel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Eigenschaften.GLOBAL.wechsle(schluessel);
        }

        boolean aktiv() {
            return Eigenschaften.GLOBAL.aktiv(schluessel);
        }
    }

    /** Fehlermeldung fr Applet. */
    private static final String APPLET = "<html>" + "<p>Steht nicht zur Verfgung</p>"
            + "<p>(<i>JaFuffy</i> wurde als Applet gestartet)</p>" + "</html>";

    private final Spielplatz spielplatz;
    private final Absprache absprache;
    private final Report report;
    private final Bestenliste bestenliste;
    private final Fortsetzung fortsetzung;
    private final Ende ende;
    private final Update update;

    private final Info info = new Info();
    private final Lizenzierung lizenzierung = new Lizenzierung();

    private final JMenuItem speichern = new JMenuItem("Speichern");
    private final JMenuItem speichernUnter = new JMenuItem("Speichern unter...");
    private final JMenuItem berichten = new JMenuItem("Report");
    private final JMenuItem rueckgaengig = new JMenuItem("Rckgngig");
    private final JMenuItem setzen = new JMenuItem("Vorschlag setzen");
    private final JMenuItem beenden = new JMenuItem("Beenden");
    private final JMenuItem vorschlagen = new JMenuItem("Vorschlagen");

    /** Im Spielbetrieb oder noch Intro? */
    private boolean betrieb = false;

    /**
     * Konstruktor.
     *
     * @param oberflaeche
     * @param spielplatz
     * @param absprache
     * @param report
     * @param bestenliste
     * @param fortsetzung
     * @param ende
     * @param update
     */
    Menue(Oberflaeche oberflaeche, Spielplatz spielplatz, Absprache absprache, Report report,
            Bestenliste bestenliste, Fortsetzung fortsetzung, Ende ende, Update update) {
        this.spielplatz = spielplatz;
        this.absprache = absprache;
        this.report = report;
        this.bestenliste = bestenliste;
        this.fortsetzung = fortsetzung;
        this.ende = ende;
        this.update = update;

        UIManager.addPropertyChangeListener(this);

        if (fortsetzung != null) {
            fortsetzung.speichere(speichern);
        }

        erzeugeTurniermenue();
        erzeugeStatistikmenue();
        erzeugeExtrasmenue();
        erzeugeEinstellungenmenue(oberflaeche);
        erzeugeHilfemenue();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            Turnier turnier = (Turnier) ce.getSource();
            switch (CEJaFuffy.<CEAblauf> ereignis(ce)) {
            case START:
                meldeTurnierAn(turnier);
                break;
            case RESULTAT:
                vorschlagen.setEnabled(false);
                setzen.setEnabled(false);
                rueckgaengig.setEnabled(false);
                break;
            case ABBRUCH:
            case ENDE:
                meldeTurnierAb(turnier);
                break;
            case RUECKGAENGIG:
            case GEWUERFELT:
                vorschlagen.setEnabled(true);
                setzen.setEnabled(false);
                rueckgaengig.setEnabled(false);
                break;
            case GESETZT:
                vorschlagen.setEnabled(false);
                setzen.setEnabled(false);
                rueckgaengig.setEnabled(true);
                break;
            default:
                break;
            }
        }
    }

    /** @return Ist JaFuffy als Applikation gestartet worden? */
    private boolean applikation() {
        return ende != null;
    }

    /**
     * @param oberflaeche
     *            Eigenschaften der Benutzeroberflche.
     */
    private void erzeugeEinstellungenmenue(Oberflaeche oberflaeche) {
        JMenu menu = new JMenu("Einstellungen");
        menu.setMnemonic('E');
        add(menu);

        JMenu subMenu;
        JMenuItem menuItem;

        // Einfachklick
        menuItem = menu.add(new JCheckBoxMenuItem("Setzen durch Einfachklick"));
        menuItem.setToolTipText("<html>" + "Wahl zwischen einmaligem und zweimaligem Klicken"
                + "<br>" + "zum Setzen des Wurfs in der Tabelle" + "</html>");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Einfachklick"));
        menuItem.addActionListener(new Wechsel("Einfachklick"));
        //
        menu.addSeparator();
        //
        // Zwischenstand anzeigen
        menuItem = menu.add(new JCheckBoxMenuItem("Zwischenstandsanzeige"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Z, 0));
        menuItem.setToolTipText("<html>" + "Die Punktezahl des derzeitigen Wurfs" + "<br>"
                + "fr jeden freien Tabellenplatz anzeigen?" + "</html>");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Zwischenstand"));
        menuItem.addActionListener(new Wechsel("Zwischenstand"));
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.spielplatz.repaint();
            }
        });
        // Nachfragen
        subMenu = new JMenu("Meldungen");
        subMenu.setToolTipText("Meldungen ein/ausschalten bei...");
        menu.add(subMenu);
        menuItem = subMenu.add(new JCheckBoxMenuItem("Hinweise"));
        menuItem.setToolTipText("Allgemeine Hinweise (\"ToolTips\" in Ksten) anzeigen?");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Hinweis"));
        ToolTipManager.sharedInstance().setEnabled(Eigenschaften.GLOBAL.aktiv("Hinweis"));
        menuItem.addActionListener(new Wechsel("Hinweis") {
            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                ToolTipManager.sharedInstance().setEnabled(aktiv());
            }
        });
        menuItem = subMenu.add(new JCheckBoxMenuItem("Spicker"));
        menuItem.setToolTipText("Spicker fr Wrfelpunkte in Tabelle?");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Spicker"));
        menuItem.addActionListener(new Wechsel("Spicker"));
        menuItem = subMenu.add(new JCheckBoxMenuItem("Erinnerung abgebrochenes Turnier"));
        if (applikation()) {
            menuItem.setToolTipText("Erinnerung an abgebrochenes Turnier zum Weiterspielen?");
            menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Erinnerung"));
            menuItem.addActionListener(new Wechsel("Erinnerung"));
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
        // Effekte
        subMenu = new JMenu("Effekte");
        subMenu.setToolTipText("Grafik- und Toneffekte");
        menu.add(subMenu);
        menuItem = subMenu.add(new JCheckBoxMenuItem("Eingangsgrafik"));
        menuItem.setToolTipText("Eingangsgrafik ein/ausschalten");
        menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Intro"));
        menuItem.addActionListener(new Wechsel("Intro") {
            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                if (!betrieb) {
                    ((CardLayout) Menue.this.spielplatz.getLayout())
                            .show(Menue.this.spielplatz, aktiv() ? Spielplatz.INTRO
                                    : Spielplatz.TEXT);
                }
            }
        });
        menuItem = subMenu.add(new JCheckBoxMenuItem("Gerusche"));
        menuItem.setEnabled(Ressource.soundsystem());
        menuItem.setToolTipText("Gerusche ein/ausschalten");
        menuItem.setSelected(Ressource.soundsystem()
                && Eigenschaften.GLOBAL.aktiv("Geraeusche"));
        menuItem.addActionListener(new Wechsel("Geraeusche"));
        // Look & Feel
        subMenu = new JMenu("Look and Feel");
        subMenu.setToolTipText("<html>"
                + "<p>Look & Feel der Benutzeroberflche.</p>"
                + "<p>Je nach Auswahl kann ein Neustart erforderlich sein, siehe Extras-Men.</p>"
                + "</html>");
        menu.add(subMenu);
        ButtonGroup oberflaechengruppe = new ButtonGroup();
        for (LookAndFeelInfo laf : lafs()) {
            menuItem = new JRadioButtonMenuItem(laf.getName());
            menuItem.setSelected(Eigenschaften.GLOBAL.getProperty("LookAndFeel").equals(
                    laf.getClassName()));
            menuItem.putClientProperty("laf", laf.getClassName());
            menuItem.addActionListener(oberflaeche);
            subMenu.add(menuItem);
            oberflaechengruppe.add(menuItem);
        }
        //
        menu.addSeparator();
        //
        // Pfad zu Turnierstnden
        menuItem = menu.add(new JMenuItem("Pfad..."));
        if (applikation()) {
            menuItem.setToolTipText("<html>"
                    + "<p>Pfad zu Statistikdaten und Turnierstnden einstellen.</p>"
                    + "<p>Aktuelle Einstellung: " + "<strong>" + Pfad.pfad() + "</strong></p>"
                    + "</html>");
            menuItem.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    new Pfad(Menue.this.spielplatz);
                }
            });
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
        //
        menu.addSeparator();
        //
        // Nach neueren Versionen suchen
        menuItem = menu.add(new JCheckBoxMenuItem("Nach neuerer Version schauen"));
        menuItem.setToolTipText("<html>Bei jedem Programmstart automatisch "
                + "nach neuerer Version auf <i>JaFuffy</i>-Homepage suchen<html>");
        if (applikation()) {
            menuItem.setSelected(Eigenschaften.GLOBAL.aktiv("Nachschauen"));
            menuItem.addActionListener(new Wechsel("Nachschauen"));
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
    }

    /** Erzeugung eines Mens. */
    private void erzeugeExtrasmenue() {
        JMenu menu = new JMenu("Extras");
        menu.setMnemonic('X');
        add(menu);

        JMenuItem menuItem;

        menu.add(rueckgaengig);
        rueckgaengig.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, 0));
        rueckgaengig.setActionCommand("Rueckgaengig");
        rueckgaengig.setEnabled(false);
        rueckgaengig.setToolTipText("Letztes Setzen rckgngig machen");
        menu.add(setzen);
        setzen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, 0));
        setzen.setActionCommand("Setzen");
        setzen.setEnabled(false);
        setzen.setToolTipText("Besten Vorschlag direkt in Tabelle setzen");
        //
        menu.addSeparator();
        //
        menuItem = menu.add(new JMenuItem("Fenster anpassen"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, 0));
        if (applikation()) {
            menuItem.setToolTipText("Fenstergre optimal anpassen "
                    + "an Tabelle, Wrfelfeld und Look & Feel");
            menuItem.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable() {
                        @Override
                        public void run() {
                            Window umgebung = SwingUtilities.getWindowAncestor(Menue.this);
                            umgebung.pack();
                        }
                    });
                }
            });
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
        //
        menu.addSeparator();
        //
        menuItem = menu.add(new JMenuItem("Neu zeichnen"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, 0));
        menuItem.setToolTipText("Alles neu zeichnen zur Beseitigung von Darstellungsfehlern");
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.spielplatz.repaint();
            }
        });
        menuItem = menu.add(new JMenuItem("Neustart"));
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent event) {
                Eigenschaften.GLOBAL.merkeNeustartAnforderung(betrieb);
                beenden.doClick();
            }
        });
        if (applikation()) {
            menuItem.setToolTipText("<html>"
                    + "<p>Neustart durchfhren mit automatischer Turnierfortsetzung.</p>"
                    + "<p>Hilfreich weil Look&Feel-Wechsel nicht immer funktionieren.</p>"
                    + "</html>");
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
    }

    /** Erzeugung eines Mens. */
    private void erzeugeHilfemenue() {
        JMenu menu = new JMenu("Hilfe");
        menu.setMnemonic('H');
        add(menu);

        JMenuItem menuItem;

        menu.add(vorschlagen);
        vorschlagen.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, 0));
        vorschlagen.setEnabled(false);
        vorschlagen.setToolTipText("<html>" + "<p><br>" + "<p>Gibt Tipps zum Setzen des Wurfs:"
                + "<ul>" + "<li>Zeigt Wrfelvorauswahl des besten Vorschlags.</li>"
                + "<li>Bester Vorschlag ist durch orange Schrift gekennzeichnet.</li>"
                + "<li>Stimmt der Vorschlag zu einem Feld mit der Wrfelauswahl berein,"
                + "<br>" + "so ist das Feld umrahmt.</li>" + "</ul>" + "</p>"
                + "<p>ndert der Spieler die Auswahl, werden die Umrahmungen angepasst.</p>"
                + "<br>" + "<p><i>Siehe auch das Kontextmen der Tabellenfelder.</i></p>"
                + "</html>");
        vorschlagen.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setzen.setEnabled(true);
            }
        });
        //
        menu.addSeparator();
        //
        menuItem = menu.add(new JMenuItem("Hilfethemen"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H, 0));
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Hilfe hilfe = new Hilfe();
                    hilfe.setLocationRelativeTo(Menue.this.spielplatz);
                    hilfe.setVisible(true);
                } catch (Exception ee) {
                    ee.printStackTrace();
                    Signal.WARNUNG.play();
                    JOptionPane.showMessageDialog(Menue.this.spielplatz,
                            "Hilfetexte knnen nicht angezeigt werden!\n"
                                    + "Fehlerhafte oder fehlende HTML-Dateien?\n",
                            "JaFuffy (Warnung)", JOptionPane.WARNING_MESSAGE);
                }
            }
        });
        //
        menu.addSeparator();
        //
        // ber JaFuffy
        menuItem = menu.add(new JMenuItem("<html>ber <i>JaFuffy</i></html>"));
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                info.setLocationRelativeTo(Menue.this.spielplatz);
                info.setVisible(true);
            }
        });
        // Lizenzierung
        menuItem = menu.add(new JMenuItem("Lizenzierung"));
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                lizenzierung.setLocationRelativeTo(Menue.this.spielplatz);
                lizenzierung.setVisible(true);
            }
        });
        //
        menu.addSeparator();
        //
        // Aktualisieren
        menuItem = menu.add(new JMenuItem("Aktualisieren..."));
        if (applikation()) {
            menuItem.setToolTipText("<html>"
                    + "Sucht auf der <i>JaFuffy</i>-Homepage nach neuerer Version" + "<html>");
            menuItem.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.update.ueberpruefe();
                }
            });
        } else {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        }
    }

    /** Erzeugung eines Mens. */
    private void erzeugeStatistikmenue() {
        JMenu menu = new JMenu("Statistik");
        menu.setMnemonic('S');
        add(menu);

        JMenuItem menuItem;

        menu.add(berichten);
        berichten.setToolTipText("(Zischen)Stand & Turnierverlauf");
        berichten.setEnabled(false);
        berichten.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.report.setLocationRelativeTo(Menue.this.spielplatz);
                Menue.this.report.setVisible(true);
            }
        });
        menuItem = menu.add(new JMenuItem("Bestenliste"));
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.bestenliste.setLocationRelativeTo(Menue.this.spielplatz);
                Menue.this.bestenliste.setVisible(true);
            }
        });
    }

    /** Erzeugung eines Mens. */
    private void erzeugeTurniermenue() {
        JMenu menu = new JMenu("Turnier");
        menu.setMnemonic('T');
        add(menu);

        JMenuItem menuItem;

        menuItem = menu.add(new JMenuItem("Beginnen..."));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_B, 0));
        menuItem.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Menue.this.absprache.setLocationRelativeTo(Menue.this.spielplatz);
                Menue.this.absprache.setVisible(true);
                // Wartet auf Abbruch/OK! OK started Turnier.
            }
        });
        //
        menu.addSeparator();
        //
        menu.add(speichern);
        speichern.setEnabled(false);
        speichern.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, 0));
        if (fortsetzung == null) {
            speichern.setToolTipText(APPLET);
        } else {
            speichern.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.fortsetzung.setLocationRelativeTo(Menue.this.spielplatz);
                    Menue.this.fortsetzung.speichere();
                }
            });
        }
        menu.add(speichernUnter);
        speichernUnter.setEnabled(false);
        if (fortsetzung == null) {
            speichernUnter.setToolTipText(APPLET);
        } else {
            speichernUnter.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.fortsetzung.setLocationRelativeTo(Menue.this.spielplatz);
                    Menue.this.fortsetzung.speichereUnter();
                    Menue.this.fortsetzung.setVisible(true);
                }
            });
        }
        menuItem = menu.add(new JMenuItem("Fortsetzen..."));
        if (fortsetzung == null) {
            menuItem.setEnabled(false);
            menuItem.setToolTipText(APPLET);
        } else {
            menuItem.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Menue.this.fortsetzung.setLocationRelativeTo(Menue.this.spielplatz);
                    Menue.this.fortsetzung.setzeFort();
                    Menue.this.fortsetzung.setVisible(true);
                }
            });
        }
        //
        menu.addSeparator();
        //
        menu.add(beenden);
        if (applikation()) {
            beenden.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    Window umgebung = SwingUtilities.getWindowAncestor(Menue.this);
                    WindowEvent ereignis =
                            new WindowEvent(umgebung, WindowEvent.WINDOW_CLOSING);
                    umgebung.dispatchEvent(ereignis);
                }
            });
        } else {
            beenden.setEnabled(false);
            beenden.setToolTipText(APPLET);
        }
    }

    /** @return Eine alphabetisch sortierte Liste aller Look & Feel. */
    private List<LookAndFeelInfo> lafs() {
        List<LookAndFeelInfo> lafs = Arrays.asList(UIManager.getInstalledLookAndFeels());
        Collections.sort(lafs, new Comparator<LookAndFeelInfo>() {
            @Override
            public int compare(LookAndFeelInfo laf1, LookAndFeelInfo laf2) {

                return laf1.getName().compareToIgnoreCase(laf2.getName());
            }
        });
        return lafs;
    }

    /**
     * Turnier abmelden.
     *
     * @param turnier
     *            Abzumeldendes Turnier.
     */
    private void meldeTurnierAb(Turnier turnier) {
        setzen.removeActionListener(turnier);
        setzen.setEnabled(false);
        vorschlagen.removeActionListener(turnier);
        vorschlagen.setEnabled(false);
        rueckgaengig.removeActionListener(turnier);
        rueckgaengig.setEnabled(false);
    }

    /**
     * Turnier anmelden.
     *
     * @param turnier
     *            Anzumeldendes Turnier.
     */
    private void meldeTurnierAn(Turnier turnier) {
        // Spielbetrieb aufgenommen
        betrieb = true;
        // Meneintrge (de)aktivieren, ActionListener eintragen
        speichern.setEnabled(false);
        speichernUnter.setEnabled(applikation());
        berichten.setEnabled(true);
        rueckgaengig.addActionListener(turnier);
        rueckgaengig.setEnabled(false);
        vorschlagen.addActionListener(turnier);
        vorschlagen.setEnabled(turnier.aktiver().gewuerfelt());
        setzen.addActionListener(turnier);
        setzen.setEnabled(false);
    }

}
