/******************************************************************************
 ** $Id: Fenster.java 687 2015-02-04 02:06:39Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/** Hauptfenster von JaFuffy, falls als Applikation gestartet. */
@SuppressWarnings("serial")
class Fenster extends JFrame implements ChangeListener {

    /** Abstand vom Fensterrahmen zum Inhalt. */
    private static final int RAHMENABSTAND = 4;
    /** Anzahl aller Mitspieler. */
    private int spielerzahl;

    /**
     * Konstruktor.
     *
     * @param titel
     *            Fenstertitel
     */
    Fenster(String titel) {
        super(titel);
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        setIconImages(Oberflaeche.LOGOS);

        // Zhlen der Mitspieler wie in Voreinstellungen gegeben
        spielerzahl = 0;
        for (int i = 0; i < Spieler.SPIELER; i++) {
            if (!Eigenschaften.GLOBAL.getProperty("Spieler" + i, "").equals("")) {
                spielerzahl++;
            }
        }

    }

    /**
     * Fensterinhalt setzen, anschlieend Fenster packen und sichtbar machen.
     *
     * @param eigenschaften
     * @param menue
     * @param spielplatz
     * @param ende
     */
    void zeige(Eigenschaften eigenschaften, Menue menue, Spielplatz spielplatz, Ende ende) {
        setJMenuBar(menue);
        spielplatz.setBorder(new EmptyBorder(RAHMENABSTAND, RAHMENABSTAND, RAHMENABSTAND,
                RAHMENABSTAND));
        setContentPane(spielplatz);
        addWindowListener(ende);
        if (eigenschaften.erststart()) {
            setLocationRelativeTo(null);
            pack();
        } else {
            setBounds(Integer.parseInt(eigenschaften.getProperty("X")),
                    Integer.parseInt(eigenschaften.getProperty("Y")),
                    Integer.parseInt(eigenschaften.getProperty("Breite")),
                    Integer.parseInt(eigenschaften.getProperty("Hoehe")));
        }
        setVisible(true);
    }

    /**
     * ChangeEvent eingetreten.
     *
     * @param ce
     */
    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch (CEJaFuffy.<CEAblauf> ereignis(ce)) {
            case START:
                Turnier turnier = (Turnier) ce.getSource();
                setTitle("JaFuffy " + "(" + turnier.auswertung() + ")");
                if (turnier.spieler().size() != spielerzahl) {
                    SwingUtilities.invokeLater(new Runnable() {
                        @Override
                        public void run() {
                            pack();
                        }
                    });
                    spielerzahl = turnier.spieler().size();
                }
            default:
                break;
            }
        }
    }

}
