/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Aenderungen;
import jafuffy.BestenlisteModell;
import jafuffy.CEStatistik;
import jafuffy.Spieler;
import jafuffy.Variante;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;
import java.util.Locale;

class Statistik
extends Aenderungen<CEStatistik> {
    private static final long serialVersionUID = 3612572422999296411L;
    static final String STAT = "Statistik.obj";
    private static final int MAXRAENGE = 10;
    private transient int variante;
    private transient ArrayList<Spieler> spieler;
    private transient ArrayList<Rang> rangmerker;
    private transient int[] rueckgaengig;
    private transient int[] spielstand;
    private transient int anzahl;
    private transient int mittelwert;
    private transient int abweichung;
    private transient int[] turnierstand;
    private final ArrayList<Rang>[] ranglisten;
    private transient BestenlisteModell[] bestenlisteModelle;
    private transient ArrayList<Integer>[] verlauf;
    private final int[] n = new int[Variante.values().length];
    private final int[] summe = new int[Variante.values().length];
    private final long[] quadratsumme = new long[Variante.values().length];

    Statistik() {
        this.ranglisten = new ArrayList[Variante.values().length];
        int i = 0;
        while (i < Variante.values().length) {
            this.ranglisten[i] = new ArrayList(10);
            ++i;
        }
        this.bestenlistenmodelle();
    }

    void verfolgen(int variante, int anzahl, ArrayList<Spieler> spieler, int mittelwert, int abweichung, ArrayList<Integer>[] verlauf, int[] turnierstand) {
        this.initialisieren(variante, anzahl, spieler, mittelwert, abweichung);
        this.verlauf = verlauf;
        this.turnierstand = turnierstand;
        int i = 0;
        while (i < spieler.size()) {
            this.spielstand[i] = this.punkte(i);
            ++i;
        }
        this.fireStateChanged(CEStatistik.TURNIER_WEITER);
    }

    void verfolgen(int variante, int anzahl, ArrayList<Spieler> spieler, int mittelwert, int abweichung) {
        this.initialisieren(variante, anzahl, spieler, mittelwert, abweichung);
        this.verlauf = new ArrayList[spieler.size()];
        this.turnierstand = new int[spieler.size()];
        int i = 0;
        while (i < spieler.size()) {
            this.turnierstand[i] = 0;
            this.spielstand[i] = 0;
            this.verlauf[i] = new ArrayList();
            this.verlauf[i].add(new Integer(0));
            ++i;
        }
        this.fireStateChanged(CEStatistik.TURNIER_START);
    }

    void beendeRunde() {
        int s = 0;
        while (s < this.spieler.size()) {
            this.rueckgaengig[s] = this.spielstand[s];
            this.spielstand[s] = this.punkte(s);
            this.verlauf[s].set(this.verlauf[0].size() - 1, new Integer(this.spielstand[s]));
            ++s;
        }
        this.fireStateChanged(CEStatistik.STAND);
    }

    void rueckgaengig() {
        int s = 0;
        while (s < this.spieler.size()) {
            this.spielstand[s] = this.rueckgaengig[s];
            this.verlauf[s].set(this.verlauf[0].size() - 1, new Integer(this.spielstand[s]));
            ++s;
        }
        this.fireStateChanged(CEStatistik.STAND);
    }

    void beendeSpiel() {
        boolean aktualisieren = false;
        this.rangmerker = new ArrayList(this.spieler.size());
        int i = 0;
        while (i < this.spieler.size()) {
            int j = 0;
            boolean eingeordnet = false;
            int punkte = this.punkte(i);
            int n = i;
            this.turnierstand[n] = this.turnierstand[n] + punkte;
            this.spielstand[i] = 0;
            ListIterator<Rang> rangiterator = this.ranglisten[this.variante].listIterator();
            Rang rang = null;
            while (rangiterator.hasNext() && !eingeordnet) {
                j = rangiterator.nextIndex();
                rang = rangiterator.next();
                boolean bl = eingeordnet = rang.punkte <= punkte;
            }
            if (eingeordnet && rang.punkte < punkte) {
                if (this.ranglisten[this.variante].size() == 10) {
                    this.rangmerker.remove(this.ranglisten[this.variante].get(9));
                    this.ranglisten[this.variante].remove(9);
                }
                rang = new Rang();
                this.ranglisten[this.variante].add(j, rang);
            }
            if (!eingeordnet && this.ranglisten[this.variante].size() < 10) {
                rang = new Rang();
                this.ranglisten[this.variante].add(rang);
                eingeordnet = true;
            }
            if (eingeordnet) {
                aktualisieren = true;
                rang.anhaengen(this.spieler.get(i));
                this.rangmerker.add(rang);
            }
            ++i;
        }
        if (aktualisieren) {
            int rangnummer = 1;
            for (Rang r : this.ranglisten[this.variante]) {
                r.rangnummer(rangnummer);
                rangnummer += r.eintraege.size();
            }
            this.fireStateChanged(CEStatistik.BESTER);
        }
        for (Spieler s : this.spieler) {
            int ergebnis = s.endsumme();
            int n = this.variante;
            this.summe[n] = this.summe[n] + ergebnis;
            int n2 = this.variante;
            this.quadratsumme[n2] = this.quadratsumme[n2] + (long)(ergebnis * ergebnis);
        }
        int n = this.variante;
        this.n[n] = this.n[n] + this.spieler.size();
        ArrayList<Integer>[] arrayListArray = this.verlauf;
        int n3 = this.verlauf.length;
        int n4 = 0;
        while (n4 < n3) {
            ArrayList<Integer> v = arrayListArray[n4];
            v.add(new Integer(0));
            ++n4;
        }
        this.fireStateChanged(CEStatistik.SPIEL_ENDE);
    }

    int anzahl() {
        return this.anzahl;
    }

    int rest() {
        return this.anzahl - this.verlauf[0].size();
    }

    int variante() {
        return this.variante;
    }

    int mittelwert() {
        return this.mittelwert;
    }

    int abweichung() {
        return this.abweichung;
    }

    ArrayList<Rang> rangmerker() {
        return this.rangmerker;
    }

    ArrayList<Spieler> spieler() {
        return this.spieler;
    }

    BestenlisteModell[] bestenlisteModelle() {
        return this.bestenlisteModelle;
    }

    ArrayList<Integer>[] verlauf() {
        return this.verlauf;
    }

    int punkte(int s) {
        return this.spieler.get(s).endsumme();
    }

    int[] turnierstand() {
        return this.turnierstand;
    }

    int stand(int s) {
        return this.turnierstand[s] + this.spielstand[s];
    }

    int n(int i) {
        return this.n[i];
    }

    double durchschnitt(int i) {
        return (double)this.summe[i] / (double)this.n[i];
    }

    double standardabweichung(int i) {
        double qi = this.quadratsumme[i];
        double si = this.summe[i];
        int ni = this.n[i];
        return Math.sqrt((qi - si * si / (double)ni) / (double)(ni - 1));
    }

    private void initialisieren(int variante, int anzahl, ArrayList<Spieler> spieler, int mittelwert, int abweichung) {
        this.spieler = spieler;
        this.variante = variante;
        this.anzahl = anzahl;
        this.mittelwert = mittelwert;
        this.abweichung = abweichung;
        this.rueckgaengig = new int[spieler.size()];
        this.spielstand = new int[spieler.size()];
    }

    private void bestenlistenmodelle() {
        this.bestenlisteModelle = new BestenlisteModell[Variante.values().length];
        int i = 0;
        while (i < Variante.values().length) {
            this.bestenlisteModelle[i] = new BestenlisteModell(this.ranglisten[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.bestenlistenmodelle();
    }

    class Rang
    implements Serializable {
        private static final long serialVersionUID = 8690127540463640879L;
        private final ArrayList<Eintrag> eintraege = new ArrayList();
        private int punkte;
        private int rangnummer;

        Rang() {
        }

        void anhaengen(Spieler spieler) {
            this.punkte = spieler.endsumme();
            Eintrag eintrag = new Eintrag(spieler.toString(), DateFormat.getDateInstance(2, Locale.GERMANY).format(new Date()));
            this.eintraege.add(eintrag);
        }

        ArrayList<Eintrag> eintraege() {
            return this.eintraege;
        }

        Eintrag neuester() {
            return this.eintraege.get(this.eintraege.size() - 1);
        }

        int punkte() {
            return this.punkte;
        }

        int rangnummer() {
            return this.rangnummer;
        }

        void rangnummer(int rangnummer) {
            this.rangnummer = rangnummer;
        }

        class Eintrag
        implements Serializable {
            private static final long serialVersionUID = -6067121882006385994L;
            private final String name;
            private final String datum;
            private String kommentar = null;

            Eintrag(String name, String datum) {
                this.name = name;
                this.datum = datum;
            }

            String name() {
                return this.name;
            }

            String datum() {
                return this.datum;
            }

            String kommentar() {
                return this.kommentar;
            }

            void kommentar(String kommentar) {
                this.kommentar = kommentar;
            }
        }
    }
}

