/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.CEAblauf;
import jafuffy.CEJaFuffy;
import jafuffy.Eigenschaften;
import jafuffy.Grafik;
import jafuffy.Intro;
import jafuffy.Spieler;
import jafuffy.Turnier;
import jafuffy.Wuerfelfeld;
import jafuffy.Zettel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Spielplatz
extends JPanel
implements PropertyChangeListener,
ChangeListener {
    static final String INTRO = "Intro";
    static final String TEXT = "Text";
    static final String FELD = "Feld";
    private static final int KOMPONENTENRAND = 2;
    private static final ImageIcon KRANZ = Grafik.icon("Kranz.png");
    private static final Font TITEL = new Font("SansSerif", 3, 32);
    private static final Font UNTERTITEL = new Font("SansSerif", 1, 24);
    private final Zettel zettel = new Zettel();
    private final Wuerfelfeld wuerfelfeld = new Wuerfelfeld();

    Spielplatz() {
        super(new CardLayout());
        UIManager.addPropertyChangeListener(this);
        JPanel zettelfeld = new JPanel(new BorderLayout());
        zettelfeld.add((Component)this.zettel, "Center");
        this.add((Component)this.spielfeld(zettelfeld), FELD);
        this.add((Component)new Intro(), INTRO);
        this.add((Component)this.titelfeld(), TEXT);
        ((CardLayout)this.getLayout()).show(this, Eigenschaften.GLOBAL.aktiv(INTRO) ? INTRO : TEXT);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.wuerfelfeld.stateChanged(ce);
        this.zettel.stateChanged(ce);
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            switch ((CEAblauf)((Object)CEJaFuffy.ereignis(ce))) {
                case START: {
                    ((CardLayout)this.getLayout()).show(this, FELD);
                    break;
                }
                case RESULTAT: {
                    this.zeigeTurnierausgang((Turnier)ce.getSource());
                }
            }
        }
    }

    private JPanel spielfeld(JPanel zettelfeld) {
        JPanel spielfeld = new JPanel();
        spielfeld.setLayout(new BoxLayout(spielfeld, 0));
        zettelfeld.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        spielfeld.add(zettelfeld);
        this.wuerfelfeld.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        spielfeld.add(this.wuerfelfeld);
        return spielfeld;
    }

    private JPanel titelfeld() {
        JPanel titelfeld = new JPanel();
        titelfeld.setLayout(new BoxLayout(titelfeld, 3));
        JLabel titel = new JLabel("JaFuffy!", 0);
        titel.setEnabled(false);
        titel.setFont(TITEL);
        titel.setAlignmentX(0.5f);
        titelfeld.add((Component)titel, "Center");
        JLabel untertitel = new JLabel("- Das W\u00fcrfelspiel -", 0);
        untertitel.setEnabled(false);
        untertitel.setFont(UNTERTITEL);
        untertitel.setAlignmentX(0.5f);
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(titel);
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(untertitel);
        titelfeld.add(Box.createVerticalGlue());
        titelfeld.add(Box.createVerticalGlue());
        return titelfeld;
    }

    private void zeigeTurnierausgang(Turnier turnier) {
        JPanel rangliste = new JPanel();
        ArrayList<Spieler> spieler = turnier.spieler();
        if (spieler.size() == 1) {
            rangliste.setLayout(new GridLayout(1, 2));
            rangliste.add(new JLabel(spieler.get(0).toString(), 0));
            rangliste.add(new JLabel(String.valueOf(spieler.get(0).endsumme()) + " Punkte", 0));
        } else {
            Object[] plaetze = spieler.toArray();
            Arrays.sort(plaetze);
            int lowscore = ((Spieler)plaetze[spieler.size() - 1]).endsumme();
            rangliste.setLayout(new GridLayout(0, 3));
            int i = spieler.size() - 1;
            int rang = 1;
            while (i >= 0) {
                int score = ((Spieler)plaetze[i]).endsumme();
                if (score < lowscore) {
                    ++rang;
                    lowscore = score;
                }
                rangliste.add(new JLabel(String.valueOf(rang) + ". Platz: "));
                rangliste.add(new JLabel(((Spieler)plaetze[i]).toString()));
                rangliste.add(new JLabel(String.valueOf(score) + " Punkte", 4));
                --i;
            }
        }
        JOptionPane.showMessageDialog(this, rangliste, turnier.nummer() < turnier.anzahl() || turnier.anzahl() == 0 ? "JaFuffy (Resultat " + turnier.nummer() + ". Spiel)" : "JaFuffy (Resultat letztes Spiel)", 1, KRANZ);
    }
}

