/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Absprache;
import jafuffy.Bestenliste;
import jafuffy.Eigenschaften;
import jafuffy.Ende;
import jafuffy.Fenster;
import jafuffy.Fortsetzung;
import jafuffy.JaFuffyDialoge;
import jafuffy.Kommentierung;
import jafuffy.Menue;
import jafuffy.Oberflaeche;
import jafuffy.Pfad;
import jafuffy.Report;
import jafuffy.Ressource;
import jafuffy.Signal;
import jafuffy.Spielplatz;
import jafuffy.Starter;
import jafuffy.Statistik;
import jafuffy.Turnier;
import jafuffy.Update;
import jafuffy.Variante;
import jafuffy.Willkommen;
import jafuffy.Wuerfel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.swing.JApplet;
import javax.swing.border.EmptyBorder;

public class JaFuffy
extends JApplet
implements ActionListener {
    private static final String MINDEST_LANG_VERSION = "1.7";
    private static final String MINDEST_SWING_VERSION = "1.7";
    private static final String VERRIEGELUNGSDATEI = "JaFuffy.lock";
    private static final int RAHMENABSTAND = 4;
    private Oberflaeche oberflaeche;
    private Fenster fenster;
    private Absprache absprache;
    private Report report;
    private Bestenliste bestenliste;
    private Fortsetzung fortsetzung;
    private Ende ende;
    private Update update;
    private Statistik statistik = null;
    private Spielplatz spielplatz;
    private Menue menue;
    private Kommentierung kommentierung;
    private Turnier turnier;

    public static void main(String[] args) {
        JaFuffy.werteArgumenteAus(args);
        try {
            if (JaFuffy.laeuftSchon()) {
                JaFuffyDialoge.meldeMehrfachstart();
                System.exit(0);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if (Eigenschaften.GLOBAL.erststart()) {
            new Willkommen();
        }
        new JaFuffy(true);
    }

    private static boolean laeuftSchon() throws IOException {
        final File datei = new File(System.getProperty("java.io.tmpdir"), VERRIEGELUNGSDATEI);
        final RandomAccessFile stream = new RandomAccessFile(datei, "rw");
        FileChannel kanal = stream.getChannel();
        FileLock riegel = kanal.tryLock();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    stream.close();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
                datei.delete();
            }
        });
        return riegel == null;
    }

    private static void werteArgumenteAus(String[] args) {
        if (args.length > 1) {
            System.err.println("Maximal ein Argument erlaubt!");
        }
        if (args.length == 1) {
            if (args[0].equals("nosound")) {
                Ressource.schalteStumm();
                System.out.println("Sound ist abgeschaltet");
            } else {
                System.err.println("Option nicht bekannt!");
            }
        }
    }

    public JaFuffy() {
    }

    public JaFuffy(boolean dummy) {
        this.registriereAufraeumer();
        this.beschaffeStatistik();
        Oberflaeche.starteSpaeter(new Runnable(){

            @Override
            public void run() {
                JaFuffy.this.fenster = new Fenster("JaFuffy");
                JaFuffy.this.fortsetzung = new Fortsetzung(JaFuffy.this.fenster);
                JaFuffy.this.fortsetzung.addActionListener(JaFuffy.this);
                JaFuffy.this.ende = new Ende(JaFuffy.this.statistik, JaFuffy.this.fenster);
                JaFuffy.this.update = new Update(JaFuffy.this.fenster);
                JaFuffy.this.initialisiere();
                JaFuffy.this.oberflaeche.fenster(JaFuffy.this.fenster);
                JaFuffy.this.fenster.zeige(Eigenschaften.GLOBAL, JaFuffy.this.menue, JaFuffy.this.spielplatz, JaFuffy.this.ende);
                JaFuffy.this.pruefeAufUpdate();
                JaFuffy.this.bieteFortsetzungAn();
                Eigenschaften.GLOBAL.quittiereNeustartAnforderung();
            }
        });
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        String ac = event.getActionCommand();
        if (ac.equals("Start")) {
            Wuerfel w;
            int n;
            int n2;
            Wuerfel[] wuerfelArray;
            if (this.turnier != null) {
                this.turnier.beende();
                this.turnier.removeChangeListener(this.fenster);
                this.turnier.removeChangeListener(this.spielplatz);
                this.turnier.removeChangeListener(this.menue);
                this.turnier.removeChangeListener(this.ende);
                this.turnier.auswertung().removeChangeListener(this.spielplatz);
                wuerfelArray = this.turnier.wuerfel();
                n2 = wuerfelArray.length;
                n = 0;
                while (n < n2) {
                    w = wuerfelArray[n];
                    w.entferneChangeListener(this.spielplatz);
                    ++n;
                }
                if (this.fortsetzung != null) {
                    this.turnier.removeChangeListener(this.fortsetzung);
                }
            }
            this.turnier = ((Starter)event.getSource()).turnier();
            this.turnier.setzeFort(this.statistik);
            this.turnier.addChangeListener(this.fenster);
            this.turnier.addChangeListener(this.spielplatz);
            this.turnier.addChangeListener(this.menue);
            this.turnier.addChangeListener(this.ende);
            this.turnier.auswertung().addChangeListener(this.spielplatz);
            wuerfelArray = this.turnier.wuerfel();
            n2 = wuerfelArray.length;
            n = 0;
            while (n < n2) {
                w = wuerfelArray[n];
                w.installiereChangeListener(this.spielplatz);
                ++n;
            }
            if (this.fortsetzung != null) {
                this.turnier.addChangeListener(this.fortsetzung);
            }
            this.turnier.starte();
        }
    }

    @Override
    public final void init() {
        this.fortsetzung = null;
        this.ende = null;
        this.update = null;
        this.statistik = new Statistik();
        this.initialisiere();
        Oberflaeche.starteJetzt(new Runnable(){

            @Override
            public void run() {
                JaFuffy.this.setJMenuBar(JaFuffy.this.menue);
                JaFuffy.this.spielplatz.setBorder(new EmptyBorder(4, 4, 4, 4));
                JaFuffy.this.setContentPane(JaFuffy.this.spielplatz);
            }
        });
    }

    private void beschaffeStatistik() {
        File datei = Pfad.datei("Statistik.obj");
        if (datei.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(datei));
                this.statistik = (Statistik)ois.readObject();
                ois.close();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                Signal.ALARM.play();
                JaFuffyDialoge.meldeFehlendeStatistikdaten(e);
            }
        }
        this.statistik = new Statistik();
    }

    private void bieteFortsetzungAn() {
        File datei = Pfad.datei("Turnier0.obj");
        boolean kalt = Eigenschaften.GLOBAL.kaltstart();
        boolean warm = Eigenschaften.GLOBAL.warmstart();
        boolean erinnerung = Eigenschaften.GLOBAL.aktiv("Erinnerung");
        if ((kalt || warm || erinnerung) && datei.exists()) {
            if (erinnerung) {
                Signal.WARNUNG.play();
                if (JaFuffyDialoge.frageNachFortsetzung(this.fenster, datei)) {
                    this.fortsetzung.versucheAutomatik();
                }
            } else if (warm) {
                this.fortsetzung.versucheAutomatik();
            }
        }
    }

    private void initialisiere() {
        int variante;
        this.pruefeKompatibilitaet();
        this.oberflaeche = new Oberflaeche(Eigenschaften.GLOBAL);
        this.absprache = new Absprache();
        this.absprache.addActionListener(this);
        try {
            variante = Variante.valueOf(Eigenschaften.GLOBAL.getProperty("Variante")).ordinal();
        }
        catch (IllegalArgumentException e) {
            variante = Variante.KLASSISCH.ordinal();
            System.out.println(e);
        }
        this.bestenliste = new Bestenliste(this.statistik, variante);
        this.report = new Report(this.statistik);
        this.spielplatz = new Spielplatz();
        this.menue = new Menue(this.oberflaeche, this.spielplatz, this.absprache, this.report, this.bestenliste, this.fortsetzung, this.ende, this.update);
        this.kommentierung = new Kommentierung(this.spielplatz);
        this.statistik.addChangeListener(this.report);
        this.statistik.addChangeListener(this.bestenliste);
        this.statistik.addChangeListener(this.kommentierung);
    }

    private void pruefeAufUpdate() {
        if (Eigenschaften.GLOBAL.aktiv("Nachschauen")) {
            this.update.ueberpruefe();
        }
        this.update.aktiviereMitteilung();
    }

    private void pruefeKompatibilitaet() {
        Package lang = Package.getPackage("java.lang");
        Package swing = Package.getPackage("javax.swing");
        if (!lang.isCompatibleWith("1.7") || !swing.isCompatibleWith("1.7")) {
            JaFuffyDialoge.meldeVersionsproblem(lang, "1.7", swing, "1.7");
        }
    }

    private void registriereAufraeumer() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (Eigenschaften.GLOBAL.neustart()) {
                    try {
                        File jar = new File(JaFuffy.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                        try {
                            String java = String.valueOf(System.getProperty("java.home")) + "/bin/java";
                            StringBuffer cmd = new StringBuffer("\"" + java + "\"");
                            cmd.append(" -jar \"").append(jar.getPath()).append("\"");
                            Runtime.getRuntime().exec(cmd.toString());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (URISyntaxException exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
    }
}

