/*
 * Decompiled with CFR 0.152.
 */
package jafuffy;

import jafuffy.Ressource;
import jafuffy.Turnier;
import jafuffy.Variante;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.UIManager;

final class Eigenschaften
extends Properties {
    private static final String INI = "JaFuffy.ini";
    private static final String HINWEIS = "JaFuffy-Einstellungen (bitte nicht von Hand \u00e4ndern)";
    static final Eigenschaften GLOBAL;
    private File datei;

    static {
        Eigenschaften global;
        SecurityManager sicherheit = System.getSecurityManager();
        if (sicherheit == null) {
            String pfad = String.valueOf(System.getProperty("user.home")) + File.separator + INI;
            global = new Eigenschaften(new File(pfad));
        } else {
            try {
                sicherheit.checkPropertyAccess("user.home");
                String pfad = String.valueOf(System.getProperty("user.home")) + File.separator + INI;
                sicherheit.checkRead(pfad);
                sicherheit.checkWrite(pfad);
                global = new Eigenschaften(new File(pfad));
            }
            catch (SecurityException e) {
                global = new Eigenschaften();
            }
        }
        GLOBAL = global;
    }

    private Eigenschaften() {
        if (!Ressource.soundsystem()) {
            this.setProperty("Geraeusche", "passiv");
        }
        this.setzeStandard("LookAndFeel", UIManager.getCrossPlatformLookAndFeelClassName());
        this.setzeStandard("Variante", Variante.KLASSISCH.name());
        this.setzeStandard("Beginnmodus", Turnier.Beginner.VERLIERER.name());
        this.setzeStandard("Anzahl", "0");
        this.setzeStandard("Einfachklick", "passiv");
        this.setzeStandard("Hinweis", "aktiv");
        this.setzeStandard("Spicker", "aktiv");
        this.setzeStandard("Erinnerung", "aktiv");
        this.setzeStandard("Intro", "aktiv");
        this.setzeStandard("Geraeusche", "aktiv");
        this.setzeStandard("X", "0");
        this.setzeStandard("Y", "0");
        this.setzeStandard("Breite", "640");
        this.setzeStandard("Hoehe", "480");
        this.setzeStandard("Nachschauen", "passiv");
        this.setzeStandard("Starts", "0");
        this.setzeStandard("Zwischenstand", "passiv");
        this.setzeStandard("Neustart", "passiv");
    }

    private Eigenschaften(File datei) {
        this();
        if (datei.exists()) {
            try {
                FileInputStream reader = new FileInputStream(datei);
                this.load(reader);
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.datei = datei;
    }

    private void setzeStandard(String schluessel, String wert) {
        if (this.getProperty(schluessel) == null) {
            this.setProperty(schluessel, wert);
        }
    }

    boolean aktiv(String schluessel) {
        return this.getProperty(schluessel).equals("aktiv");
    }

    boolean erststart() {
        return this.getProperty("Starts").equals("0");
    }

    boolean kaltstart() {
        return this.getProperty("Neustart").equals("kalt");
    }

    void merkeNeustartAnforderung(boolean warm) {
        this.setProperty("Neustart", warm ? "warm" : "kalt");
    }

    boolean neustart() {
        return this.kaltstart() || this.warmstart();
    }

    void quittiereNeustartAnforderung() {
        this.setProperty("Neustart", "passiv");
    }

    void speichere(int x, int y, int b, int h) throws IOException {
        this.setProperty("X", String.valueOf(x));
        this.setProperty("Y", String.valueOf(y));
        this.setProperty("Breite", String.valueOf(b));
        this.setProperty("Hoehe", String.valueOf(h));
        this.setProperty("Starts", String.valueOf(Integer.parseInt(this.getProperty("Starts")) + 1));
        FileOutputStream writer = new FileOutputStream(this.datei);
        this.store(writer, HINWEIS);
        writer.close();
    }

    boolean warmstart() {
        return this.getProperty("Neustart").equals("warm");
    }

    void wechsle(String schluessel) {
        this.setProperty(schluessel, this.aktiv(schluessel) ? "passiv" : "aktiv");
    }
}

