/******************************************************************************
 ** $Id: Info.java 591 2014-08-02 12:29:04Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 6.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/** Information & Copyright-Hinweise. */
@SuppressWarnings("serial")
class Info extends JDialog implements PropertyChangeListener {

    // Homepage von JaFuffy
    private static final String HOMEPAGE = "http://jafuffy.3kelvin.de";
    // Icon
    private static final ImageIcon LOGO = Grafik.icon("Info.png");

    // Fonts
    private static final Font AUTOR = new Font("Dialog", Font.BOLD, 14);
    private static final Font TITEL = new Font("Dialog", Font.BOLD | Font.ITALIC, 18);

    /** Konstruktor. */
    Info() {

        UIManager.addPropertyChangeListener(this);

        JLabel label;
        JPanel info = new JPanel(new BorderLayout(4, 4));
        setContentPane(info);
        info.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        JPanel text = new JPanel();
        text.setLayout(new BoxLayout(text, BoxLayout.Y_AXIS));

        // Informationstext
        text.add(label = new JLabel("JaFuffy"));
        label.setFont(TITEL);
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        label = new JLabel(HOMEPAGE);
        label.addMouseListener(new MouseListener() {
            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(HOMEPAGE));
                } catch (Exception ex) {
                    System.out.println(ex);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                return;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                return;
            }
        });
        text.add(label);
        label.setForeground(Color.BLUE);
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        text.add(Box.createVerticalStrut(4));
        text.add(label = new JLabel(Package.getPackage("jafuffy").getImplementationVersion()));
        label.setFont(AUTOR);
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        text.add(label = new JLabel("von"));
        label.setFont(AUTOR);
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        text.add(label = new JLabel("Wolfgang Hauck"));
        label.setFont(AUTOR);
        label.setAlignmentX(Component.CENTER_ALIGNMENT);

        text.add(Box.createVerticalStrut(8));

        // Referenz an Autoren des Originals
        text.add(label = new JLabel("Nach dem Spiel Fuffy auf dem Atari ST -"));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        text.add(label = new JLabel("geschrieben im Jahr 1988 von"));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        text.add(label = new JLabel("Rudolf Brck und Jrgen Neervoort."));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);

        text.add(Box.createVerticalStrut(8));

        // Hinweis auf Lizenzierung
        text.add(label = new JLabel("(C) Wolfgang Hauck"));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        text.add(label = new JLabel("JaFuffy ist freie Software."));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);
        text.add(label = new JLabel("Siehe hierzu Meneintrag \"Lizenzierung\"."));
        label.setAlignmentX(Component.CENTER_ALIGNMENT);

        info.add(text, BorderLayout.NORTH);

        // OK-Button
        JButton ok = new JButton(LOGO);
        ok.setToolTipText("Anklicken um weiterzuspielen");
        ok.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        info.add(ok, BorderLayout.CENTER);
        ok.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });

        // Darstellung
        getRootPane().setDefaultButton(ok);
        setTitle("JaFuffy (Information)");
        setIconImages(Oberflaeche.LOGOS);
        setModal(true);
        pack();

    }

    /**
     * Realisiert Vernderungen des Look&Feel.
     * 
     * @param evt
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

}
